(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler       = elementorModules.frontend.handlers.Base,
            KFW_Counter_Minimal;

        KFW_Counter_Minimal = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        numberEle: '.kfw-ele-widget-counter-minl-number'
                    }
                }
            },

            getDefaultElements() {
                const selectors = this.getSettings( 'selectors' );
                return {
                    $numberEle: this.$element.find( selectors.numberEle ),
                };
            },

            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                if( !this.elements.$numberEle.length ) {
                    return;
                }

                var $mainSettings = this.getElementSettings();

                this.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                    callback: ( event ) => {
                        if ( event.isInViewport ) {
                            this.intersectionObserver.unobserve( this.elements.$numberEle[ 0 ] );

                            var $options = {
                                duration : $mainSettings.hasOwnProperty('duration') ? $mainSettings.duration              : 500,
                                fromValue: $mainSettings.hasOwnProperty('starting_number') ? $mainSettings.starting_number: 0,
                                toValue  : $mainSettings.hasOwnProperty('ending_number') ? $mainSettings.ending_number    : 0,
                                rounding : $mainSettings.hasOwnProperty('rounding') ? $mainSettings.rounding              : 0,
                            };

                            if( $mainSettings.hasOwnProperty('thousand_separator_char') ) {
                                if( $mainSettings.thousand_separator_char === 'default' ) {
                                    $options.delimiter = ',';
                                }

                                if( $mainSettings.thousand_separator_char === 'dot' ) {
                                    $options.delimiter = '.';
                                }

                                if( $mainSettings.thousand_separator_char === 'space' ) {
                                    $options.delimiter = ' ';
                                }

                                if( $mainSettings.thousand_separator_char === 'underline' ) {
                                    $options.delimiter = '-';
                                }

                                if( $mainSettings.thousand_separator_char === 'apostrophe' ) {
                                    $options.delimiter = "'";
                                }
                            }

                            this.elements.$numberEle.numerator( $options );
                        }
                    },
                });

                this.intersectionObserver.observe( this.elements.$numberEle[ 0 ] );
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-counter-minimal', KFW_Counter_Minimal );
    });
})( jQuery, window.elementorFrontend );