var $                          = jQuery.noConflict(),
    KIN_FW_EXTRA_ELEMENTOR_OBJ = KIN_FW_EXTRA_ELEMENTOR_OBJ || {};

(function($){
    "use strict";

    /**
     *  Custom CSS
     */
    KIN_FW_EXTRA_ELEMENTOR_OBJ.addCustomCss = function( css, context ) {

        if( "undefined" === typeof window.elementorPro ){

            if (!context) {
                return;
            }

            var model     = context.model,
                customCSS = model.get('settings').get('custom_css');

            var selector = '.elementor-element.elementor-element-' + model.get('id');

            if ('document' === model.get('elType')) {
                selector = elementor.config.document.settings.cssWrapperSelector;
            }

            if (customCSS) {
                css += customCSS.replace(/selector/g, selector);
            }

            return css;
        }
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.onSectionActivated = function( sectionName, editor ) {
		let editedElement = editor.getOption('editedElementView'),
            widgetType    = editedElement.model.get('widgetType');

        switch( widgetType ) {
            case 'kfw-flip-box-cover':
                KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxCover.init(sectionName, editedElement);
            break;

            case 'kfw-flip-box-cube':
                KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxCube.init(sectionName, editedElement);
            break;

            case 'kfw-flip-box-minimal':
                KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxMinimal.init(sectionName, editedElement);
            break;

            default:
            break;
        }
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.KFW_Image_Expand = function( panel, model, view ){
        var $element = view.$el.find( '.kfw-ele-widget-img-expand-wrapper' );

        if( $element.length ) {
            var $itemsWrap         = $( panel.$el.find('.elementor-control-items') );
            var $repeaterItemsWrap = $itemsWrap.find('.elementor-repeater-fields-wrapper');
            var $repeaterItems = $repeaterItemsWrap.children();

            var $items = $('.kfw-ele-img-expand-item', $element );

            for( let i =0; i < $repeaterItems.length; i++ ) {
                $repeaterItems[i].onclick = function( $ele ) {
                    $items.removeClass('kfw-ele-img-expand-active-item');

                    var $parent         = $( $ele.target ).parents(".elementor-repeater-fields");
                    var _id             = $parent.find('[data-setting="_id"]').val();
                    var $repeaterItemId = '#elementor-repeater-item-'+ _id;

                    $element.find( $repeaterItemId ).addClass('kfw-ele-img-expand-active-item');
                }
            }
        }
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.KFW_PTable_Clean = function( panel, model, view ){
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxCover = {
        init: function( sectionName, editedElement ) {
            let isBackSideSection = -1 !== ['section_back', 'section_back_style'].indexOf( sectionName ),
                backLayer         = editedElement.$el.find('.kfw-ele-widget-flip-box-back');

            editedElement.$el.toggleClass('kfw-ele-widget-flip-box-cover-wrap-flipped', isBackSideSection);

			if( isBackSideSection ) {
				backLayer.css('transition', 'none');
			}

			if( !isBackSideSection ) {

				setTimeout(function () {
					backLayer.css('transition', '');
				}, 10);
			}
        },
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxCube = {
        init: function( sectionName, editedElement ) {
            let isBackSideSection = -1 !== ['section_back', 'section_back_style'].indexOf( sectionName ),
                backLayer         = editedElement.$el.find('.kfw-ele-widget-flip-box-back');

            editedElement.$el.toggleClass('kfw-ele-widget-flip-box-cube-wrap-flipped', isBackSideSection);

			if( isBackSideSection ) {
				backLayer.css('transition', 'none');
			}

			if( !isBackSideSection ) {

				setTimeout(function () {
					backLayer.css('transition', '');
				}, 10);
			}
        },
    },

    KIN_FW_EXTRA_ELEMENTOR_OBJ.FlipBoxMinimal = {
        init: function( sectionName, editedElement ) {
            let isBackSideSection = -1 !== ['section_back', 'section_back_style'].indexOf( sectionName ),
                backLayer         = editedElement.$el.find('.kfw-ele-widget-flip-box-back');

            editedElement.$el.toggleClass('kfw-ele-widget-flip-box-minl-wrap-flipped', isBackSideSection);

			if( isBackSideSection ) {
				backLayer.css('transition', 'none');
			}

			if( !isBackSideSection ) {

				setTimeout(function () {
					backLayer.css('transition', '');
				}, 10);
			}
        },
    },

    /**
     * Init
     */
    KIN_FW_EXTRA_ELEMENTOR_OBJ.init = function() {

        elementor.on( 'frontend:init', function() {});

        elementor.on( 'preview:loaded', function() {});

        elementor.channels.editor.on( 'section:activated', function( sectionName, editor ) {
            KIN_FW_EXTRA_ELEMENTOR_OBJ.onSectionActivated( sectionName, editor );
        });

        elementor.hooks.addFilter('editor/style/styleText', KIN_FW_EXTRA_ELEMENTOR_OBJ.addCustomCss );
    },

    $(window).on( 'elementor:init', KIN_FW_EXTRA_ELEMENTOR_OBJ.init );

    $(window).load(function(){
        elementor.hooks.addFilter('editor/style/styleText', KIN_FW_EXTRA_ELEMENTOR_OBJ.addCustomCss );
        elementor.hooks.addAction('panel/open_editor/widget/kfw-image-expand',KIN_FW_EXTRA_ELEMENTOR_OBJ.KFW_Image_Expand );
        elementor.hooks.addAction('panel/open_editor/widget/kfw-pricing-table-clean',KIN_FW_EXTRA_ELEMENTOR_OBJ.KFW_PTable_Clean );
    });
})(jQuery);