(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_GMap;

        KFW_GMap = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-google-map-main',
                    }
                }
            },
            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main : this.$element.find( main ),
                }
            },
            bindEvents: function () {
                this._execute();
            },
            _execute: function() {
                let $this    = this,
                    $id      = $this.getID(),
                    $main    = $this.elements.$main;

                let $settings = $main.data('settings'),
                    $markers  = $main.data('markers'),
                    $map      = $('.kfw-ele-widget-google-map', $main )[0];

                if( null !== $settings) {
                    let $mapObj = new google.maps.Map($map, $settings );

                    if( $markers ) {
                        $.each($markers, function($index, $marker ){
                            let $pin,
                                $infowindow,
                                $pinContent = '',
                                $pinData = {
                                    position: new google.maps.LatLng( $marker.latitude, $marker.longitude ),
                                    map     : $mapObj,
                                    title   : $marker.name,
                                };

                            if ( '' !== $marker.pin ) {
                                $pinData.icon = $marker.pin;
                            }

                            if( $marker.name.length) {
                                $pinContent += '<div class="kfw-google-map-name">' + $marker.name + '</div>';
                            }

                            if( $marker.content.length) {
                                $pinContent += '<div class="kfw-google-map-content">' + $marker.content + '</div>';
                            }

                            if( $marker.phone.length) {
                                $pinContent += '<div class="kfw-google-map-phone"> <a href="tel:'+ $marker.phone +'">' + $marker.phone + '</a></div>';
                            }

                            if( $marker.websiteLink.length) {
                                $pinContent += '<div class="kfw-google-map-website"> <a href="'+ $marker.websiteLink +'">' + $marker.websiteName + '</a></div>';
                            }

                            $pin        = new google.maps.Marker( $pinData );
                            $infowindow = new google.maps.InfoWindow({
                                content       : '<div class="kfw-google-map-info">' + $pinContent + '</div>',
                                disableAutoPan: true
                            });

                            $pin.addListener( 'click', function() {
                                $infowindow.setOptions({disableAutoPan: false});
                                $infowindow.open($mapObj, $pin);
                            });

                            if( 'visible' === $marker.state && $pinContent.length ) {
                                $infowindow.open($mapObj, $pin);
                            }
                        });
                    }
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-google-map', KFW_GMap );

    });
})( jQuery, window.elementorFrontend );