(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Split_Scroll;

        KFW_Split_Scroll = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-split-scroll-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this   = this,
                    $type   = $this.elements.$main.data('splitStyle'),
                    $isEdit = $this.isEdit ? true : false;

                if( !$this._isMobile() ) {

                    if( 'type-1' === $type ) {
                        this._executeType1();
                    } else if( 'type-2' === $type ) {
                        this._executeType2();
                    } else if( 'type-3' === $type ) {
                        this._executeType3();
                    }
                }
            },

            _executeType3() {
                gsap.registerPlugin(ScrollTrigger);

                gsap.config({
                    nullTargetWarn: false,
                    trialWarn: false
                });

                let $id                 = this.getID(),
                    $main               = this.elements.$main,
                    $imgSecWrap         = $('.kfw-elementor-split-scroll-r-items-wrap', $main ),
                    $allImgSecs         = $('.kfw-elementor-split-scroll-img-item', $main ),
                    $imgItemsExceptLast = $('.kfw-elementor-split-scroll-img-item:not(:last-child)', $main );

                let mm = gsap.matchMedia();

                // this setup code only runs when viewport is at least 600px wide
                mm.add("(min-width: 992px)",function(){
                    gsap.set( $allImgSecs, {
                        zIndex: function( $idx, $target, $targets ) {
                            return $targets.length - $idx;
                        }
                    });

                    $imgItemsExceptLast.each(function( $idx, $img ){
                        let tl = gsap.timeline({
                            scrollTrigger: {
                                trigger            : $main,
                                start              : function() { return "top -" + (window.innerHeight * ($idx)); },
                                end                : function() { return "+=" + window.innerHeight; },
                                toggleActions      : "play none reverse none",
                                scrub              : true,
                                markers            : false,
                                invalidateOnRefresh: true,
                            }
                        });

                        tl.fromTo($img, { height: () => { return "100%" } }, { height: () => { return "0%" }, ease: "none" });
                    });

                    ScrollTrigger.create({
                        trigger : $main,
                        start   : "top 15%",
                        end     : "bottom bottom",
                        pin     : $imgSecWrap,
                        scrub   : true,
                        markers : false,
                    });
                });
            },

            _executeType2() {
                gsap.registerPlugin(ScrollTrigger);

                gsap.config({
                    nullTargetWarn: false,
                    trialWarn: false
                });

                let $id                  = this.getID(),
                    $main                = this.elements.$main,
                    $imgSecWrap          = $('.kfw-elementor-split-scroll-r-items-wrap', $main ),
                    $imgItemsExceptFirst = $('.kfw-elementor-split-scroll-img-item:not(:first-child)', $main );

                let mm = gsap.matchMedia();

                // this setup code only runs when viewport is at least 600px wide
                mm.add("(min-width: 992px)",function(){
                    gsap.set($imgItemsExceptFirst,{
                        opacity: 0,
                        scale  : 0.5,
                    });

                    const $animation = gsap.to($imgItemsExceptFirst, {
                        opacity : 1,
                        scale   : 1,
                        duration: 1,
                        stagger : 1
                    });

                    ScrollTrigger.create({
                        trigger  : $main,
                        start    : "top 15%",
                        end      : "bottom bottom",
                        pin      : $imgSecWrap,
                        animation: $animation,
                        scrub    : true,
                        markers  : false
                    });
                });
            },

            _executeType1() {
                gsap.registerPlugin(ScrollTrigger);

                gsap.config({
                    nullTargetWarn: false,
                    trialWarn     : false
                });

                let $id                  = this.getID(),
                    $main                = this.elements.$main,
                    $imgSecWrap          = $('.kfw-elementor-split-scroll-r-items-wrap', $main ),
                    $imgItemsExceptFirst = $('.kfw-elementor-split-scroll-img-item:not(:first-child)', $main );

                let mm = gsap.matchMedia();

                // this setup code only runs when viewport is at least 600px wide
                mm.add("(min-width: 992px)",function(){
                    gsap.set($imgItemsExceptFirst,{
                        opacity:0
                    });

                    const $animation = gsap.to($imgItemsExceptFirst, {
                        opacity : 1,
                        duration: 1,
                        stagger : 1
                    });

                    ScrollTrigger.create({
                        trigger  : $main,
                        start    : "top 15%",
                        end      : "bottom bottom",
                        pin      : $imgSecWrap,
                        animation: $animation,
                        scrub    : true,
                        markers  : false
                    });
                });
            },

            _isMobile() {
                let isAndroid    = navigator.userAgent.match(/Android/i),
                    isBlackBerry = navigator.userAgent.match(/BlackBerry/i),
                    isIOS        = navigator.userAgent.match(/iPhone|iPad|iPod/i),
                    isOpera      = navigator.userAgent.match(/Opera Mini/i),
                    isWindows    = navigator.userAgent.match(/IEMobile|Windows Phone/i);

                return (
                    isAndroid ||
                    isBlackBerry ||
                    isIOS ||
                    isOpera ||
                    isWindows
                );
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-split-scroll', KFW_Split_Scroll );
    });
})( jQuery, window.elementorFrontend );
