(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Tabs;

        KFW_Tabs = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main      : '.kfw-ele-widget-tabs-main',
                        tabTitle  : '.kfw-elementor-tabs-tab',
                        tabContent: '.kfw-elementor-tabs-content'
                    },
                    classes: {
                        active: 'kfw-elementor-active-tab',
                    },
                    showTabFn: 'show',
                    hideTabFn: 'hide',
                }
            },

            getDefaultElements() {
                const { main, tabTitle, tabContent } = this.getSettings( 'selectors' );

                return {
                    $main       : this.findElement( main ),
                    $tabTitles  : this.findElement( tabTitle ),
                    $tabContents: this.findElement( tabContent ),
                }
            },

            bindEvents: function () {
                this._activateDefaultTab();

                this.elements.$tabTitles.on({
                    click: ( event ) => {
                        event.preventDefault();
                        this._changeActiveTab( event.currentTarget.getAttribute( 'data-id' ) );
                    },
                });
            },

            _changeActiveTab( $tabIndex ) {

                this._deactivateActiveTab();

                const $isActiveTab = this._isActiveTab( $tabIndex );

                if( $isActiveTab ) {
                    this._deactivateActiveTab( $tabIndex );
                }

                if(!$isActiveTab ) {
                    this._activateTab( $tabIndex );
                }
            },

            _isActiveTab( $tabIndex ) {
                return this.elements.$tabTitles
                    .filter( '[data-id="' + $tabIndex + '"]' )
                    .hasClass( this.getSettings( 'classes.active' ) );
            },

            _deactivateActiveTab( $tabIndex ) {
                const $activeClass   = this.getSettings( 'classes.active' ),
                      $activeFilter  = $tabIndex ? '[data-id="' + tabIndex + '"]' : '.' + $activeClass,
                      $activeTitle   = this.elements.$tabTitles.filter( $activeFilter ),
                      $activeContent = this.elements.$tabContents.filter( $activeFilter );

                $activeTitle.add( $activeContent ).removeClass( $activeClass );
                $activeContent[ this.getSettings( 'hideTabFn' ) ]();
                $activeContent.attr( 'hidden', 'hidden' );
            },

            _activateTab( $tabIndex ) {
                const $activeClass      = this.getSettings( 'classes.active' ),
                      $requestedTitle   = this.elements.$tabTitles.filter( '[data-id="' + $tabIndex + '"]' ),
                      $requestedContent = this.elements.$tabContents.filter( '[data-id="' + $tabIndex + '"]' );

                $requestedTitle.add( $requestedContent ).addClass( $activeClass );
                $requestedContent[ this.getSettings( 'showTabFn' ) ]();
                $requestedContent.removeAttr( 'hidden' );
            },

            _activateDefaultTab() {
                const $tabIndex = this.elements.$main.attr('data-default-tab');
                this._activateTab( $tabIndex );
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-tabs', KFW_Tabs );
    });
})( jQuery, window.elementorFrontend );