(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Theme_Btn;

        KFW_Theme_Btn = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-theme-button-main',
                        mainID : '#kfw-ele-widget-theme-button-' + this.getID(),
                    },
                    magneticStrength:500
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this     = this,
                    $id       = this.getID(),
                    $main = this.elements.$main;

                if( this.$element.hasClass('kfw-ele-button-magnetic-effect') ) {

                    let $mainID           = $this.getSettings( 'selectors.mainID')
                    let $magneticStrength = $this.getSettings( 'magneticStrength' );
                    let $mainEle          = document.querySelector( $mainID );

                    $mainEle.addEventListener('mousemove', function(e){
                        const rect      = $mainEle.getBoundingClientRect();
                        const distanceX = e.clientX - (rect.left + rect.width / 2);
                        const distanceY = e.clientY - (rect.top + rect.height / 2);
                        const $distance = Math.sqrt(distanceX ** 2 + distanceY ** 2);

                        if ($distance < $magneticStrength) {
                            gsap.to($main, {
                                x: distanceX / 5,
                                y: distanceY / 5,
                                duration: 0.3,
                                ease: "power2.out"
                            });
                        }
                    });

                    $mainEle.addEventListener('mouseleave', function(){
                        gsap.to($mainEle, {
                            x: 0,
                            y: 0,
                            duration: 0.3,
                            ease: "power2.out"
                        });
                    });
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-theme-button', KFW_Theme_Btn );
    });
})( jQuery, window.elementorFrontend );
