<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extensions_Manager' ) ) {

	/**
	 * Elementor extensions setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extensions_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default values of settings.
         */
        private $default = [];

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            $this->default = $this->defaults();

			add_action( 'kinfw-action/theme/site-options/elementor/loaded', [ $this, 'settings' ], 10  );

			$this->load_modules();

            do_action( 'kinfw-action/plugin/elementor/extensions/loaded' );

		}

		public function settings() {

			$fields = [];

			// GSAP ScrollSmoother
			array_push( $fields, [
				'type'    => 'switcher',
				'id'      => 'elementor_ext_gsap_scrollsmoother',
				'title'   => esc_html__( 'GSAP Scroll Smoother', 'onnat-extra'),
				'desc'    => esc_html__( 'Vertical Smooth Scrolling effect.', 'onnat-extra' ),
				'default' => $this->default['elementor_ext_gsap_scrollsmoother'],
			] );

			// Shape Shift for elementor container and section
			array_push( $fields, [
				'type'    => 'switcher',
				'id'      => 'elementor_ext_shape_shift',
				'title'   => esc_html__( 'ShapeShift', 'onnat-extra'),
				'desc'    => esc_html__( 'Smoothly transition section shapes with dynamic scroll effect.', 'onnat-extra' ),
				'default' => $this->default['elementor_ext_shape_shift'],
			] );

			// Hover image for elementor container, section and column
			array_push( $fields, [
				'type'    => 'switcher',
				'id'      => 'elementor_ext_ele_hover_image',
				'title'   => esc_html__( 'Hover Image', 'onnat-extra'),
				'desc'    => esc_html__( 'Add Hover Image for Elementor containers,sections and columns.', 'onnat-extra' ),
				'default' => $this->default['elementor_ext_ele_hover_image'],
			] );

			// Element Wrapper
			array_push( $fields, [
					'type'    => 'switcher',
					'id'      => 'elementor_ext_wrapper_link',
					'title'   => esc_html__( 'Wrapper Link', 'onnat-extra'),
					'desc'    => esc_html__( 'Attach a link to the elemntor widgets.', 'onnat-extra' ),
					'default' => $this->default['elementor_ext_wrapper_link'],
			] );

			// Advance Positioning
			array_push( $fields, [
				'type'    => 'switcher',
				'id'      => 'elementor_ext_adv_positioning',
				'title'   => esc_html__( 'Advance Positioning', 'onnat-extra'),
				'desc'    => esc_html__( 'Add custom advance positioning to elemntor elements.', 'onnat-extra' ),
				'default' => $this->default['elementor_ext_adv_positioning'],
			] );

			// CSS Pseudo
			array_push( $fields, [
				'type'    => 'switcher',
				'id'      => 'elementor_ext_css_pseudo',
				'title'   => esc_html__( 'CSS Pseudo', 'onnat-extra'),
				'desc'    => esc_html__( 'CSS ::after and ::before selector to the elementor widgets.', 'onnat-extra' ),
				'default' => $this->default['elementor_ext_css_pseudo'],
			] );

			if( ! defined('ELEMENTOR_PRO_VERSION') ) {

				// Motion Effect
				array_push( $fields, [
					'type'    => 'switcher',
					'id'      => 'elementor_ext_motion_fx',
					'title'   => esc_html__( 'Motion Effect', 'onnat-extra'),
					'desc'    => esc_html__( 'Add motion effect extension to the elementor.', 'onnat-extra' ),
					'default' => $this->default['elementor_ext_motion_fx'],
				] );

				// Custom CSS
				array_push( $fields, [
					'type'    => 'switcher',
					'id'      => 'elementor_ext_custom_css',
					'title'   => esc_html__( 'Custom CSS', 'onnat-extra'),
					'desc'    => esc_html__( 'Add custom css to the elementor widgets.', 'onnat-extra' ),
					'default' => $this->default['elementor_ext_css_pseudo'],
				] );

			}

            CSF::createSection( ONNAT_CONST_THEME_OPTION_PREFIX, [
                'parent' => 'theme_elementor_section',
                'title'  => esc_html__( 'Extensions', 'onnat-extra' ),
                'fields' =>  $fields
			] );

		}

        public function defaults( $defaults = [] ) {

			$defaults['elementor_ext_gsap_scrollsmoother'] = true;
			$defaults['elementor_ext_shape_shift']         = true;
			$defaults['elementor_ext_ele_hover_image']     = true;
			$defaults['elementor_ext_wrapper_link']        = true;
			$defaults['elementor_ext_adv_positioning']     = true;
			$defaults['elementor_ext_css_pseudo']          = true;
			$defaults['elementor_ext_motion_fx']           = true;
			$defaults['elementor_ext_custom_css']          = true;

            return $defaults;

		}

		public function load_modules() {

			/**
			 * GSAP ScrollSmoother
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/gsap-scroll-smoother/class-ele-scroll-smoother.php';			

			/**
			 * Shape Shift
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/shape-shift/class-ele-shape-shift.php';

			/**
			 * Hover Image
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/hover-image/class-ele-hover-image.php';

			/**
			 * Wrapper Link Extension
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/wrapper-link/class-wrapper-link.php';

			/**
			 * Advance Positioning Extension
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/advance-positioning/class-advance-positioning.php';

			/**
			 * CSS Pseudo Extension
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/css-pseudo/class-css-pseudo.php';

			/**
			 * KinForce Custom Cursor Extension
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/extensions/cursor/class-cursor.php';

			if( ! defined('ELEMENTOR_PRO_VERSION') ) {

				/**
				 * Motion Fx Extension
				 */
				require_once KFE_CONST_DIR . 'libraries/elementor/extensions/motion-fx/class-motion-fx.php';

				/**
				 * Custom CSS Extension
				 */
				require_once KFE_CONST_DIR . 'libraries/elementor/extensions/custom-css/class-custom-css.php';

			}

		}

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extensions_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extensions_manager() {

        return KinForce_Extra_Plugin_Elementor_Extensions_Manager::get_instance();
    }
}

kf_extra_plugin_elementor_extensions_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */