<?php
/**
 * Widget Template : Blockquote
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-blockquote-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-blockquote-main',
        'kfw-ele-widget-blockquote-'.esc_attr( $settings['type'] ),
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $author = $role = '';

    if( !empty( $settings['author'] ) ) {
        $author = sprintf( '<div class="kfw-ele-widget-blockquote-author">%1$s</div>', $settings['author'] );
    }

    if( !empty( $settings['role'] ) ) {
        $role = sprintf( '<div class="kfw-ele-widget-blockquote-role">%1$s</div>',$settings['role'] );
    }

    if( !empty( $author ) || !empty( $role ) ) {
        printf( '<div class="kfw-ele-widget-blockquote-meta">%1$s %2$s</div>', $author, $role );
    }

    if( $settings['quote_symbol'] == 'yes' ) {
        printf( '<blockquote class="kfw-ele-widget-blockquote-symbol">%1$s</blockquote>', wp_kses_post( $settings['quote'] ) );
    } else {
        printf( '<blockquote class="kfw-ele-widget-blockquote-has-no-symbol">%1$s</blockquote>', wp_kses_post( $settings['quote'] ) );
    }

echo '</div>';