<?php
/**
 * Widget Template : Blog Post List
 */
$settings  = $this->get_settings();
$post_ids  = $this->_post_ids( $settings['items'] );
$post_data = $this->_post_data( $settings['items'] );
$post_meta = $this->_post_meta( $settings['meta'] );

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-blog-post-list-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-blog-post-list-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    if( count( $post_ids ) > 0 ) {

        $the_query = new WP_Query([
            'post_type'   => 'post',
            'post_status' => 'publish',
            'post__in'    => $post_ids,
            'orderby'     => 'post__in'
        ]);

        if ( $the_query->have_posts() ) {
            echo '<div class="kinfw-blog-posts-list-wrap">';

            while( $the_query->have_posts() ) {

                $the_query->the_post();

                $classes   = [];
                $post_id   = get_the_ID();
                $post_info = $post_data[ $post_id ];

                if( !empty( $post_info['flip'] ) ) {
                    $classes[] = 'kinfw-blog-post-flip';
                }

                get_template_part(
                    'template-parts/archive/kfw-blog-list-widget/content',
                    get_post_format(),
                    ['classes' => $classes, 'meta' => $post_meta, ]
                );

            }

            echo '</div>';
        }

        wp_reset_postdata();

    }
echo '</div>';