<?php
/**
 * Widget Template : Blog Post Single Meta
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

$post_id = get_the_ID();
$mode    = $this->_is_editor_mode();

if( $mode ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'post' );
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-meta-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-post-meta-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    echo '<div class="kfw-ele-widget-post-meta-wrap">';
        foreach( $items as $index => $item ):
            $meta = $item['meta'];

            switch( $meta ) {
                case 'author':
                    $this->render_author_info( $item, $post_id );
                break;

                case 'category':
                    $this->render_category_info( $item, $post_id );
                break;

                case 'date':
                    $this->render_date_info( $item, $post_id );
                break;

                case 'comment':
                    $this->render_comment_info( $item, $post_id );
                break;

                case 'reading':
                    $this->render_reading_info( $item, $post_id );
                break;

                case 'tag':
                    $this->render_tag_info( $item, $post_id );
                break;
            }
        endforeach;
    echo '</div>';
echo '</div>';