<?php
/**
 * Widget Template : Blog Post Single Social Share
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$post_title = get_the_title();
$permalink  = get_the_permalink();
$mode       = $this->_is_editor_mode();

if( $mode ) {
    $post_id    = kf_extra_plugin_elementor()->get_latest_post_id( 'post' );
    $post_title = get_the_title( $post_id );
    $permalink  = get_the_permalink( $post_id );
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-social-share-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-post-social-share-main' ],
]);


$class_animation = '';
if ( ! empty( $settings['hover_animation'] ) ) {
    $class_animation = ' elementor-animation-' . $settings['hover_animation'];
}

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    echo '<div class="elementor-social-icons-wrapper elementor-grid">';
        foreach ( $settings['items'] as $index => $item ) {

            $link_key = 'link_' . $index;
            $this->add_render_attribute( $link_key, 'class', [
                'elementor-icon',
                'elementor-social-icon',
                'elementor-social-icon-' . $item['medium'] . $class_animation,
                'elementor-repeater-item-' . $item['_id'],
            ] );

            $this->add_render_attribute( $link_key, 'data-social', $item['medium'] );
            $this->add_render_attribute( $link_key, 'href', $permalink );

            echo '<span class="elementor-grid-item">';
                ?>
                <a <?php $this->print_render_attribute_string( $link_key ); ?>>
                    <?php $this->_render_icon( $item['icon'] ); ?>
                </a>
                <?php
            echo '</span>';
        }
    echo '</div>';
echo '</div>';