<?php
/**
 * Widget Template : Blog Template
 */

$settings = $this->get_settings();
$layout   = $settings['layout'];

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-blog-tpl-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-blog-tpl-main',
        'kfw-ele-widget-blog-tpl-'. $layout
    ]
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $args      = $this->get_args( $settings );
    $the_query = new WP_Query( $args );

    if( $the_query->have_posts() ) {

        echo '<div class="kinfw-blog-posts-wrap">';

        while( $the_query->have_posts() ) {

            $the_query->the_post();

            get_template_part( 'template-parts/archive/'. $layout . '/content', get_post_format(), );

        }

        echo '</div>';

        // Pagination
        $pagination = paginate_links([
            'total'     => $the_query->max_num_pages,
            'end_size'  => 4,
            'prev_text' => kinfw_icon( 'onnat-line-arrow-long-left-tiny' ),
            'next_text' => kinfw_icon( 'onnat-line-arrow-long-right-tiny' ),
        ]);

        if( $pagination ) :
            printf( '<div id="kinfw-blog-pagination">%1$s</div>', _navigation_markup( $pagination ) );
        endif;

    } else {

        get_template_part( 'content', 'none' );

    }

    wp_reset_postdata();

echo '</div>';