<?php
/**
 * Widget Template : Brands Carousel
 */

$mode     = $this->_is_editor_mode();
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'            => 'kfw-ele-widget-brands-carousel-'.esc_attr( $this->get_id() ),
	'class'         => [
        'kfw-ele-widget-brands-carousel-main'
    ],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'swiper', [
        'data-id' => 'kfw-js-swiper-'.esc_attr( $this->get_id() ),
        'class'   => array_filter( [
            'kfw-js-swiper-'.esc_attr( $this->get_id() ),
            'kfw-swiper',
            'swiper',
            'swiper-container',
        ])
    ]);
    echo '<div '. $this->get_render_attribute_string( 'swiper' ) .'>';

        $this->add_render_attribute( 'list', [
            'class' => array_filter( [
                'kfw-ele-brands-carousel-list',
                'swiper-wrapper'
            ])
        ]);
        echo '<div '. $this->get_render_attribute_string( 'list' ) .'>';

            foreach( $items as $index => $item ) {
                $b_item  = $this->get_repeater_setting_key( 'b-item', 'b-items', $index );
                $classes = [
                    'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    'kfw-ele-widget-brands-carousel-item',
                    'swiper-slide',
                ];

                if( $item['enable_link'] === 'yes' && !empty( $item['link']['url'] ) ) {
                    $link   = $item['link']['url'];
                    $target = ( !empty( $item['link']['is_external'] ) ) ? '_blank' : '_self';

                    if( !$mode ) {
                        $this->add_render_attribute( $b_item, 'onclick', 'window.open("'. esc_url( $link ) .'", "'. $target .'");');
                    }

                    $classes[] = 'kfw-ele-widget-brands-carousel-item-linked';
                }

                $this->add_render_attribute( $b_item, [ 'class' => array_filter( $classes ) ] );
                echo '<div '. $this->get_render_attribute_string( $b_item ) .'>';

                    $item_image_wrapper = $this->get_repeater_setting_key( 'image-item-wrap', 'b-items', $index );
                    $this->add_render_attribute( $item_image_wrapper, [
                        'class' => array_filter([
                            'kfw-ele-widget-brands-carousel-image-wrapper',
                            ( $item['hover'] === 'gray' ) ? 'kfw-ele-widget-brands-carousel-gray-image' : '',
                            ( $item['hover'] === 'image' ) ? 'kfw-ele-widget-brands-carousel-hover-image' : '',
                        ])
                    ]);
                    echo '<div '.$this->get_render_attribute_string( $item_image_wrapper ).'>';
                        /**
                         * Image
                         */
                        if( !empty( $item['image']['url'] ) ) {

                            $image_src = $this->_get_image_src( $item['image']['id'], 'image_size', $settings );
                            $image_src = empty($image_src) ? $item['image']['url'] : $image_src;

                            $image_title = $this->_get_image_title( $item['image'] );
                            $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                            $image_alt = $this->_get_image_alt( $item['image'] );
                            $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                            $image_attr = $this->get_repeater_setting_key( 'image-item', 'b-items', $index );

                            $this->add_render_attribute( $image_attr, [
                                'class' => 'kfw-ele-widget-brands-carousel-image kfw-image-is-loading',
                                'alt'   => esc_attr( $image_alt ),
                                'title' => esc_attr( $image_title ),
                                'src'   => esc_url( $image_src ),
                            ]);

                            echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';

                        }

                        /**
                         * Hover Image
                         */
                        if( $item['hover'] === 'image' && !empty( $item['himage']['url'] ) ) {

                            $image_src = $this->_get_image_src( $item['himage']['id'], 'image_size', $settings );
                            $image_src = empty($image_src) ? $item['himage']['url'] : $image_src;

                            $image_title = $this->_get_image_title( $item['himage'] );
                            $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                            $image_alt = $this->_get_image_alt( $item['himage'] );
                            $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                            $image_attr = $this->get_repeater_setting_key( 'himage-item', 'b-items', $index );

                            $this->add_render_attribute( $image_attr, [
                                'class' => 'kfw-ele-widget-brands-carousel-image kfw-ele-widget-brands-carousel-hover-image kfw-image-is-loading',
                                'alt'   => esc_attr( $image_alt ),
                                'title' => esc_attr( $image_title ),
                                'src'   => esc_url( $image_src ),
                            ]);

                            echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                        }
                    echo '</div>';

                echo '</div>';
            }

        echo '</div>';

    echo '</div>';

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] !== 'custom' ) {
        /**
         * Navigation
         */
        $this->add_render_attribute( 'navEl', [
            'class' => array_filter( [
                'kfw-brands-carousel-nav-wrap',
                'kfw-brands-carousel-nav-pos-'. $settings['arrow_position'],
                $settings['mobile_arrows'] === 'yes' ? 'hide-on-sm hide-on-xs' : ''
            ] )
        ] );

        echo '<div '.$this->get_render_attribute_string( 'navEl' ).'>';

            $this->add_render_attribute( 'prevEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-prev',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'prevEl' ).'>';
                $this->_render_icon( $settings['right_arrow'] );
            echo '</div>';

            $this->add_render_attribute( 'nextEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-next',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'nextEl' ).'>';
                $this->_render_icon( $settings['left_arrow'] );
            echo '</div>';

        echo '</div>';
    }

    if( $settings['dots'] === 'yes' ) {

        /**
         * Pagination
         */
        $this->add_render_attribute( 'pagination', [
            'class' => array_filter( [
                'kfw-swiper-pagination',
                'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination'
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'pagination' ).'></div>';
    }

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] === 'custom' ) {
        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-next %2$s for Next Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );

        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-prev %2$s for Prev Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );
    }

echo '</div>';