<?php
/**
 * Widget Template : Counter Minimal
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-counter-minl-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-counter-minl-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	if( $settings['icon_type'] !== 'blank'  ) {
		/**
		 * Icon
		 */
		$this->add_render_attribute( 'icon-wrap', [
			'class' => array_filter([
				'kfw-ele-widget-counter-minl-icon-wrap',
				'kfw-ele-widget-counter-minl-'. esc_attr( $settings['icon_type'] ) .'-type',
			]),
		]);
		echo '<div '.$this->get_render_attribute_string( 'icon-wrap' ).'>';

			$this->add_render_attribute( 'icon', [
				'class' => array_filter([ 'kfw-ele-widget-counter-minl-icon',]),
			]);
			echo '<span '.$this->get_render_attribute_string( 'icon' ).'>';
				if( $settings['icon_type'] === 'icon'  ) {
					$this->_render_icon( $settings['icon'] );
				} else if( $settings['icon_type'] === 'image' ) {
					$this->_render_img();
				}
			echo '</span>';
		echo '</div>';
	}

	/**
	 * Content
	 */
	$this->add_render_attribute( 'content-wrap', [
		'class' => array_filter([ 'kfw-ele-widget-counter-minl-content-wrap',]),
	]);
	echo '<div '.$this->get_render_attribute_string( 'content-wrap' ).'>';

		/**
		 * Title
		 */
		if( $settings['title_pos'] === 'top' ) {
			$this->_counter_title();
		}


		$this->add_render_attribute( 'content', [
			'class' => array_filter([ 'kfw-ele-widget-counter-minl-content',]),
		]);
		echo '<div '.$this->get_render_attribute_string( 'content' ).'>';

			if( !empty( $settings['prefix'] ) ) {
				/**
				 * Prefix
				 */
					$this->add_render_attribute( 'prefix-wrap', [
						'class' => array_filter([ 'kfw-ele-widget-counter-minl-prefix',]),
					]);

					echo '<div '.$this->get_render_attribute_string( 'prefix-wrap' ).'>';
						echo esc_html( $settings['prefix'] );
					echo '</div>';
			}

			/**
			 * Numerator
			 */
				$this->add_render_attribute( 'numerator-wrap', [
					'class' => array_filter([ 'kfw-ele-widget-counter-minl-number',]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'numerator-wrap' ).'></div>';


			if( !empty( $settings['suffix'] ) ) {
				/**
				 * Suffix
				 */
				$this->add_render_attribute( 'suffix-wrap', [
					'class' => array_filter([ 'kfw-ele-widget-counter-minl-suffix',]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'suffix-wrap' ).'>';
					echo esc_html( $settings['suffix'] );
				echo '</div>';
			}
		echo '</div>';

		/**
		 * Title
		 */
		if( $settings['title_pos'] === 'bottom' ) {
			$this->_counter_title();
		}

	echo '</div>';

echo '</div>';