<?php
/**
 * Widget Template : Portfolio Item
 */
$settings = $this->get_settings();
$post     = get_post( $settings['post'], ARRAY_A );

if( !is_null( $post ) ) {

    $this->add_render_attribute( 'main', [
        'id'    => 'kfw-ele-widget-cpt-project-item-'.esc_attr( $this->get_id() ),
        'class' => [
            'kfw-ele-widget-cpt-project-item-main',
        ]
    ]);

    echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

        $post_id    = $post['ID'];
        $post_title = $post['post_title'];
        $permalink  = get_permalink( $post_id );
        $classes    = get_post_class([
            'kinfw-project-item',
            $settings['type'],
        ]);

        $this->add_render_attribute( 'post-item', [
            'id'    => 'post-'.$post_id,
            'class' => array_filter( $classes )
        ] );

        /**
         * Featured Image
         */
            $featured_img = sprintf( '
                <img src="%1$s" alt="%2$s" class="kinfw-transparent-img"/>',
                get_theme_file_uri( 'assets/image/public/transparent.jpg' ),
                esc_attr( $post_title )
            );

            $thumbnail_id = get_post_thumbnail_id( $post_id );
            $image_src    = $this->_get_image_src( $thumbnail_id, 'image_size', $settings );

            $image_title = $this->_get_featured_image_title( $thumbnail_id );
            $image_title = empty( $image_title ) ? $post_title : $image_title;

            $image_alt = $this->_get_featured_image_alt( $thumbnail_id );
            $image_alt = empty( $image_alt ) ? $image_title : $image_alt;

            if( !empty( $image_src ) ) {
                $this->add_render_attribute( 'image_attr', [
                    'class' => array_filter([
                        'kfw-ele-widget-post-featured-image',
                    ]),
                    'alt'   => esc_attr( $image_alt ),
                    'title' => esc_attr( $image_title ),
                    'src'   => esc_url( $image_src ),
                ] );

                $featured_img = '<img '.$this->get_render_attribute_string( 'image_attr' ).'/>';
            }

        echo '<article '. $this->get_render_attribute_string( 'post-item' ) .'>';
            printf( '<div class="kinfw-project-img" data-gsap-smooth-scroll-speed="0.8" data-gsap-smooth-scroll-lag="0">%1$s</div>', $featured_img );

            if( 'kinfw-project-style-1' == $settings['type'] ) {
                printf( '<a href="%1$s" class="kinfw-project-icon">%2$s</a>',
                    esc_url( $permalink ),
                    kinfw_icon( 'arrows-simple-up-right' )
                );

                printf( '<div class="kinfw-project-content">
                        <h3><a href="%1$s">%2$s</a></h3>
                        <p>%3$s</p>
                    </div>',
                    esc_url( $permalink ),
                    esc_html( $post_title ),
                    get_the_term_list( $post_id, 'kinfw-project-category', '', ', ', '' )
                );
            } else if( 'kinfw-project-style-2' == $settings['type'] ) {
                printf( '<div class="kinfw-project-content">
                        <div class="kinfw-project-cat">%3$s</div>
                        <h3><a href="%1$s">%2$s</a></h3>
                    </div>',
                    esc_url( $permalink ),
                    esc_html( $post_title ),
                    get_the_term_list( $post_id, 'kinfw-project-category', '', ' / ', '' )
                );
            } else if( 'kinfw-project-style-3' == $settings['type'] ) {
                printf( '<div class="kinfw-project-content">
                        <div class="kinfw-project-cat">%3$s</div>
                        <h3><a href="%1$s">%2$s</a></h3>
                    </div>',
                    esc_url( $permalink ),
                    esc_html( $post_title ),
                    get_the_term_list( $post_id, 'kinfw-project-category', '', ' / ', '' )
                );
            } else if( 'kinfw-project-style-4' == $settings['type'] ) {
                printf('<div class="kinfw-project-content">
                        <h3><a href="%1$s">%2$s</a></h3>
                        <a href="%1$s" class="kinfw-project-icon">%3$s</a>
                    </div>',
                    esc_url( $permalink ),
                    esc_html( $post_title ),
                    kinfw_icon( 'onnat-line-arrow-long-right-cross' )
                );
            }
        echo '</article>';

    echo '</div>';

}