<?php
/**
 * Widget Template : Service Vertical
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-cpt-service-vertical-'.esc_attr( $this->get_id() ),
    'class'         => [ 'kfw-ele-widget-cpt-service-vertical-main' ],
    'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    foreach( $items as $index => $item ) {
        if( empty( $item['service'] ) ) {
            break;
        }

        $service    = get_post( $item['service'], ARRAY_A );
        $post_id    = $service['ID'];
        $post_title = get_the_title( $post_id );
        $post_link  = get_permalink( $post_id );

        $s_item  = $this->get_repeater_setting_key( 's-item', 's-items', $index );
        $classes = [
            'kinfw-service-vertical-item',
            'kfw-ele-widget-cpt-service-vertical-item',
            'elementor-repeater-item-' . esc_attr( $item['_id'] ),
        ];

        $this->add_render_attribute( $s_item, [
            'id'    => 'post-'.$post_id,
            'class' => array_filter( $classes )
        ] );

        echo '<article '. $this->get_render_attribute_string( $s_item ) .'>';

            /**
             * Image
             */
            printf( '<div class="kinfw-service-vertical-img-wrap">%1$s</div>', $this->_featured_image( $item, $settings ) );


            /**
             * Title
             */
            printf( '<div class="kinfw-service-vertical-title-wrap">
                    <div class="kinfw-service-vertical-title">%1$s</div>
                </div>',
                $post_title
            );

            /**
              * Button
              */
            printf( '<div class="kinfw-service-vertical-button-wrap">
                    <a href="%1$s">%2$s</a>
                </div>',
                esc_url( $post_link ),
                ( $settings['button-icon-type'] === 'icon' ) ?
                $this->_render_button_icon( $settings['button-icon'] ) :
                $this->_render_button_img( $settings['button-image'] )
            );
        echo '</article>';

    }
echo '</div>';