<?php
/**
 * Widget Template : Team Member Meta
 */

$settings = $this->get_settings();
$post_id  = get_the_ID();

if( is_singular( 'elementor_library' ) ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-team-member' );
}

if( empty( $settings['meta'] ) ) {

    return;
}

$title = '';
$data  = '';

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-team-member-meta-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-team-member-meta-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $meta  = get_post_meta( $post_id, '_kinfw_cpt_team_member_options', true );
    $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

    if( 'yes' === $settings['add_title'] ) {

        $title = $settings['title'];

        if( empty( $title ) ) {

            switch( $settings['meta'] ) {
                case 'experience':
                    $title = esc_html__('Experience', 'onnat-extra');
                break;

                case 'phone':
                    $title = esc_html__('Phone', 'onnat-extra');
                break;

                case 'email':
                    $title = esc_html__('Email', 'onnat-extra');
                break;

                case 'fax':
                    $title = esc_html__('Fax', 'onnat-extra');
                break;

                case 'website':
                    $title = esc_html__('Website', 'onnat-extra');
                break;
            }
        }

        if( !empty( $title ) ) {
            printf( '<span class="kfw-ele-cpt-team-member-meta-title">%s</span>', esc_html( $title ) );
        }

    }

    if( isset( $meta[ $settings['meta'] ] ) && !empty( $meta[ $settings['meta'] ] ) ) {

        switch( $settings['meta'] ) {
            case 'experience':
                $data = sprintf( esc_html__('%s Years', 'onnat-extra' ), $meta['experience'] );
            break;

            case 'phone':
                $phone = $meta['phone'];
                $data  = sprintf( '<a href="tel:%s"> %s </a>', esc_attr( preg_replace( '/[^0-9]/', '', $phone ) ), esc_html( $phone ) );
            break;

            case 'email':
                $data  = sprintf( '<a href="mailto:%1$s"> %1$s </a>', antispambot( $meta['email'] ) );
            break;

            case 'fax':
                $fax  = $meta['fax'];
                $data = sprintf( '<a href="fax:%s"> %s </a>', esc_attr( preg_replace( '/[^0-9]/', '', $fax ) ), esc_html( $fax ) );
            break;

            case 'website':
                $website = $meta['website'];
                $website = apply_filters( 'kinfw-filter/theme/util/is-array', $website );

                $data = sprintf( '<a href="%s" target="%s"> %s </a>',
                    esc_url( $website['url'] ),
                    esc_attr( $website['target'] ),
                    esc_html( $website['text'] )
                );
            break;
        }

    }

    if( !empty( $data ) ) {
        printf( '<span class="kfw-ele-cpt-team-member-meta-data">%s</span>', $data );
    }
echo '</div>';