<?php
/**
 * Widget Template : Team Member Social Links
 */

$settings = $this->get_settings();
$post_id  = get_the_ID();

if( is_singular( 'elementor_library' ) ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-team-member' );
}

$social_order        = kinfw_onnat_theme_options()->kinfw_get_option( 'single_team_member_social_share' );
$active_social_share = isset( $social_order['enabled'] ) ? apply_filters( 'kinfw-filter/theme/util/is-array', $social_order['enabled'] ) : [];

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-team-member-social-share-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-team-member-social-share-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $meta  = get_post_meta( $post_id, '_kinfw_cpt_team_member_options', true );
    $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

    $links = [];
    foreach( $active_social_share as $social_id => $social_name ) {
        if( isset( $meta[ $social_id ] ) && !empty( $meta[ $social_id ] ) ) {
            $links[ $social_id ] = $meta[ $social_id ];
        }
    }

    if( count( $links ) ) {
        echo '<ul class="kinfw-social-links">';
            foreach( $links as $social_id => $social_link ) {
                echo '<li>';
                    echo sprintf('<a href="%s"></a>', $social_link );
                echo '</li>';
            }
        echo '</ul>';
    }

echo '</div>';