<?php
/**
 * Widget Template : Icon Box
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-icon-box-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-icon-box-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    /**
     * Icon Wrap
     */
	if( $settings['icon_type'] !== 'blank'  ) {

        $this->add_render_attribute( 'icon-wrap', [
            'class' => [ 'kfw-ele-widget-icon-box-icon-wrap', 'kfw-ele-widget-icon-box-'.esc_attr( $settings['icon_type'] ) . '-type' ],
        ]);

        echo '<div '.$this->get_render_attribute_string( 'icon-wrap' ).'>';
            if( $settings['icon_type'] === 'icon' ) {
                $this->_render_icon( $settings['icon'] );
            } else if( $settings['icon_type'] === 'image' ) {
                $this->_render_img( $settings );
            }
        echo '</div>';
    }


    /**
     * Content Wrap
     */
        $this->add_render_attribute( 'content-wrap', [
            'class' => [ 'kfw-ele-widget-icon-box-content-wrap' ],
        ]);
        echo '<div '.$this->get_render_attribute_string( 'content-wrap' ).'>';
            /**
             * Title
             */
            $this->_title( $settings );

            /**
             * Sub Title
             */
            $this->_sub_title( $settings );


            /**
             * Description
             */
            $this->_description( $settings );

            /**
             * Button
             */
            $this->_button( $settings );
        echo '</div>';

echo '</div>';