<?php
/**
 * Widget Template : Image Comparsion
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'wrapper', [
	'id'            => 'kfw-elementor-widget-image-comparision-'.esc_attr( $this->get_id() ),
	'class'         => [ 'kfw-elementor-widget-image-comparision-wrapper' ],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

	/**
	 *  Before Image
	 */
	$before_image_src = $this->_get_image_src( $settings['before_image']['id'], 'image_size', $settings );
    $before_image_src = empty($before_image_src) ? $settings['before_image']['url'] : $before_image_src;

	$this->add_render_attribute( 'before_image_attr', [
		'class' => 'before-image',
		'alt'   => esc_attr( $settings['before_image_alt'] ),
		'src'   => esc_url( $before_image_src ),
	] );
	echo '<img '.$this->get_render_attribute_string( 'before_image_attr' ).'/>';

	/**
	 * After Image
	 */
	$after_image_src = $this->_get_image_src( $settings['after_image']['id'], 'image_size', $settings );
    $after_image_src = empty($after_image_src) ? $settings['after_image']['url'] : $after_image_src;

	$this->add_render_attribute( 'after_image_attr', [
		'class' => 'after-image',
		'alt'   => esc_attr( $settings['after_image_alt'] ),
		'src'   => esc_url( $after_image_src ),
	] );
	echo '<img '.$this->get_render_attribute_string( 'after_image_attr' ).'/>';

echo '</div>';