<?php
/**
 * Widget Template : Instagram
 */

$settings = $this->get_settings();
$layout   = $settings['layout'];
$items    = $this->_get_items();

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-widget-instagram-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-instagram-wrapper' ],
] );

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

	foreach( $items as $index => $item ) {

		$permalink = $item['permalink'];
		$image     = $item['image'];
		$alt       = esc_attr( $item['author'] );
		$classes   = implode( " ", [
            'elementor-repeater-item-' . esc_attr( $item['id'] ),
            'kfw-ele-widget-instagram-grid-item',
		] );

		if( 'style-1' === $layout || 'style-2' === $layout ) {

			printf('
				<div class="%s">
					<a href="%s" target="_blank" rel="nofollow" class="kfw-ele-widget-instagram-img-wrap">
						<div class="kfw-ele-widget-instagram-img">
							<img src="%s" alt="%s" title="%s"/>
						</div>
						<div class="kfw-ele-widget-instagram-overlay">
							<span class="kinfw-icon kinfw-icon-brand-instagram"></span>
						</div>
					</a>
				</div>',
				esc_attr( $classes ),
				esc_url( $permalink ),
				esc_url( $image ),
				sprintf( esc_html__( 'Image from %s', 'onnat-extra' ), $alt ),
				sprintf( esc_html__( 'Image from %s', 'onnat-extra' ), $alt ),
			);

		} else if( 'style-3' === $layout ) {
			printf('
				<div class="%s">
					<a href="%s" target="_blank" rel="nofollow" class="kfw-ele-widget-instagram-img-wrap">
						<div class="kfw-ele-widget-instagram-img">
							<img class="kfw-ele-widget-instagram-img" src="%s" alt="%s" title="%s"/>
						</div>
						<div class="kfw-ele-widget-instagram-overlay">
							<span class="kinfw-icon kinfw-icon-link-regular"></span>
						</div>
					</a>
				</div>',
				esc_attr( $classes ),
				esc_url( $permalink ),
				esc_url( $image ),
				sprintf( esc_html__( 'Image from %s', 'onnat-extra' ), $alt ),
				sprintf( esc_html__( 'Image from %s', 'onnat-extra' ), $alt ),
			);
		}
	}

	if( count( $items ) > 0 && 'style-3' === $layout ) {

		printf( '<div class="kfw-ele-widget-instagram-icon"> <span class="kinfw-icon kinfw-icon-brand-instagram"></span> </div>' );
	}

echo '</div>';