<?php
/**
 * Widget Template : Interactive Accordion
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-interactive-accordion-'.esc_attr( $this->get_id() ),
    'data-settings' => $this->_generate_setting_json( $settings ),
    'class'         => [
        'kfw-ele-widget-interactive-accordion-main',
        empty( $settings['use_title_icon'] ) ? 'kfw-accordion-handler-icon-pos-'.esc_attr( $settings['handler_align'] ) : '',
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Images Section
     */
    echo '<div class="kfw-accordion-section-wrap kfw-accordion-img-section-wrap">';
        foreach( $items as $index => $item ):
            $accordion_item = $this->get_repeater_setting_key( 'accordion_img_item', 'items', $index );
            $this->add_render_attribute( $accordion_item, [
                'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class'   => array_filter([
                    'kfw-elementor-accordion-item',
                    'kfw-elementor-accordion-image-item',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $accordion_item ).'>';
                if( !empty( $item['main_image']['url'] ) ) {
                    $image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
                    $image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

                    $image_title = $this->_get_image_title( $item['main_image'] );
                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                    $image_alt = $this->_get_image_alt( $item['main_image'] );
                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                    $image_attr = $this->get_repeater_setting_key( 'image-item', 'items', $index );

                    $this->add_render_attribute( $image_attr, [
                        'class' => 'kfw-elementor-accordion-image',
                        'alt'   => esc_attr( $image_alt ),
                        'title' => esc_attr( $image_title ),
                        'src'   => esc_url( $image_src ),
                    ]);

                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                }
            echo '</div>';
        endforeach;
    echo '</div>';

    /**
     * Content Section
     */
    echo '<div class="kfw-accordion-section-wrap kfw-accordion-content-section-wrap">';
        foreach( $items as $index => $item ):

            $accordion_item = $this->get_repeater_setting_key( 'accordion_item', 'items', $index );
            $this->add_render_attribute( $accordion_item, [
                'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class'   => array_filter([
                    'kfw-elementor-accordion-item',
                    'kfw-elementor-accordion-content-item',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $accordion_item ).'>';

                /**
                 * Header
                 */
                    echo '<div class="kfw-accordion-header-wrap" data-id="elementor-repeater-item-'.esc_attr( $item['_id'] ).'">';
                        /**
                         * Icon
                         */
                            if( $settings['use_title_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                                if( $item['icon_type'] === 'icon' ) {
                                    $this->_render_icon( $item['icon'] );
                                } else if( $item['icon_type'] === 'image' ) {
                                    $this->_render_img( $item['image'] );
                                } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                                    $src = '';
                                    if( $item['icon_type'] === 'lordicon_media' ) {
                                        $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                                    } else if( $item['icon_type'] === 'lordicon_external' ) {
                                        $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                                    }

                                    if( !empty( $src ) ) {
                                        $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                                        $this->add_render_attribute( $lordicon, [
                                            'class'   => 'kfw-elementor-lordicon',
                                            'src'     => $src,
                                            'stroke'  => 45,
                                            'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                            'trigger' => 'click'
                                        ]);

                                        /**
                                         * Colors
                                         */
                                            $colors = '';
                                            $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                            $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                            $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                            if( !empty( $colors ) ) {
                                                $this->add_render_attribute( $lordicon, 'colors', $colors );
                                            }

                                        echo '<div class="kfw-accordion-title-icon-wrap kfw-accordion-title-lordicon-type">';
                                            echo '<span class="kfw-elementor-icon-wrap">';
                                                echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                            echo '</span>';
                                        echo '</div>';
                                    }
                                }

                            }

                        /**
                         * Title
                         */
                            $title = trim( $item['title'] );
                            if( !empty( $title ) ) {
                                echo '<div class="kfw-accordion-title-wrap">';
                                    if( !empty( $title ) ) {
                                        echo '<div class="kfw-accordion-title">';
                                            echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                                        echo '</div>';
                                    }
                                echo '</div>';
                            }

                        /**
                         * Handler
                         */
                            if( $settings['handler_icon_type'] !== 'blank' ) {
                                if( $settings['handler_icon_type'] === 'icon' ) {
                                    echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-icon-type">';
                                        $this->_render_handler_icon( $settings['handler_icon_icon'] );
                                        $this->_render_handler_icon( $settings['handler_icon_active_icon'], $active = true );
                                    echo '</div>';
                                } else if( $settings['handler_icon_type'] === 'image' ) {
                                    echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-image-type">';
                                        $this->_render_handler_icon_img( $settings['handler_icon_image'] );
                                        $this->_render_handler_icon_img( $settings['handler_icon_active_image'], $active = true );
                                    echo '</div>';
                                } else if( $settings['handler_icon_type'] === 'lordicon_media' ) {

                                    $src    = !empty( $settings['handler_icon_lordicon_media']['url'] ) ? $settings['handler_icon_lordicon_media']['url'] : '';
                                    $a_src  = !empty( $settings['handler_icon_active_lordicon_media']['url'] ) ? $settings['handler_icon_active_lordicon_media']['url'] : '';
                                    $stroke = !empty( $settings['handler_media_stroke']['size'] ) ?  $settings['handler_media_stroke']['size']: 45;

                                    /**
                                     * Colors
                                     */
                                        $colors = '';
                                        $colors .= !empty( $settings['handler_media_primary_color'] ) ? 'primary:'.$settings['handler_media_primary_color'].',': '';
                                        $colors .= !empty( $settings['handler_media_secondary_color'] ) ? 'secondary:'.$settings['handler_media_secondary_color'].',': '';
                                        $colors .= !empty( $settings['handler_media_tertiary_color'] ) ? 'tertiary:'.$settings['handler_media_tertiary_color'].',': '';

                                    if( !empty( $src ) && !empty( $a_src ) ) {

                                        echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-lordicon-type">';

                                            $handler_lordicon = $this->get_repeater_setting_key( 'handler-lordicon', 'items', $index );
                                            $this->add_render_attribute( $handler_lordicon, [
                                                'class'   => 'kfw-elementor-lordicon',
                                                'src'     => $src,
                                                'stroke'  => $stroke,
                                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                                'trigger' => 'click'
                                            ]);

                                            if( !empty( $colors ) ) {
                                                $this->add_render_attribute( $handler_lordicon, 'colors', $colors );
                                            }

                                            echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-close">';
                                                echo '<span class="kfw-elementor-icon-wrap">';
                                                    echo '<lord-icon '. $this->get_render_attribute_string( $handler_lordicon ) .'></lord-icon>';
                                                echo '</span>';
                                            echo '</div>';

                                            $active_handler_lordicon = $this->get_repeater_setting_key( 'active-handler-lordicon', 'items', $index );
                                            $this->add_render_attribute( $active_handler_lordicon, [
                                                'class'   => 'kfw-elementor-lordicon',
                                                'src'     => $a_src,
                                                'stroke'  => $stroke,
                                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                                'trigger' => 'click'
                                            ]);

                                            if( !empty( $colors ) ) {
                                                $this->add_render_attribute( $active_handler_lordicon, 'colors', $colors );
                                            }

                                            echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-open">';
                                                echo '<span class="kfw-elementor-icon-wrap">';
                                                    echo '<lord-icon '. $this->get_render_attribute_string( $active_handler_lordicon ) .'></lord-icon>';
                                                echo '</span>';
                                            echo '</div>';

                                        echo '</div>';

                                    }
                                } else if( $settings['handler_icon_type'] === 'lordicon_external' ) {
                                    $src   = !empty( $settings['handler_icon_lordicon_external']['url'] ) ? $settings['handler_icon_lordicon_external']['url'] : '';
                                    $a_src = !empty( $settings['handler_icon_lordicon_external']['url'] ) ? $settings['handler_icon_lordicon_external']['url'] : '';

                                    $stroke = !empty( $settings['handler_media_stroke']['size'] ) ?  $settings['handler_media_stroke']['size']: 45;

                                    /**
                                     * Colors
                                     */
                                        $colors = '';
                                        $colors .= !empty( $settings['handler_media_primary_color'] ) ? 'primary:'.$settings['handler_media_primary_color'].',': '';
                                        $colors .= !empty( $settings['handler_media_secondary_color'] ) ? 'secondary:'.$settings['handler_media_secondary_color'].',': '';
                                        $colors .= !empty( $settings['handler_media_tertiary_color'] ) ? 'tertiary:'.$settings['handler_media_tertiary_color'].',': '';

                                    if( !empty( $src ) && !empty( $a_src ) ) {

                                        echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-lordicon-type">';

                                            $handler_lordicon = $this->get_repeater_setting_key( 'handler-lordicon', 'items', $index );
                                            $this->add_render_attribute( $handler_lordicon, [
                                                'class'   => 'kfw-elementor-lordicon',
                                                'src'     => $src,
                                                'stroke'  => $stroke,
                                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                                'trigger' => 'click'
                                            ]);

                                            if( !empty( $colors ) ) {
                                                $this->add_render_attribute( $handler_lordicon, 'colors', $colors );
                                            }

                                            echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-close">';
                                                echo '<span class="kfw-elementor-icon-wrap">';
                                                    echo '<lord-icon '. $this->get_render_attribute_string( $handler_lordicon ) .'></lord-icon>';
                                                echo '</span>';
                                            echo '</div>';

                                            $active_handler_lordicon = $this->get_repeater_setting_key( 'active-handler-lordicon', 'items', $index );
                                            $this->add_render_attribute( $active_handler_lordicon, [
                                                'class'   => 'kfw-elementor-lordicon',
                                                'src'     => $a_src,
                                                'stroke'  => $stroke,
                                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                                'trigger' => 'click'
                                            ]);

                                            if( !empty( $colors ) ) {
                                                $this->add_render_attribute( $active_handler_lordicon, 'colors', $colors );
                                            }

                                            echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-open">';
                                                echo '<span class="kfw-elementor-icon-wrap">';
                                                    echo '<lord-icon '. $this->get_render_attribute_string( $active_handler_lordicon ) .'></lord-icon>';
                                                echo '</span>';
                                            echo '</div>';

                                        echo '</div>';

                                    }
                                }
                            }

                    echo '</div>';


                /**
                 * Content
                 */
                    $accordion_con_item = $this->get_repeater_setting_key( 'accordion_con_item', 'items', $index );

                    $this->add_render_attribute( $accordion_con_item, [
                        'class'   => array_filter(['kfw-accordion-content-wrap',]),
                        'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    ]);

                    echo '<div '.$this->get_render_attribute_string( $accordion_con_item ).'>';
                        echo $this->parse_text_editor( $item['editor'] );
                    echo '</div>';

                /**
                 * Main Image : Only Visible in Responsive
                 */
                    echo '<div class="kfw-elementor-accordion-responsive-image-item">';
                        if( !empty( $item['main_image']['url'] ) ) {
                            $image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
                            $image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

                            $image_title = $this->_get_image_title( $item['main_image'] );
                            $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                            $image_alt = $this->_get_image_alt( $item['main_image'] );
                            $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                            $image_attr = $this->get_repeater_setting_key( 'responsive-image-item', 'items', $index );

                            $this->add_render_attribute( $image_attr, [
                                'class' => 'kfw-elementor-accordion-image',
                                'alt'   => esc_attr( $image_alt ),
                                'title' => esc_attr( $image_title ),
                                'src'   => esc_url( $image_src ),
                            ]);

                            echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                        }
                    echo '</div>';

            echo '</div>';

        endforeach;
    echo '</div>';

echo '</div>';