<?php
/**
 * Widget Template : Pricing Table
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-pricing-table-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-pricing-table-wrapper' ],
	'dir'   => is_rtl() ? 'rtl' : 'ltr'
]);

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';
	echo '<table>';

		echo '<thead>';
			echo '<tr>';
				foreach( $settings['table_headers'] as $index => $item ) {
					$table_header_setting_key = $this->get_repeater_setting_key( 'table_header', 'table_headers', $index );

					$this->add_render_attribute( $table_header_setting_key, [
						'class' => array_filter( [
							'kfw-ele-pricing-table-heading',
							'kfw-ele-pricing-table-heading-' . esc_attr( $item['table_header_type'] ),
							'elementor-repeater-item-' . esc_attr( $item['_id'] ),
							( 'yes' === $item['settings'] && 'yes' === $item['is_active'] ) ? 'kfw-ele-pricing-table-active' : '',
						] ),
					]);

					if( 'yes' === $item['settings'] && 'yes' === $item['custom_colspan'] && !empty( $item['colspan'] ) ) {
						$this->add_render_attribute( $table_header_setting_key, [
							'colspan' => $item['colspan']
						]);
					}

					echo '<th '. $this->get_render_attribute_string( $table_header_setting_key ) .'>';
						if( 'data' === $item['table_header_type'] ) {
							/**
							 * Title
							 */
							if( !empty( $item['title'] ) ) {
								printf( '<span class="kfw-ele-pricing-table-title">%s</span>', esc_html( $item['title'] ) );
							}

							/**
							 * Currency & Price
							 */
							$this->_pricing( $item );

							/**
							 * Button
							 */
							$this->_button( $item );
						}
					echo '</th>';
				}
			echo '</tr>';
		echo '</thead>';

		echo '<tbody>';
			echo '<tr>';
				foreach( $settings['table_body'] as $index => $item ) {

					if($item['row'] == 'yes'){
						echo '</tr><tr>';
					}

					$table_body_setting_key = $this->get_repeater_setting_key( 't_body', 'table_body', $index );

					$this->add_render_attribute( $table_body_setting_key, [
						'class' => array_filter( [
							'kfw-ele-pricing-table-content',
							'kfw-ele-pricing-table-content-' . esc_attr( $item['table_body_type'] ),
							'elementor-repeater-item-' . esc_attr( $item['_id'] ),
						] ),
					]);

					if( 'yes' === $item['settings'] && 'yes' === $item['custom_colspan'] && !empty( $item['colspan'] ) ) {
						$this->add_render_attribute( $table_body_setting_key, [
							'colspan' => $item['colspan']
						]);
					}

					if( 'yes' === $item['settings'] && 'yes' === $item['custom_rowspan'] && !empty( $item['rowspan'] ) ) {
						$this->add_render_attribute( $table_body_setting_key, [
							'rowspan' => $item['rowspan']
						]);
					}

					echo '<td '. $this->get_render_attribute_string( $table_body_setting_key ) .'>';
						switch ($item['table_body_type']) {
							case 'text':
								printf( '<span class="kfw-ele-pricing-table-info">%s</span>', esc_html( $item['title'] ) );
							break;

							case 'icon':
								$this->_render_icons( $item['icon'] );
							break;							
						}
					echo '</td>';
				}
			echo '</tr>';
		echo '</tbody>';
	echo '</table>';
echo '</div>';