<?php
/**
 * Widget Template : Alternate Split Scroll
 */
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'               => 'kfw-ele-widget-split-scroll-alt-'.esc_attr( $this->get_id() ),
	'class'            => [
		'kfw-ele-widget-split-scroll-alt-main',
		'kfw-ele-widget-split-scroll-alt-'.esc_attr( $settings['layout_type'] ),
	],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
	/**
	 * Left
	 */
	echo '<div class="kfw-elementor-split-scroll-alt-items-wrap kfw-elementor-split-scroll-alt-l-items-wrap">';
		foreach( $items as $index => $item ):
			$l_item = $this->get_repeater_setting_key( 'l_item', 'items', $index );
			$this->add_render_attribute( $l_item, [
				'id'    => 'elementor-repeater-l-item-' . esc_attr( $item['_id'] ),
				'class' => array_filter([
					'kfw-elementor-split-scroll-alt-item',
					'kfw-elementor-split-scroll-alt-l-item',
					'kfw-elementor-split-scroll-alt-img-item',
				]),
			]);

			echo '<div '.$this->get_render_attribute_string( $l_item ).'>';
				if( !empty( $item['main_image']['url'] ) ) {
					$image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
					$image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

					$image_title = $this->_get_image_title( $item['main_image'] );
					$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

					$image_alt = $this->_get_image_alt( $item['main_image'] );
					$image_alt = empty( $image_alt ) ? $image_title : $image_title;

					$image_attr = $this->get_repeater_setting_key( 'image-item', 'items', $index );

					$this->add_render_attribute( $image_attr, [
						'class' => 'kfw-elementor-split-scroll-alt-image',
						'alt'   => esc_attr( $image_alt ),
						'title' => esc_attr( $image_title ),
						'src'   => esc_url( $image_src ),
					]);

					echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
				}
			echo '</div>';
		endforeach;
	echo '</div>';

	/**
	 * Right
	 */
	echo '<div class="kfw-elementor-split-scroll-alt-items-wrap kfw-elementor-split-scroll-alt-r-items-wrap">';
		foreach( $items as $index => $item ):
			$r_item = $this->get_repeater_setting_key( 'r_item', 'items', $index );
			$this->add_render_attribute( $r_item, [
				'id'    => 'elementor-repeater-r-item-' . esc_attr( $item['_id'] ),
				'class' => array_filter([
					'kfw-elementor-split-scroll-alt-item',
					'kfw-elementor-split-scroll-alt-r-item',
					'kfw-elementor-split-scroll-alt-content-item',
				]),
			]);
			echo '<div '.$this->get_render_attribute_string( $r_item ).'>';
				if( $settings['enable_bullet'] == 'yes' ) {
					echo $this->_nav( $items, $index );
				}

				echo '<div class="kfw-elementor-split-scroll-alt-content-wrap">';

					/**
					 * Responsive Image
					 */
					if( !empty( $item['main_image']['url'] ) ) {
						echo '<div class="kfw-split-scroll-alt-mobile-img-wrap">';
							$image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
							$image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

							$image_title = $this->_get_image_title( $item['main_image'] );
							$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

							$image_alt = $this->_get_image_alt( $item['main_image'] );
							$image_alt = empty( $image_alt ) ? $image_title : $image_title;

							$image_attr = $this->get_repeater_setting_key( 'mobile-image-item', 'items', $index );

							$this->add_render_attribute( $image_attr, [
								'class' => 'kfw-elementor-split-scroll-alt-image',
								'alt'   => esc_attr( $image_alt ),
								'title' => esc_attr( $image_title ),
								'src'   => esc_url( $image_src ),
							]);

							echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
						echo '</div>';
					}

					/**
					 * Icon
					 */
					if( $settings['use_header_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
						if( $item['icon_type'] === 'icon' ) {
							$this->_render_icon( $item['icon'] );
						} else if( $item['icon_type'] === 'text' ) {
							$this->_render_text( $item['text'] );
						} else if( $item['icon_type'] === 'image' ) {
							$this->_render_img( $item['image'] );
						} else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
							$src = '';
							if( $item['icon_type'] === 'lordicon_media' ) {
								$src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
							} else if( $item['icon_type'] === 'lordicon_external' ) {
								$src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
							}

							if( !empty( $src ) ) {
								$lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

								$this->add_render_attribute( $lordicon, [
									'class'   => 'kfw-elementor-lordicon',
									'src'     => $src,
									'stroke'  => 45,
									'target'  => '#elementor-repeater-l-item-' . esc_attr( $item['_id'] ),
									'trigger' => 'click'
								]);

								/**
								 * Colors
								 */
									$colors = '';
									$colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
									$colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
									$colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
									if( !empty( $colors ) ) {
										$this->add_render_attribute( $lordicon, 'colors', $colors );
									}

								echo '<div class="kfw-split-scroll-alt-title-icon-wrap kfw-split-scroll-alt-title-lordicon-type">';
									echo '<span class="kfw-elementor-icon-wrap">';
										echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
									echo '</span>';
								echo '</div>';
							}
						}
					}

					/**
					 * Title & Sub Title
					 */
					$title     = trim( $item['title'] );
					$sub_title = trim( $item['sub_title'] );
					if( !empty( $title ) || !empty( $sub_title ) ) {
						echo '<div class="kfw-split-scroll-alt-title-wrap">';
							if( !empty( $sub_title ) ) {
								echo '<div class="kfw-split-scroll-alt-sub-title">';
									echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}

							if( !empty( $title ) ) {
								echo '<div class="kfw-split-scroll-alt-title">';
									echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}
						echo '</div>';
					}

					/**
					 * Content
					 */
					$item_src   = $item['source'];
					$r_con_item = $this->get_repeater_setting_key( 'r_con_item', 'items', $index );
					$this->add_render_attribute( $r_con_item, [
						'class'   => array_filter([
							'kfw-elementor-split-scroll-alt-info-wrap',
							'kfw-elementor-split-scroll-alt-info-'.$item_src.'-type',
						]),
					]);
					echo '<div '.$this->get_render_attribute_string( $r_con_item ).'>';
						if( $item_src === 'editor' ) {
							echo '<div class="kfw-elementor-split-scroll-alt-info">'.$this->parse_text_editor( $item['editor'] ).'</div>';
							$this->_button( $item, $index );
						} else if( $item_src === 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
							echo $this->_generate_template_content( $item['template'] );
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';
		endforeach;
	echo '</div>';
echo '</div>';