<?php
/**
 * Widget Template : Testimonial Large Carousel
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

$cols        = isset( $settings['cols'] ) ? $settings['cols'] : 1;
$cols_tablet = isset( $settings['cols_tablet'] ) ? $settings['cols_tablet'] : 2;
$cols_mobile = isset( $settings['cols_mobile'] ) ? $settings['cols_mobile'] : 1;

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'            => 'kfw-ele-widget-testimonial-large-carousel-'.esc_attr( $this->get_id() ),
	'class'         => [
        'kfw-ele-widget-testimonial-large-carousel-main',
        'kfw-testimonial-lg-layout-'.$cols,
        'kfw-testimonial-lg-tablet-layout-'.$cols_tablet,
        'kfw-testimonial-lg-mobile-layout-'.$cols_mobile
    ],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'swiper', [
        'data-id' => 'kfw-js-swiper-'.esc_attr( $this->get_id() ),
        'class'   => array_filter( [
            'kfw-js-swiper-'.esc_attr( $this->get_id() ),
            'kfw-swiper',
            'swiper',
            'swiper-container',
        ])
    ]);
    echo '<div '. $this->get_render_attribute_string( 'swiper' ) .'>';

        $this->add_render_attribute( 'list', [
            'class' => array_filter( [
                'kfw-ele-testimonial-carousel-list',
                'swiper-wrapper'
            ])
        ]);
        echo '<div '. $this->get_render_attribute_string( 'list' ) .'>';

            foreach( $items as $index => $item ) {

                /**
                 * Avatar
                 */
                $image_src = $this->_get_image_src( $item['avatar']['id'], 'image_size', $settings );
                $image_src = empty($image_src) ? $item['avatar']['url'] : $image_src;

                $item_wrapper = $this->get_repeater_setting_key( 'item', 'kfw-items', $index );
                $this->add_render_attribute( $item_wrapper, [
                    'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    'class' => array_filter([
                        'swiper-slide',
                        'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                        ( empty( $image_src ) ) ? 'kfw-has-no-avatar' : '',
                        'kfw-testimonial-lg-item',
                    ])
                ]);

                echo '<div '.$this->get_render_attribute_string( $item_wrapper ).'>';

                    /**
                     * Avatar
                     */
                    if( !empty( $image_src ) ) {
                        echo '<div class="kfw-testimonial-lg-img-wrap">';
                            $image_title = $this->_get_image_title( $item['avatar'] );
                            $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                            $image_alt = $this->_get_image_alt( $item['avatar'] );
                            $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                            $image_attr = $this->get_repeater_setting_key( 'image-item', 'kfw-items', $index );
                            $this->add_render_attribute( $image_attr, [
                                'class' => 'kfw-testimonial-lg-avatar kfw-image-is-loading',
                                'alt'   => esc_attr( $image_alt ),
                                'title' => esc_attr( $image_title ),
                                'src'   => esc_url( $image_src ),
                            ]);

                            echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                        echo '</div>';
                    }

                    /**
                     * Content Wrap
                     */
                    echo '<div class="kfw-testimonial-lg-body-wrap">';

                        

                        /**
                         * Content
                         */
                        echo '<div class="kfw-testimonial-lg-body">';
                            echo '<div class="kfw-testimonial-lg-comment">';
                                echo esc_html( $item['content'] );
                            echo '</div>';
                            echo '<div class="kfw-testimonial-lg-header-wrap">';
                                echo '<div class="kfw-testimonial-lg-header">';
                                    echo '<div class="kfw-testimonial-lg-name">'. esc_html( $item['name'] ) . '</div>';
                                    if( 'yes' === $settings['use_role'] ) {
                                        echo '<div class="kfw-testimonial-lg-role">'. esc_html( $item['role'] ) . '</div>';
                                    }
                                echo '</div>';

                                /**
                                 * Top Quote Icon Wrap
                                 */
                                if( $settings['quote_icon_type'] !== 'blank'  ) {
                                    $icon_top_attr = $this->get_repeater_setting_key( 'icon-top-item', 'kfw-items', $index );
                                    $this->add_render_attribute( $icon_top_attr, [
                                        'class' => [
                                            'kfw-testimonial-lg-quote-icon-wrap',
                                            'kfw-testimonial-lg-top-quote-icon-wrap',
                                            'kfw-testimonial-lg-quote-'.esc_attr( $settings['quote_icon_type'] ) . '-type'
                                        ],
                                    ] );

                                    echo '<div '.$this->get_render_attribute_string($icon_top_attr).'>';
                                        if( $settings['quote_icon_type'] === 'icon' ) {
                                            $this->_render_icon( $settings['quote_icon_top_icon'] );
                                        } else if( $settings['quote_icon_type'] === 'default' ) {
                                            echo '<span class="kfw-elementor-icon-wrap"> <span class="kinfw-icon kinfw-icon-onnat-quote"></span> </span>';
                                        } else if( $settings['quote_icon_type'] === 'image' ) {
                                            $this->_render_img( $settings['quote_icon_top_image'] );
                                        }
                                    echo '</div>';
                                }
                                    
                            echo '</div>';
                        echo '</div>';

                        /**
                         * Rating
                         */
                        $badge = array_filter( $settings['quote_badge_image'] );
                        if( 'yes' === $settings['use_rating'] || isset( $badge['url'] ) ) {
                            echo '<div class="kfw-testimonial-lg-rating-wrap">';
                                if( isset( $badge['url'] ) ) {
                                    $badge_src   = $badge['url'];
                                    $badge_title = $this->_get_image_title( $badge );
                                    $badge_title = empty( $badge_title ) ? $this->get_title() : $badge_title;
                        
                                    $badge_alt = $this->_get_image_alt( $badge );
                                    $badge_alt = empty( $badge_alt ) ? $badge_alt : $badge_alt;

                                    echo '<img alt="'. esc_attr( $badge_alt ) .'" title="'. esc_attr( $badge_title ) .'" src="'. esc_url( $badge_src ) .'"/>';
                                }

                                if( 'yes' === $settings['use_rating'] ) {
                                    echo '<div class="kfw-testimonial-lg-rating"><span class="kfw-testimonial-lg-rating-inner"></span></div>';
                                }
                            echo '</div>';
                        }

                    echo '</div>';

                echo '</div>';

            }

        echo '</div>';

	echo '</div>';

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] !== 'custom' ) {

        /**
         * Navigation
         */
        $this->add_render_attribute( 'navEl', [
            'class' => array_filter( [
                'kfw-testimonial-large-carousel-nav-wrap',
                'kfw-testimonial-large-carousel-nav-pos-'. $settings['arrow_position'],
                $settings['mobile_arrows'] === 'yes' ? 'hide-on-sm hide-on-xs' : ''
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'navEl' ).'>';

            $this->add_render_attribute( 'prevEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-prev',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'prevEl' ).'>';
                $this->_render_icon( $settings['right_arrow'] );
            echo '</div>';

            $this->add_render_attribute( 'nextEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-next',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'nextEl' ).'>';
                $this->_render_icon( $settings['left_arrow'] );
            echo '</div>';

        echo '</div>';
    }

    if( $settings['dots'] === 'yes' ) {

        /**
         * Pagination
         */
        $this->add_render_attribute( 'pagination', [
            'class' => array_filter( [
                'kfw-swiper-pagination',
                'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination'
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'pagination' ).'></div>';
    }

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] === 'custom' ) {
        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-next %2$s for Next Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );

        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-prev %2$s for Prev Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );
    }

echo '</div>';