<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
use \Elementor\Plugin as KFEl;
use \Elementor\Utils as KFUtils;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Repeater as KFRTR;
use \Elementor\Icons_Manager as KFIM;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Airborne_Elements extends WB {

    public $devices_list;

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-airborne-elements';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Airborne Elements', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-animation';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'airborne', 'floating' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/airborne-elements';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        $this->devices_list = KFEl::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );

        wp_register_style( 'kfw-airborne',
            KFE_CONST_URL . 'libraries/elementor/assets/css/airborne' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-airborne' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
    }

    public function _register_items_section() {
		$repeater = new KFRTR();
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Items', 'onnat-extra' )
		]);
            $repeater->start_controls_tabs('items_tabs');
                $repeater->start_controls_tab('tab_item_type',[
                    'label' => esc_html__( 'Type', 'onnat-extra' ),
                ]);
                    $repeater->add_control( 'type', [
                        'label'   => esc_html__( 'Type', 'onnat-extra' ),
                        'type'    => KFCM::CHOOSE,
                        'options' => [
                            'blank' => [
                                'title' => esc_html__('Blank', 'onnat-extra'),
                                'icon'  => '',
                            ],
                            'icon'  => [
                                'title' => esc_html__('Icon', 'onnat-extra'),
                                'icon'  => 'eicon-plus-circle-o',
                            ],
                            'image' => [
                                'title' => esc_html__('Image', 'onnat-extra'),
                                'icon'  => 'eicon-image-bold',
                            ],
                            'text'  => [
                                'title' => esc_html__('Text', 'onnat-extra'),
                                'icon'  => 'eicon-animation-text',
                            ],
                        ],
                        'default' => 'icon',
                        'toggle'  => false,
                    ]);
                    $repeater->add_control( 'icon', [
                        'label'     => esc_html__( 'Icon', 'onnat-extra' ),
                        'type'      => KFCM::ICONS,
                        'default'   => [ '' ],
                        'condition' => [ 'type' => 'icon' ],
                    ]);
                    $repeater->add_control( 'image', [
                        'label'     => esc_html__( 'Image', 'onnat-extra' ),
                        'type'      => KFCM::MEDIA,
                        'dynamic'   => [
                            'active' => true,
                        ],
                        'default'   => [
                            'url' => KFUtils::get_placeholder_image_src(),
                        ],
                        'condition' => [ 'type' => 'image' ],
                    ]);
                    $repeater->add_control( 'text', [
                        'label'     => esc_html__( 'Text', 'onnat-extra' ),
                        'type'      => KFCM::TEXT,
                        'dynamic'   => [
                            'active' => true,
                        ],
                        'condition' => [ 'type' => 'text' ],
                        'default'   => 'A',
                    ]);
                    $repeater->add_control('hr0', [
                        'type'      => KFCM::DIVIDER,
                        'condition' => [
                            'type!'  => 'blank',
                        ],
                    ]);

                        $icon_condition = [
                            'type'         => 'icon',
                            'icon[value]!' => ''
                        ];
                        $img_condition = [
                            'type'        => 'image',
                            'image[url]!' => '',
                        ];
                        $txt_condition = [
                            'type'  => 'text',
                            'text!' => '',
                        ];

                        /**
                         * Title
                         */
                            $repeater->add_control('icon_type_settings_heading',[
                                'label'     => esc_html__( 'ICON SETTINGS', 'onnat-extra' ),
                                'type'      => KFCM::HEADING,
                                'condition' => $icon_condition,
                            ]);
                            $repeater->add_control('img_type_settings_heading',[
                                'label'     => esc_html__( 'IMAGE SETTINGS', 'onnat-extra' ),
                                'type'      => KFCM::HEADING,
                                'condition' => $img_condition,
                            ]);
                            $repeater->add_control('text_type_settings_heading',[
                                'label'     => esc_html__( 'TEXT SETTINGS', 'onnat-extra' ),
                                'type'      => KFCM::HEADING,
                                'condition' => $txt_condition,
                            ]);

                        /**
                         * Size
                         */
                            $repeater->add_responsive_control( 'icon_size', [
                                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                                'type'       => KFCM::SLIDER,
                                'size_units' => [ 'px' ],
                                'range'      => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 999,
                                    ],
                                ],
                                'condition'  => $icon_condition,
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-icon-item' => 'font-size: {{SIZE}}{{UNIT}};'
                                ],
                            ]);
                            $repeater->add_responsive_control( 'img_size', [
                                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                                'type'       => KFCM::SLIDER,
                                'size_units' => ['px', '%'],
                                'range'      => [
                                    '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                        'min'  => 5,
                                        'max'  => 1000,
                                        'step' => 5,
                                    ],
                                ],
                                'condition' => $img_condition,
                                'default'   => [
                                    'size' => 100,
                                    'unit' => 'px',
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}}, {{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-image-item' => 'width: {{SIZE}}{{UNIT}};'
                                ],
                            ]);

                        /**
                         * Icon Color
                         */
                            $repeater->add_control( 'icon_color', [
                                'label'     => esc_html__('Color', 'onnat-extra' ),
                                'type'      => KFCM::COLOR,
                                'condition' => $icon_condition,
                                'selectors' => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-icon-item i' => 'color:{{VALUE}};',
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-icon-item svg' => 'fill:{{VALUE}};',
                                ],
                            ]);

                        /**
                         * Text Type
                         */
                            $repeater->add_group_control(KFGCT::get_type(), [
                                'name'     => 'text_typo',
                                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                                'condition' => $txt_condition,
                                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-text-item',
                            ]);
                            $repeater->add_control( 'text_color', [
                                'label'     => esc_html__('Color', 'onnat-extra' ),
                                'type'      => KFCM::COLOR,
                                'condition' => $txt_condition,
                                'selectors' => ['{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-text-item' => 'color: {{VALUE}};' ],
                            ]);
                            $repeater->add_group_control( KFGCTS::get_type(), [
                                'name'      => 'title_txt_shadow',
                                'condition' => $txt_condition,
                                'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-text-item',
                            ]);
                            $repeater->add_group_control( KFGCTST::get_type(), [
                                'name'      => 'title_txt_stroke',
                                'condition' => $txt_condition,
                                'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-text-item',
                            ]);

                        /**
                         * Rotate
                         */
                            $repeater->add_control('item_rotate',[
                                'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
                                'type'      => KFCM::SLIDER,
                                'default'   => [
                                    'size' => 0,
                                    'unit' => 'deg',
                                ],
                                'range'     => [
                                    'deg' => [
                                        'max' => 360,
                                        'min' => -360,
                                    ],
                                ],
                                'conditions' => [
                                    'relation' => 'and',
                                    'terms'    => [
                                        [
                                            'name'     => 'type',
                                            'operator' => '!==',
                                            'value'    => 'blank'
                                        ],
                                        [
                                            'relation' => 'or',
                                            'terms'    => [
                                                [
                                                    'name'     => 'icon[value]',
                                                    'operator' => '!=',
                                                    'value'    => '',
                                                ],
                                                [
                                                    'name'     => 'image[url]',
                                                    'operator' => '!=',
                                                    'value'    => '',
                                                ],
                                                [
                                                    'name'     => 'text',
                                                    'operator' => '!=',
                                                    'value'    => '',
                                                ],
                                            ]
                                        ],
                                    ],
                                ],
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-icon-item svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-icon-item i'   => 'transform: rotate({{SIZE}}{{UNIT}});',
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-image-item img'   => 'transform: rotate({{SIZE}}{{UNIT}});',
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-text-item'   => 'transform: rotate({{SIZE}}{{UNIT}});',
                                ],
                            ]);

                        /**
                         * Background
                         */
                            $repeater->add_control('hr_margin_bg', [
                                'type' => KFCM::DIVIDER,
                            ]);
                            $repeater->add_responsive_control( 'bg_width', [
                                'label'      => esc_html__('Background Width', 'onnat-extra' ),
                                'type'       => KFCM::SLIDER,
                                'size_units' => ['px', '%'],
                                'range'      => [
                                    '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                        'min'  => 5,
                                        'max'  => 1000,
                                        'step' => 5,
                                    ],
                                ],
                                'condition' => [
                                    'type'  => 'blank',
                                ],
                                'default'   => [
                                    'size' => 100,
                                    'unit' => 'px',
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-blank-item' => 'width: {{SIZE}}{{UNIT}};'
                                ],
                            ]);
                            $repeater->add_responsive_control( 'bg_height', [
                                'label'      => esc_html__('Background Height', 'onnat-extra' ),
                                'type'       => KFCM::SLIDER,
                                'size_units' => ['px', '%'],
                                'range'      => [
                                    '%'  => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                    'px' => [
                                        'min'  => 5,
                                        'max'  => 1000,
                                        'step' => 5,
                                    ],
                                ],
                                'condition' => [
                                    'type'  => 'blank',
                                ],
                                'default'   => [
                                    'size' => 100,
                                    'unit' => 'px',
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-elementor-airborne-blank-item' => 'height: {{SIZE}}{{UNIT}};'
                                ],
                            ]);
                            $repeater->add_group_control( KFGCBG::get_type(), [
                                'name'           => 'item_bg',
                                'types'          => ['classic', 'gradient'],
                                'exclude'        => ['image'],
                                'fields_options' => [
                                    'background' => [ 'default' => 'classic' ],
                                    'color'      => [ 'default' => '' ],
                                ],
                                'selector'       => '{{WRAPPER}} {{CURRENT_ITEM}} > span',
                            ]);

                            $repeater->add_control('item_bg_rotate',[
                                'label'     => esc_html__( 'Background Rotate', 'onnat-extra' ),
                                'type'      => KFCM::SLIDER,
                                'default'   => [
                                    'size' => 0,
                                    'unit' => 'deg',
                                ],
                                'range'     => [
                                    'deg' => [
                                        'max' => 360,
                                        'min' => -360,
                                    ],
                                ],
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} > span'   => 'transform: rotate({{SIZE}}{{UNIT}});',
                                ],
                            ]);

                        /**
                         * Border
                         */
                            $repeater->add_group_control( KFGCBR::get_type(), [
                                'name'       => 'item_border',
                                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > span',
                            ]);

                        /**
                         * Border Radius
                         */
                            $repeater->add_responsive_control( 'item_border_radius', [
                                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                                'type'       => KFCM::DIMENSIONS,
                                'size_units' => [ 'px', '%' ],
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} > span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ]
                            ]);

                        /**
                         * Box Shadow
                         */
                            $repeater->add_group_control( KFGCBS::get_type(), [
                                'name'       => 'item_box_shadow',
                                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > span',
                            ]);

                        /**
                         * Margin & Padding
                         */
                            $repeater->add_control('hr_margin_padding', [
                                'type' => KFCM::DIVIDER,
                            ]);
                            $repeater->add_responsive_control( 'item_margin', [
                                'label'      => esc_html__('Margin', 'onnat-extra' ),
                                'type'       => KFCM::DIMENSIONS,
                                'size_units' => [ 'px', 'em', '%' ],
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                                ]
                            ]);
                            $repeater->add_responsive_control( 'item_padding', [
                                'label'      => esc_html__('Padding', 'onnat-extra' ),
                                'type'       => KFCM::DIMENSIONS,
                                'size_units' => [ 'px', 'em', '%' ],
                                'selectors'  => [
                                    '{{WRAPPER}} {{CURRENT_ITEM}} > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                                ]
                            ]);

                $repeater->end_controls_tab();
                $repeater->start_controls_tab('tab_item_spot',[
                    'label' => esc_html__( 'Spot', 'onnat-extra' ),
                ]);
                    $repeater->add_responsive_control( 'x-pos', [
                        'label'     => esc_html__('Y Postion', 'onnat-extra'),
                        'type'      => KFCM::SLIDER,
                        'range'     => [
                            'px' 	=> [
                                'min'  => -1000,
                                'max'  => 1000,
                                'step' => 5,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top:{{SIZE}}{{UNIT}};'
                        ]
                    ]);
                    $repeater->add_responsive_control( 'y-pos', [
                        'label'     => esc_html__('X Postion', 'onnat-extra'),
                        'type'      => KFCM::SLIDER,
                        'range'     => [
                            'px' 	=> [
                                'min'  => -1000,
                                'max'  => 1000,
                                'step' => 5,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left:{{SIZE}}{{UNIT}};'
                        ]
                    ]);
                $repeater->end_controls_tab();
                $repeater->start_controls_tab('tab_item_extra',[
                    'label' => esc_html__( 'Extra', 'onnat-extra' ),
                ]);
                    $repeater->add_control('z-index', [
                        'label'     => esc_html__('Z Index', 'onnat-extra'),
                        'type'      => KFCM::NUMBER,
                        'default'   => 1,
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}}' => 'z-index: {{VALUE}};'
                        ],
                    ]);
                    $repeater->add_control( 'gsap_scroll_smoother_settings', [
						'label'        => esc_html__('Scroll Smoother', 'onnat-extra'),
						'type'         => KFCM::POPOVER_TOGGLE,
						'return_value' => 'yes',
					]);
                    $repeater->start_popover();
                        $repeater->add_control( 'gsap_scroll_smoother', [
                            'label'        => esc_html__( 'Enable It', 'onnat-extra' ),
                            'type'         => KFCM::SWITCHER,
                            'return_value' => 'yes',
                            'default'      => '',
                        ]);
                        $repeater->add_control( 'gsap_scroll_smoother_speed', [
                            'label'      => esc_html__( 'Speed', 'onnat-extra' ),
                            'type'       => KFCM::SLIDER,
                            'size_units' => [],
                            'range'      => [
                                '' => [
                                    'min'  => -5,
                                    'max'  => 5,
                                    'step' => .5
                                ]
                            ],
                            'default'    => [
                                'unit' => '',
                                'size' => 0.8
                            ],
                            'condition'  => [
                                'gsap_scroll_smoother' => 'yes'
                            ],
                        ]);
                        $repeater->add_control( 'gsap_scroll_smoother_lag', [
                            'label'      => esc_html__( 'Lag', 'onnat-extra' ),
                            'type'       => KFCM::SLIDER,
                            'size_units' => [],
                            'range'      => [
                                '' => [
                                    'min'  => 0,
                                    'max'  => 3,
                                    'step' => .5
                                ]
                            ],
                            'default'    => [
                                'unit' => '',
                                'size' => 1
                            ],
                            'condition'  => [
                                'gsap_scroll_smoother' => 'yes'
                            ],
                        ]);
					$repeater->end_popover();
                    $repeater->add_control('animation', [
                        'label'       => esc_html__('Animation', 'onnat-extra'),
                        'type'        => KFCM::SELECT,
                        'label_block' => true,
                        'default'     => '',
                        'options'     => [
                            ''                               => esc_html__('None', 'onnat-extra'),
                            'kinfw-airborne-anim-flipinx'    => esc_html__('Flip In X', 'onnat-extra'),
                            'kinfw-airborne-anim-flipiny'    => esc_html__('Flip In Y', 'onnat-extra'),
                            'kinfw-airborne-anim-float-x'    => esc_html__('Float X', 'onnat-extra'),
                            'kinfw-airborne-anim-float-y'    => esc_html__('Float Y', 'onnat-extra'),
                            'kinfw-airborne-anim-jello'      => esc_html__('Jello', 'onnat-extra'),
                            'kinfw-airborne-anim-pulse'      => esc_html__('Pulse', 'onnat-extra'),
                            'kinfw-airborne-anim-rotate-alt' => esc_html__('Rotate Alt', 'onnat-extra'),
                            'kinfw-airborne-anim-rotate'     => esc_html__('Rotate', 'onnat-extra'),
                            'kinfw-airborne-anim-swing'      => esc_html__('Swing', 'onnat-extra'),
                            'kinfw-airborne-anim-wobble'     => esc_html__('Wobble', 'onnat-extra'),
                        ],
                    ]);
                    $repeater->add_control('visibility_settings_heading',[
                        'label' => esc_html__( 'VISIBILITY SETTINGS', 'onnat-extra' ),
                        'type'  => KFCM::HEADING,
                    ]);
                    $repeater->add_control('hr_anim', [
                        'type' => KFCM::DIVIDER,
                    ]);
                    $repeater->add_control('responsive_description',[
                        'raw'             => esc_html__( 'Responsive visibility will take effect only on preview mode or live page, and not while editing in Elementor.', 'onnat-extra' ),
                        'type'            => KFCM::RAW_HTML,
                        'content_classes' => 'elementor-descriptor',
                    ]);

                    $active_devices     = $this->devices_list;
                    $active_breakpoints = KFEl::$instance->breakpoints->get_active_breakpoints();

                    foreach ( $active_devices as $breakpoint_key ) {
                        $label = 'desktop' === $breakpoint_key ? esc_html__( 'Desktop', 'onnat-extra' ) : $active_breakpoints[ $breakpoint_key ]->get_label();

                        $repeater->add_control( 'hide_' . $breakpoint_key,[
                            'label'        => sprintf( esc_html__( 'Hide On %s', 'onnat-extra' ), $label ),
                            'type'         => KFCM::SWITCHER,
                            'default'      => '',
                            'label_on'     => esc_html__( 'Hide', 'onnat-extra' ),
                            'label_off'    => esc_html__( 'Show', 'onnat-extra' ),
                            'return_value' => 'elementor-hidden-' . $breakpoint_key,
                        ]);
                    }
                $repeater->end_controls_tab();
            $repeater->end_controls_tabs();

            $this->add_control('items', [
                'type'    => KFCM::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'type'      => 'icon',
                        'icon'      => [
                            'value'   => 'fab fa-wordpress',
                            'library' => 'fa-brands',
                        ],
                        'x-pos'     => [
                            'unit' => 'px',
                            'size' => 10
                        ],
                        'y-pos'     => [
                            'unit' => 'px',
                            'size' => 50
                        ],
                        'z-index'   => '1',
                        'animation' => 'kinfw-airborne-anim-float-x',
                    ],
                    [
                        'type'      => 'icon',
                        'icon'      => [
                            'value'   => 'fas fa-chess-king',
                            'library' => 'fa-solid',
                        ],
                        'x-pos'     => [
                            'unit' => 'px',
                            'size' => 10
                        ],
                        'y-pos'     => [
                            'unit' => 'px',
                            'size' => 100
                        ],
                        'z-index'   => '1',
                        'animation' => 'kinfw-airborne-anim-float-y',
                    ],
                ]
            ]);
		$this->end_controls_section();
    }

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
            echo '<span class="kfw-elementor-airborne-icon-item">';
                KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
            echo '</span>';
		}
    }

    public function _render_img( $settings = [] ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<span class="kfw-elementor-airborne-image-item">';
                echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
            echo '</span>';
        }
    }

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

    public function hidden_class( $item ) {
        $active_devices = $this->devices_list;

        $classes = [];
        foreach ( $active_devices as $breakpoint_key ) {
            $classes[] = $item[ 'hide_' . $breakpoint_key ];
        }

        return $classes;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-airborne-elements");
		include $render;
    }
}