<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Group_Control_Image_Size as KFGCIS;
use Elementor\Group_Control_Css_Filter as KFGCSSF;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_Blog_Single_Post_Featured_Image extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-blog-single-post-featured-image';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Post Featured Image', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_blog_post_look_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-featured-image';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'blog', 'post', 'single', 'image', 'featured' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/blog-single-post-featured-image';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-blog-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/blog-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-blog-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_image_section();
		$this->_register_image_style_section();
	}

	public function _register_image_section() {
		$this->start_controls_section( 'section_image', [
			'label' => esc_html__( 'Image', 'onnat-extra' )
		]);
			$this->add_group_control( KFGCIS::get_type(), [
				'name'    => 'image_size',
				'default' => 'full',
			]);
			/*$this->add_control( 'caption_source', [
				'label'   => esc_html__( 'Caption', 'onnat-extra' ),
				'type'    => KFCM::SELECT,
				'default' => 'none',
				'options' => [
					'none'       => esc_html__( 'None', 'onnat-extra' ),
					'attachment' => esc_html__( 'Attachment Caption', 'onnat-extra' ),
					'custom'     => esc_html__( 'Custom Caption', 'onnat-extra' ),
				],
			]);
			$this->add_control( 'caption', [
				'label'       => esc_html__( 'Custom Caption', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'default'     => '',
				'placeholder' => esc_html__( 'Enter your image caption', 'onnat-extra' ),
				'condition'   => [
					'caption_source' => 'custom',
				],
				'dynamic'     => [
					'active' => true,
				],
			]);
			$this->add_control( 'link_to',[
				'label'   => esc_html__( 'Link', 'onnat-extra' ),
				'type'    => KFCM::SELECT,
				'default' => 'none',
				'options' => [
					'none' => esc_html__( 'None', 'onnat-extra' ),
					'file' => esc_html__( 'Media File', 'onnat-extra' ),
					'post' => esc_html__( 'Post URL', 'onnat-extra' ),
				],
			]);*/
		$this->end_controls_section();
	}

	public function _register_image_style_section() {
		$this->start_controls_section( 'section_image_style', [
			'label' => esc_html__( 'Image', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control('align',[
				'label'        => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'left'    => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'toggle'       => false,
				'default'      => 'center',
				'selectors'    => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main' => 'text-align: {{VALUE}};',
				],
			]);
			$this->add_responsive_control('width',[
				'label'      => esc_html__( 'Width', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'%'  => [
						'min' => 10,
                        'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'width:{{SIZE}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control( 'max_width', [
				'label'          => esc_html__( 'Max Width', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'default'        => [ 'unit' => '%',],
				'tablet_default' => [ 'unit' => '%', ],
				'mobile_default' => [ 'unit' => '%', ],
				'size_units'     => [ 'px', '%', 'em', 'rem', 'vw', ],
				'range'          => [
					'%'  => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vm' => [
						'min' => 1,
						'max' => 100,
					]
				],
				'selectors'      => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'max-width: {{SIZE}}{{UNIT}};',
				]
			]);
			$this->add_responsive_control( 'height', [
				'label'          => esc_html__( 'Height', 'onnat-extra' ),
				'type'           => KFCM::SLIDER,
				'size_units'     => [ 'px', '%', 'em', 'rem', 'vw', ],
				'range'          => [
					'px' => [
						'min' => 1,
						'max' => 500,
					],
					'vh' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'height: {{SIZE}}{{UNIT}};',
				]
			]);
			$this->add_responsive_control( 'object_fit', [
				'label'     => esc_html__( 'Object Fit', 'onnat-extra' ),
				'type'      => KFCM::SELECT,
				'condition' => [ 'height[size]!' => '', ],
				'options'   => [
					''        => esc_html__( 'Default', 'onnat-extra' ),
					'fill'    => esc_html__( 'Fill', 'onnat-extra' ),
					'cover'   => esc_html__( 'Cover', 'onnat-extra' ),
					'contain' => esc_html__( 'Contain', 'onnat-extra' ),
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'object-fit: {{VALUE}};',
				],
			]);
			$this->add_responsive_control( 'object_position', [
				'label'     => esc_html__( 'Object Position', 'onnat-extra' ),
				'type'      => KFCM::SELECT,
				'options'   => [
					'center center' => esc_html__( 'Center Center', 'onnat-extra' ),
					'center left'   => esc_html__( 'Center Left', 'onnat-extra' ),
					'center right'  => esc_html__( 'Center Right', 'onnat-extra' ),
					'top center'    => esc_html__( 'Top Center', 'onnat-extra' ),
					'top left'      => esc_html__( 'Top Left', 'onnat-extra' ),
					'top right'     => esc_html__( 'Top Right', 'onnat-extra' ),
					'bottom center' => esc_html__( 'Bottom Center', 'onnat-extra' ),
					'bottom left'   => esc_html__( 'Bottom Left', 'onnat-extra' ),
					'bottom right'  => esc_html__( 'Bottom Right', 'onnat-extra' ),
				],
				'default'   => 'center center',
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'object-position: {{VALUE}};',
				],
				'condition' => [
					'height[size]!' => '',
					'object_fit'    => 'cover',
				]
			]);
			$this->add_control( 'image_tab_before_hr', [
				'type'  => KFCM::DIVIDER,
			]);
			$this->start_controls_tabs('image_effects');
				$this->start_controls_tab('normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'opacity', [
						'label'     => esc_html__( 'Opacity', 'onnat-extra' ),
						'type'      => KFCM::SLIDER,
						'range'     => [
							'px' => [
								'max'  => 1,
								'min'  => 0.10,
								'step' => 0.01,
							]
						],
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'opacity: {{SIZE}};',
						]
					]);
					$this->add_group_control( KFGCSSF::get_type(), [
						'name'      => 'css_filters',
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'image_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img',
					]);
					$this->add_responsive_control( 'image_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'image_box_shadow',
						'exclude'  => [ 'box_shadow_position', ],
						'selector' => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img',
					]);		
				$this->end_controls_tab();
				$this->start_controls_tab('hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'opacity_hover', [
						'label'     => esc_html__( 'Opacity', 'onnat-extra' ),
						'type'      => KFCM::SLIDER,
						'range'     => [
							'px' => [
								'max'  => 1,
								'min'  => 0.10,
								'step' => 0.01,
							]
						],
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover' => 'opacity: {{SIZE}};',
						]
					]);
					$this->add_group_control( KFGCSSF::get_type(), [
						'name'      => 'css_filters_hover',
						'selector'  => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover',
					]);
					$this->add_control('hover_animation',[
						'label' => esc_html__( 'Hover Animation', 'onnat-extra' ),
						'type'  => KFCM::HOVER_ANIMATION,
					]);
					$this->add_control( 'transition_duration',[
						'label'     => esc_html__( 'Transition Duration', 'onnat-extra' ),
						'type'      => KFCM::SLIDER,
						'range'     => [
							'px' => [
								'max'  => 3,
								'step' => 0.1,
							]
						],
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover' => 'transition-duration: {{SIZE}}s',
						],
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'hover_image_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover',
					]);
					$this->add_responsive_control( 'hover_image_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [ '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'hover_image_box_shadow',
						'exclude'  => [ 'box_shadow_position', ],
						'selector' => '{{WRAPPER}} .kfw-ele-widget-post-featured-image-main img:hover',
					]);		
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Get attachment image src.
	 */
	public static function _get_image_src( $attachment_id, $image_size_key, array $settings ) {
        return KFGCIS::get_attachment_image_src( $attachment_id, $image_size_key, $settings );
	}

	public function _get_featured_image_title( $attachment_id ) {
		if ( empty( $attachment_id ) ) {
			return '';
		}

		return get_the_title( $attachment_id );
	}

	public function _get_featured_image_alt( $attachment_id ) {
		if ( empty( $attachment_id ) ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );

		return trim( strip_tags( $alt ) );
	}

	public function _get_custom_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_custom_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-blog-single-post-featured-image");
		include $render;
    }
}