<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as KFWB;
use \Elementor\Controls_Manager as KFCM;

use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_CPT_Project_Meta extends KFWB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-project-meta';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Project Meta', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_single_project_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-meta-data';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'project', 'meta', 'data' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-project-meta';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-cpt-project-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/cpt-project-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-cpt-project-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_settings_section();
        $this->_register_title_style_section();
        $this->_register_meta_style_section();
	}

	protected function _register_settings_section() {
		$this->start_controls_section( 'section_meta_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
		]);
			$this->add_control('layout',[
				'label'        => esc_html__( 'Layout', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'inline' => [
						'title' => esc_html__('Inline', 'onnat-extra'),
						'icon'  => 'eicon-column',
					],
					'stack'  => [
						'title' => esc_html__('Stack', 'onnat-extra'),
						'icon'  => 'eicon-section',
					],
				],
				'default'      => 'stack',
				'prefix_class' => 'kfw-ele-widget-cpt-project-meta-layout-',
				'toggle'       => false,
				'condition'    => [
					'add_title' => 'yes'
				],
			]);
			$this->add_control('meta',[
				'label'     => esc_html__( 'Meta?', 'onnat-extra' ),
				'type'      => KFCM::SELECT,
				'default'   => '',
				'options'   => [
					''          => esc_html__('None', 'onnat-extra'),
					'category'  => esc_html__('Category', 'onnat-extra'),
					'customer'  => esc_html__('Customer', 'onnat-extra'),
					'startdate' => esc_html__('Start Date', 'onnat-extra'),
					'enddate'   => esc_html__('End Date', 'onnat-extra'),
					'rating'    => esc_html__('Rating', 'onnat-extra'),
					'website'   => esc_html__('Website', 'onnat-extra'),
				],
			]);
			$this->add_control( 'date_format', [
				'label'     => esc_html__( 'Date Format?', 'onnat-extra' ),
				'type'      => KFCM::SELECT,
				'default'   => 'F j, Y',
				'options'   => [
					'F j, Y' => 'March 17, 1985',
					'Y-m-d'  => '1985-03-17',
					'm/d/Y'  => '03/17/1985',
					'd/m/Y'  => '17/03/1985',
					'custom' => esc_html__('Custom', 'onnat-extra'),
				],
				'condition' => [
					'meta' => [ 'startdate', 'enddate' ]
				],
			]);
			$this->add_control( 'custom_date_format', [
				'label'       => esc_html__( 'Date Format?', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'dynamic'     => [ 'active' => true, ],
				'placeholder' => 'F j, Y',
				'default'     => 'F j, Y',
				'condition'   => [
					'meta'        => [ 'startdate', 'enddate' ],
					'date_format' => 'custom'
				],
			]);
            $this->add_control( 'add_title', [
				'label'        => esc_html__( 'Add Title?', 'onnat-extra' ),
				'type'         => KFCM::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'meta!'     => ''
				],
            ]);
			$this->add_control('title',[
				'label'       => esc_html__( 'Title', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'dynamic'     => [ 'active' => true, ],
				'placeholder' => esc_html__( 'Enter Title', 'onnat-extra' ),
				'label_block' => true,
				'condition'   => [
					'add_title' => 'yes',
					'meta!'     => ''
                ]
			]);
			$this->add_control('title_settings_des', [
				'type'            => KFCM::RAW_HTML,
				'content_classes' => 'kfw-elementor-editor-notice-ctrl',
				'raw'             => sprintf( esc_html__('Leaving the title field empty will automatically generate and use the default title for the meta information.','onnat-extra') ),
				'condition'       => [
					'add_title' => 'yes',
					'meta!'     => '',
					'title'     => '',
                ]
            ]);
			$this->add_responsive_control( 'align', [
				'label'     => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'      => KFCM::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__('Left', 'onnat-extra'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'onnat-extra'),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__('Right', 'onnat-extra'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => 'false',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
			]);
		$this->end_controls_section();
	}

	protected function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label'     => esc_html__( 'Title', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'add_title' => 'yes',
				'meta!'     => ''
			]
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => ''
				],
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
			]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-cpt-project-meta-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-cpt-project-meta-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => ['{{WRAPPER}} .kfw-ele-cpt-project-meta-title' => 'color: {{VALUE}};' ],
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'      => 'title_txt_shadow',
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'      => 'title_txt_stroke',
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'      => 'title_bg',
				'label'     => esc_html__('Background', 'onnat-extra' ),
				'types'     => [ 'classic', 'gradient' ],
				'exclude'   => [ 'image' ],
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'title_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
				'condition'      => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
			]);
			$this->add_responsive_control( 'title_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kfw-ele-cpt-project-meta-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
				'condition'  => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'title_box_shadow',
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-title',
				'condition' => [
					'add_title' => 'yes',
					'meta!'     => '',
				],
			]);
		$this->end_controls_section();
	}

	protected function _register_meta_style_section() {
		$this->start_controls_section( 'section_meta_style', [
			'label'     => esc_html__( 'Meta', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'meta!' => ''
			]
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'meta_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'condition' => [
					'meta!' => ''
				],
				'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data, {{WRAPPER}} .kfw-ele-cpt-project-meta-data a',
			]);
            $this->add_responsive_control( 'meta_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [
					'meta!' => '',
				],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-cpt-project-meta-data' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'meta_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [
					'meta!' => '',
				],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-cpt-project-meta-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'meta_customize_tabs' );
                $this->start_controls_tab( 'meta_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => [
						'meta!' => '',
					],
                ]);
                    $this->add_control( 'meta_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kfw-ele-cpt-project-meta-data, {{WRAPPER}} .kfw-ele-cpt-project-meta-data a' => 'color: {{VALUE}};' ],
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'      => 'meta_txt_shadow',
                        'condition' => [
							'meta!' => '',
						],
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'      => 'meta_txt_stroke',
                        'condition' => [
							'meta!' => '',
						],
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data',
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'      => 'meta_bg',
                        'label'     => esc_html__('Background', 'onnat-extra' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'exclude'   => [ 'image' ],
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data',
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'           => 'meta_border',
                        'fields_options' => [
                            'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
                            'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
                        ],
                        'selector'       => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data',
                        'condition'      => [
							'meta!' => '',
						],
                    ]);
                    $this->add_responsive_control( 'meta_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [ '{{WRAPPER}} .kfw-ele-cpt-project-meta-data' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
                        'condition'  => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'meta_box_shadow',
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data',
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                $this->end_controls_tab();
				$this->start_controls_tab( 'meta_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
					'condition' => [
						'meta!' => '',
					],
				]);
                    $this->add_control( 'meta_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => [
							'{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover, {{WRAPPER}} .kfw-ele-cpt-project-meta-data a:hover' => 'color: {{VALUE}};'
						],
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'      => 'meta_hover_txt_shadow',
                        'condition' => [
							'meta!' => '',
						],
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'      => 'meta_hover_txt_stroke',
                        'condition' => [
							'meta!' => '',
						],
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover',
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'      => 'meta_hover_bg',
                        'label'     => esc_html__('Background', 'onnat-extra' ),
                        'types'     => [ 'classic', 'gradient' ],
                        'exclude'   => [ 'image' ],# To remove background image option in classic mode
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover',
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'           => 'meta_hover_border',
                        'fields_options' => [
                            'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
                            'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
                        ],
                        'selector'       => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover',
                        'condition'      => [
							'meta!' => '',
						],
                    ]);
                    $this->add_responsive_control( 'meta_hover_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [ '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
                        'condition'  => [
							'meta!' => '',
						],
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'meta_hover_box_shadow',
                        'selector'  => '{{WRAPPER}} .kfw-ele-cpt-project-meta-data:hover',
                        'condition' => [
							'meta!' => '',
						],
                    ]);
                $this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }	

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-project-meta");
		include $render;
    }

}