<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;

use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_CPT_Project_Post_Content extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-project-post-content';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Project Content', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_single_project_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-post-content';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'project', 'post', 'single', 'content' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-project-post-content';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-cpt-project-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/cpt-project-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-cpt-project-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

    public function _content() {
		$mode     = $this->_is_editor_mode();
		if( $mode ) {
			$post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-project' );
			$this->render_post_content( $post_id, false, true );
		} else {
			$post_id          = get_the_id();
			$elementor        = \Elementor\Plugin::instance();
			$is_elementor_doc = $elementor->documents->get( $post_id )->is_built_with_elementor();

			if( $is_elementor_doc ) {
				echo $elementor->frontend->get_builder_content( $post_id, false );
			} else {
				echo get_the_content( $post_id );
			}
		}
	}

	public function render_post_content( $recent_post_id, $with_wrapper = false, $with_css = true ) {
		static $did_posts = [];
		static $level = 0;

		$post = get_post();

		if ( post_password_required( $post->ID ) ) {
			echo get_the_password_form( $post->ID );
			return;
		}

		// Avoid recursion
		if ( isset( $did_posts[ $post->ID ] ) ) {
			return;
		}

		$level++;
		$did_posts[ $post->ID ] = true;
		// End avoid recursion

		$editor = \Elementor\Plugin::$instance->editor;
		$is_edit_mode = $editor->is_edit_mode();

		$post_id = $post->ID;
		if( $recent_post_id > 0 ) {
			$post_id = $recent_post_id;
			$post = get_post( $post_id, OBJECT );
			setup_postdata( $post );
		}

		// Set edit mode as false, so don't render settings and etc. use the $is_edit_mode to indicate if we need the CSS inline
		$editor->set_edit_mode( false );
		$elementor_page = get_post_meta( $post_id , '_elementor_edit_mode', true );

		$content = $elementor_page ? \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id, $with_css ) : get_the_content($post_id);

		// Restore edit mode state
		\Elementor\Plugin::$instance->editor->set_edit_mode( $is_edit_mode );

		echo $content;

		$level--;

		if ( 0 === $level ) {
			$did_posts = [];
		}
	}

	public function render_plain_content() {}    

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-project-post-content");
		include $render;
    }
}