<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use Elementor\Widget_Base as KFWB;
use Elementor\Controls_Manager as KFCM;
use Elementor\Group_Control_Border as KFGCBR;
use Elementor\Group_Control_Background as KFGCBG;

class KFW_CPT_Project_Social_Links extends KFWB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-project-social-links';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Project Social Links', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_single_project_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-social-icons';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'project', 'social', 'links' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-project-social-links';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-cpt-project-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/cpt-project-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-cpt-project-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
        $this->_register_settings_section();
        $this->_register_style_section();
	}

	protected function _register_settings_section() {
		$this->start_controls_section( 'section_social_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
		]);
			$this->add_control('layout',[
				'label'        => esc_html__( 'Layout', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'horizontal' => [
						'title' => esc_html__('Horizontal', 'onnat-extra'),
						'icon'  => 'eicon-navigation-horizontal',
					],
					'vertical'   => [
						'title' => esc_html__('Vertical', 'onnat-extra'),
						'icon'  => 'eicon-navigation-vertical',
					],
				],
				'default'      => 'horizontal',
				'prefix_class' => 'kfw-ele-widget-cpt-project-social-share-layout-',
				'toggle'       => false
			]);
			$this->add_responsive_control( 'align', [
				'label'     => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'      => KFCM::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__('Left', 'onnat-extra'),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'onnat-extra'),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__('Right', 'onnat-extra'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => 'false',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
			]);
		$this->end_controls_section();
	}

	protected function _register_style_section() {
		$this->start_controls_section( 'section_social_style', [
			'label' => esc_html__( 'Social Share', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'icon_size', [
				'label'      => esc_html__('Icon Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 999,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a:before' => 'font-size:{{SIZE}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control( 'size', [
				'label'      => esc_html__('Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 999,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a'        => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-social-links li a:before' => 'line-height:{{SIZE}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control('margin', [
				'label'      => esc_html__( 'Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);
			$this->start_controls_tabs( 'customize_tabs' );
				$this->start_controls_tab( 'normal_state', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_responsive_control( 'border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'hover_state', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:hover:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'hover_bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'hover_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_responsive_control( 'hover_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }	

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-project-social-links");
		include $render;
    }

}