<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Project_Template extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-project-template';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Project Template', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_theme_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-posts-group';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'project', 'template' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/project-template';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_script( 'isotope-pkgd',
            KFE_CONST_URL . 'assets/js/isotope.pkgd.min.js',
            [],
            KFE_CONST_VERSION,
            true
        );

        wp_register_script( 'kfw-tpl-project',
            KFE_CONST_URL . 'libraries/elementor/assets/js/cpt-project-tpl' . KFE_CONST_DEBUG_SUFFIX . '.js',
            [ 'jquery', 'elementor-frontend' ],
            KFE_CONST_VERSION,
            true
        );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'isotope-pkgd', 'kfw-tpl-project' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_settings_section();
		$this->_register_query_settings_section();

        $this->_register_wrap_style_section();
        $this->_register_icon_style_section();

        $this->_register_content_wrap_style_section();
        $this->_register_post_title_style_section();
        $this->_register_cat_style_section();
    }

	public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_control('layout', [
                'label'   => esc_html__( 'Layout', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'options' => [
                    'grid-1'   => [
                        'title' => esc_html__('Grid Style 1', 'onnat-extra' ),
                        'icon'  => 'eicon-gallery-grid'
                    ],
                    'masonry'   => [
                        'title' => esc_html__('Masonry', 'onnat-extra' ),
                        'icon'  => 'eicon-posts-justified'
                    ],
                ],
                'default' => 'grid-1',
                'toggle'  => false
            ]);
            $this->add_control('type',[
                'label'   => esc_html__( 'Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'toggle'  => false,
                'default' => '2',
                'options' => [
                    '1' => [
                        'title' => esc_html__('Type 1', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-1-icon'
                    ],
                    '2' => [
                        'title' => esc_html__('Type 2', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-2-icon'
                    ],
                    '3' => [
                        'title' => esc_html__('Type 3', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-3-icon'
                    ],
                    '4' => [
                        'title' => esc_html__('Type 4', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-4-icon'
                    ],                    
                ],
            ]);
			$this->add_responsive_control('cols', [
				'label'          => esc_html__( 'Columns', 'onnat-extra' ),
				'type'           => KFCM::CHOOSE,
				'options'        => [
					'1' => [
                        'title' => esc_html__('1 Column', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-icon'
                    ],
					'2' => [
                        'title' => esc_html__('2 Columns', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon'
                    ],
					'3' => [
                        'title' => esc_html__('3 Columns', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-3-icon'
                    ],
					'4' => [
                        'title' => esc_html__('4 Columns', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-4-icon'
                    ],
				],
				'devices'        => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
                'default'        => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'toggle'         => false,
                'selectors'      => [
                    '{{WRAPPER}} .kfw-ele-widget-cpt-project-tpl-main.kfw-ele-widget-cpt-project-tpl-grid-1 .kinfw-project-posts-wrap' => 'display:grid; grid-template-columns: repeat({{SIZE}}, minmax(0, 1fr));',
                ],
                'condition'      => [
                    'layout' => [ 'grid-1',  ]
                ]
            ]);
			$this->add_responsive_control('col_gap',[
                'label'     => esc_html__( 'Column Gap', 'onnat-extra' ),
                'type'      => KFCM::SLIDER,
                'default'   => [ 'size' => 20, ],
                'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
                'selectors' => [
                    '{{WRAPPER}} .kfw-ele-widget-cpt-project-tpl-main.kfw-ele-widget-cpt-project-tpl-grid-1 .kinfw-project-posts-wrap' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout' => [ 'grid-1', ]
                ]
            ]);
			$this->add_responsive_control('row_gap',[
                'label'     => esc_html__( 'Row Gap', 'onnat-extra' ),
                'type'      => KFCM::SLIDER,
                'default'   => [ 'size' => 20, ],
                'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
                'selectors' => [
                    '{{WRAPPER}} .kfw-ele-widget-cpt-project-tpl-main.kfw-ele-widget-cpt-project-tpl-grid-1 .kinfw-project-posts-wrap' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout' => [ 'grid-1', ]
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_query_settings_section() {
		$this->start_controls_section( 'section_query_settings', [
			'label' => esc_html__( 'Query Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_control('posts_per_page', [
                'label'   => esc_html__( 'Items Per Page', 'onnat-extra' ),
                'type'    => KFCM::NUMBER,
                'min'     => -1,
                'max'     => 20,
                'step'    => 1,
                'default' => 10,
            ]);
            $this->add_control( 'cat_param', [
                'label'        => esc_html__('Show posts from specific categories.', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => ''
            ]);
            $this->add_control('cat',[
                'label'       => esc_html__( 'Categories?', 'onnat-extra' ),
                'label_block' => true,
                'type'        => KFCM::SELECT2,
                'multiple'    => true,
                'options'     => $this->get_terms( 'kinfw-project-category' ),
                'condition'   => [
                    'cat_param!' => ''
                ]
            ]);
            $this->add_control( 'order', [
                'label'        => esc_html__('Post Order.', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'label_on'     => esc_html__('ASC', 'onnat-extra' ),
                'label_off'    => esc_html__('DESC', 'onnat-extra' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]);
            $this->add_control( 'orderby', [
                'label'   => esc_html__('Sort Posts by.', 'onnat-extra' ),
                'type'    => KFCM::SELECT,
                'options' => [
                    'none'       => esc_html__('None', 'onnat-extra'),
                    'ID'         => esc_html__('Post ID', 'onnat-extra'),
                    'author'     => esc_html__('Author', 'onnat-extra'),
                    'title'      => esc_html__('Title', 'onnat-extra'),
                    'name'       => esc_html__('Slug', 'onnat-extra'),
                    'date'       => esc_html__('Date', 'onnat-extra'),
                    'modified'   => esc_html__('Last Modified Date', 'onnat-extra'),
                    'rand'       => esc_html__('Random order', 'onnat-extra'),
                    'menu_order' => esc_html__('Menu order', 'onnat-extra'),
                ],
                'default' => 'date'
            ]);
		$this->end_controls_section();
    }

    public function _register_wrap_style_section() {
		$this->start_controls_section( 'section_wrap_style_settings', [
			'label' => esc_html__( 'Wrap', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'           => 'featured_img_bg',
                'types'          => ['classic', 'gradient'],
                'exclude'        => [ 'image'],
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '' ],
                ],
                'selector'       => '{{WRAPPER}} .kinfw-project-item .kinfw-project-img',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'featured_img_border',
                'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-img',
            ]);
            $this->add_responsive_control( 'featured_img_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-img, {{WRAPPER}} .kinfw-project-item .kinfw-project-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'featured_img_box_shadow',
                'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-img',
            ]);
            $this->add_responsive_control( 'featured_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_icon_style_section() {
        $condition = [
            'type!' => [ '2', '3' ]
        ];

		$this->start_controls_section( 'section_icon_style', [
            'label'     => esc_html__( 'Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition,
		]);
            $this->add_responsive_control( 'btn_icon_wrapper_size', [
                'label'      => esc_html__('Icon Wrapper Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon' => 'line-height:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};width:{{SIZE}}{{UNIT}};',
                ],
                'condition'  => $condition,
            ]);
            $this->add_responsive_control( 'btn_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon span' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
                'condition'  => $condition 
            ]);
            $this->add_responsive_control( 'btn_icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [ 'type' => '1' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'readmore_btn_icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => [ 'type' => '1' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'readmore_wrapper_color', [
				'label'     => esc_html__('Curve Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'condition' => [ 'type' => '1' ],
				'selectors' => [
					'{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon' => 'background-color: {{VALUE}}; color: {{VALUE}};'
				],
			]);
            $this->start_controls_tabs( 'btn_icon_customize_tabs', [
                'condition' => $condition,
            ]);
                $this->start_controls_tab( 'btn_icon_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => $condition,
                ]);
                    $this->add_control( 'btn_icon_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $condition,
                        'selectors' => [
                            '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon span' => 'color:{{VALUE}};',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'btn_icon_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],                        
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $condition,
                        'selector'       => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'btn_icon_border',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon',
                    ]);
                    $this->add_responsive_control( 'btn_icon_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'condition'  => $condition,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'btn_icon_box_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1 .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon'
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'btn_icon_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                    'condition' => $condition,
                ]);
                    $this->add_control( 'btn_icon_h_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $condition,
                        'selectors' => [
                            '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1:hover .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon:hover span' => 'color:{{VALUE}};',
                        ],
                    ]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'           => 'btn_icon_h_bg',
                        'types'          => ['classic', 'gradient'],
                        'exclude'        => [ 'image'],
                        'fields_options' => [
                            'background' => [ 'default' => 'classic' ],
                            'color'      => [ 'default' => '' ],
                        ],
                        'condition'      => $condition,
                        'selector'       => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1:hover .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon:hover',
                    ]);
                    $this->add_group_control( KFGCBR::get_type(), [
                        'name'      => 'btn_icon_h_border',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1:hover .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon:hover'
                    ]);
                    $this->add_responsive_control( 'btn_icon_h_border_radius', [
                        'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                        'type'       => KFCM::DIMENSIONS,
                        'condition'  => $condition,
                        'size_units' => [ 'px', '%' ],
                        'selectors'  => [
                            '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1:hover .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ]
                    ]);
                    $this->add_group_control( KFGCBS::get_type(), [
                        'name'      => 'btn_icon_h_box_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item.kinfw-project-style-1:hover .kinfw-project-icon span, {{WRAPPER}} .kinfw-project-item.kinfw-project-style-4 .kinfw-project-icon:hover'
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_content_wrap_style_section() {
		$this->start_controls_section( 'section_content_wrap_style_settings', [
			'label' => esc_html__( 'Content Wrap', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'           => 'content_bg',
                'types'          => ['classic', 'gradient'],
                'exclude'        => [ 'image'],
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '' ],
                ],
                'selector'       => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'content_border',
                'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content',
            ]);
            $this->add_responsive_control( 'content_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'content_box_shadow',
                'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content',
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_post_title_style_section() {
		$this->start_controls_section( 'section_p_title_style', [
			'label' => esc_html__( 'Post Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'title_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3',
            ]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'title_customize_tabs' );
                $this->start_controls_tab( 'title_normal_state', [
                    'label' => esc_html__( 'Normal', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_txt_shadow',
                        'selector' => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_txt_stroke',
                        'selector' => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'title_hover_state', [
                    'label' => esc_html__( 'Hover', 'onnat-extra' ),
                ]);
                    $this->add_control( 'title_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'selectors' => ['{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a:hover' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'     => 'title_hover_txt_shadow',
                        'selector' => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a:hover',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'     => 'title_hover_txt_stroke',
                        'selector' => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content h3 a:hover',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function _register_cat_style_section() {
        $condition = [
            'type!' => [ '4' ]
        ];
		$this->start_controls_section( 'section_cat_style', [
            'label'     => esc_html__( 'Post Category', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'      => 'cat_typo',
                'label'     => esc_html__( 'Typography', 'onnat-extra' ),
                'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p a, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat',
                'condition' => $condition,
            ]);
            $this->add_responsive_control( 'cat_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'cat_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p a, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->start_controls_tabs( 'cat_customize_tabs', [
                'condition'  => $condition,
            ] );
                $this->start_controls_tab( 'cat_normal_state', [
                    'label'     => esc_html__( 'Normal', 'onnat-extra' ),
                    'condition' => $condition,
                ]);
                    $this->add_control( 'cat_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $condition,
                        'selectors' => [
                            '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p, {{WRAPPER}} .kinfw-project-item .kinfw-project-content p a' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat' => 'color: {{VALUE}};',
                        ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'      => 'cat_txt_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'      => 'cat_txt_stroke',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat',
                    ]);
                $this->end_controls_tab();
                $this->start_controls_tab( 'cat_hover_state', [
                    'label'     => esc_html__( 'Hover', 'onnat-extra' ),
                    'condition' => $condition,
                ]);
                    $this->add_control( 'cat_hover_color', [
                        'label'     => esc_html__('Color', 'onnat-extra' ),
                        'type'      => KFCM::COLOR,
                        'condition' => $condition,
                        'selectors' => ['{{WRAPPER}} .kinfw-project-item .kinfw-project-content p a:hover, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat a:hover' => 'color: {{VALUE}};' ],
                    ]);
                    $this->add_group_control( KFGCTS::get_type(), [
                        'name'      => 'cat_hover_txt_shadow',
                        'condition' => $condition,
                        'selector'  => '{{WRAPPER}} .kinfw-project-item .kinfw-project-content p:hover a, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat a:hover',
                    ]);
                    $this->add_group_control( KFGCTST::get_type(), [
                        'name'      => 'cat_hover_txt_stroke',
                        'condition' => $condition,
                        'selector'  => '.kinfw-project-item .kinfw-project-content p:hover a, {{WRAPPER}} .kinfw-project-item .kinfw-project-content .kinfw-project-cat a:hover',
                    ]);
                $this->end_controls_tab();
            $this->end_controls_tabs();
		$this->end_controls_section();
    }

    public function get_terms( $taxonomy = 'category' ) {
        $options = [];

        if( !empty( $taxonomy ) ) {
            $terms = get_terms([
                'taxonomy'   => $taxonomy,
                'hide_empty' => true,
            ]);

            if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
                foreach ( $terms as $term ) {
                    $options[ $term->term_id ] = $term->name;
                }
            }
        }

        return $options;
    }

    public function get_args( $settings = [] ) {
        $args = [
            'post_status'    => 'publish',
            'post_type'      => 'kinfw-project',
            'posts_per_page' => $settings['posts_per_page'],
            'order'          => ( $settings['order'] === 'yes' ) ? 'ASC' : 'DESC',
            'orderby'        => $settings['orderby']
        ];

        // Paged
            if ( get_query_var('paged') ) {
                $paged = get_query_var('paged');
            } elseif ( get_query_var('page') ) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }

            $args['paged'] = $paged;

        // Category Param
        if( $settings['cat_param'] === 'yes' ) {
            if( is_array( $settings['cat'] ) && count( $settings['cat'] ) > 0 ) {
                $args['tax_query'] = [[
                    'taxonomy' => 'kinfw-project-category',
                    'field'    => 'term_id',
                    'terms'    => $settings['cat']
                ]];
            }
        }

        return $args;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-project-template");
		include $render;
    }

}