<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as KFWB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Repeater as KFRTR;

class KFW_Info_List_Minimal extends KFWB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-info-list-minimal';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Info List : Minimal', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-counter';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'info', 'list', 'fancy', 'minimal'];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
		return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/info-list-minimal';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_style( 'kfw-info-list-minimal',
			KFE_CONST_URL . 'libraries/elementor/assets/css/info-list-minimal' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-info-list-minimal' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_settings_section();

		$this->_register_shape_style_section();
		$this->_register_indicator_style_section();
		$this->_register_title_style_section();
		$this->_register_info_style_section();
	}

	public function _register_items_section() {
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Items', 'onnat-extra' )
        ]);

			$repeater = new KFRTR();

				$repeater->add_control('title',[
					'label'       => esc_html__( 'Title', 'onnat-extra' ),
					'type'        => KFCM::TEXT,
					'dynamic'     => [ 'active' => true ],
					'default'     => esc_html__( 'Item Title' , 'onnat-extra' ),
					'label_block' => true,
				]);
				$repeater->add_control('info',[
					'label' => esc_html__('Info', 'onnat-extra'),
					'type'      => KFCM::WYSIWYG,
				]);
				$repeater->add_control('title_link',[
					'label'     => esc_html__( 'Link', 'onnat-extra' ),
					'type'      => KFCM::URL,
					'dynamic'   => [
						'active' => true
					],
					'options'   => [
						'url',
						'is_external',
						'nofollow'
					],
					'default'   => [
						'url'         => '',
						'is_external' => true,
						'nofollow'    => true,
					],
					'condition' => [
						'title!' => ''
					]
				]);
				$repeater->add_control( 'customize', [
					'label'   => esc_html__( 'Customize It?', 'onnat-extra' ),
					'type'    => KFCM::SWITCHER,
					'default' => 'no',
				]);
				$repeater->add_control('customize_after_hr',[
					'type'      => KFCM::DIVIDER,
					'condition' => [
						'customize' => 'yes'
					]
				]);
				$repeater->add_control('icon_color',[
					'label'     => esc_html__('Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => [
						'{{WRAPPER}} {{CURRENT_ITEM}}.kfw-ele-widget-info-list-minl-item:before' => 'color:{{VALUE}};'
					],
					'condition' => [
						'customize' => 'yes'
					]
				]);
				$repeater->add_group_control( KFGCBG::get_type(), [
					'name'      => 'icon_bg',
					'types'     => ['classic', 'gradient'],
					'exclude'   => [ 'image'],
					'selector'  => '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-ele-widget-info-list-minl-shape',
					'condition' => [
						'customize' => 'yes'
					]
				]);
				$repeater->add_control('rotate',[
					'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
					'type'      => KFCM::SLIDER,
					'default'   => [
						'size' => 0,
						'unit' => 'deg',
					],
					'range'     => [
						'deg' => [
							'max' => 360,
							'min' => - 360,
						],
					],
					'selectors' => [
						'{{WRAPPER}} {{CURRENT_ITEM}}.kfw-ele-widget-info-list-minl-item:before'   => 'transform: rotate({{SIZE}}{{UNIT}});',
					],
					'condition' => [
						'customize' => 'yes'
					]
				]);
				$repeater->add_control('icon_background_rotate',[
					'label'     => esc_html__( 'Background Rotate', 'onnat-extra' ),
					'type'      => KFCM::SLIDER,
					'default'   => [ 'size' => 0,'unit' => 'deg',],
					'range'     => ['deg' => ['max' => 360,'min' => - 360,],],
					'selectors' => [ '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-ele-widget-info-list-minl-shape' => 'transform: rotate({{SIZE}}{{UNIT}});',],
					'condition' => ['customize' => 'yes']
				]);

			$this->add_control( 'items', [
				'type'    => KFCM::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'title' => esc_html__('Item #1', 'onnat-extra'),
						'info'  => esc_html__('Item #1 Description', 'onnat-extra'),
					],
					[
						'title' => esc_html__('Item #2', 'onnat-extra'),
						'info'  => esc_html__('Item #2 Description', 'onnat-extra'),
					],
					[
						'title' => esc_html__('Item #3', 'onnat-extra'),
						'info'  => esc_html__('Item #3 Description', 'onnat-extra'),
					],
					[
						'title' => esc_html__('Item #4', 'onnat-extra'),
						'info'  => esc_html__('Item #4 Description', 'onnat-extra'),
					]
				]
			]);

		$this->end_controls_section();
	}

	public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' )
        ]);
			$this->add_control('type',[
				'label'        => esc_html__( 'Order Type', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'numeric'     => [
						'title' => esc_html__('Numeric', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-icon'
					],
					'lower-roman' => [
						'title' => esc_html__('Lower Roman', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-lower-roman-icon'
					],
					'upper-roman' => [
						'title' => esc_html__('Upper Roman', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-upper-roman-icon'
					],
					'lower-alpha' => [
						'title' => esc_html__('Alphabet', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-lower-alphabet-icon'
					],
					'upper-alpha' => [
						'title' => esc_html__('Alphabet', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-upper-alphabet-icon'
					],
					'lower-greek' => [
						'title' => esc_html__('Greek', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-alpha-icon'
					],
				],
				'default'      => 'numeric',
				'prefix_class' => 'kfw-ele-inflo-list-minl-type-',
				'toggle'       => false,
				'selectors'    => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-wrapper'     => 'counter-reset:'.$this->_counter(),
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:before' => 'counter-increment:'.$this->_counter().';content:counter('.$this->_counter().', {{type}})',
				]
			]);
			$this->add_control('start',[
				'label'     => esc_html__( 'Starts at', 'onnat-extra' ),
				'type'      => KFCM::NUMBER,
				'default'   => 0,
				'min'       => 0,
				'step'      => 1,
				'max'       => 10000,
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-wrapper' => 'counter-reset:'.$this->_counter().' {{start}} !important',
				]

			]);
			$this->add_control('order',[
				'label'        => esc_html__( 'Order', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'ascending'  => [
						'title' => esc_html__( 'Ascending Order', 'onnat-extra' ),
						'icon'  => 'eicon-arrow-up',
					],
					'descending' => [
						'title' => esc_html__( 'Descending Order', 'onnat-extra' ),
						'icon'  => 'eicon-arrow-down',
					],
				],
				'prefix_class' => 'kfw-ele-inflo-list-minl-order-',
				'default'      => 'ascending',
				'selectors_dictionary' => [
					'ascending'  => '',
					'descending' => 'counter-increment:'.$this->_counter() . ' -1',
				],
				'toggle'       => false,
				'selectors'            => [
					'{{WRAPPER}}.kfw-ele-inflo-list-minl-order-descending .kfw-ele-widget-info-list-minl-item:before' => '{{VALUE}};',
				]
			]);
			$this->add_control('indicator',[
				'label'                => esc_html__( 'Show Indicator', 'onnat-extra' ),
				'type'                 => KFCM::SWITCHER,
				'default'              => 'yes',
				'selectors_dictionary' => [
					'' => 'border:0'
				],
				'selectors'            => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:after' => '{{VALUE}};',
				]
			]);
			$this->add_control('position',[
				'label'        => esc_html__( 'Position', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'left'  => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'kfw-ele-inflo-list-minl-position-',
				'default'      => 'left',
				'toggle'       => false,
			]);

		$this->end_controls_section();
	}

	public function _register_shape_style_section() {
		$this->start_controls_section( 'section_shape_style',[
			'label' => esc_html__( 'Order Type Style', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_control( 'shape_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:before' => 'color:{{VALUE}};',
				],
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'     => 'shape_bg',
				'types'    => ['classic', 'gradient'],
				'exclude'  => [ 'image'],
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-shape',
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'     => 'shape_border',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-shape'
			]);
			$this->add_responsive_control( 'shape_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-shape' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'     => 'shape_box_shadow',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-shape'
			]);
			$this->add_responsive_control( 'shape_size', [
				'label'      => esc_html__('Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 30,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:before, {{WRAPPER}} .kfw-ele-widget-info-list-minl-shape' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item' => 'padding-left: calc( {{SIZE}}px + 20px);'
				],
			]);
			$this->add_control('shape_rotate',[
				'label'     => esc_html__( 'Rotate', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'default'   => [
					'size' => 0,
					'unit' => 'deg',
				],
				'range'     => [
					'deg' => [
						'max' => 360,
						'min' => - 360,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:before'   => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]);
			$this->add_control('shape_background_rotate',[
				'label'     => esc_html__( 'Background Rotate', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'default'   => [
					'size' => 0,
					'unit' => 'deg',
				],
				'range'     => [
					'deg' => [
						'max' => 360,
						'min' => - 360,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-shape'   => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]);
		$this->end_controls_section();
	}

	public function _register_indicator_style_section() {
		$this->start_controls_section( 'section_indicator_style',[
			'label'     => esc_html__( 'Indicator', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [ 'indicator' => 'yes' ]
		]);
			$this->add_control( 'indicator_style', [
				'label'     => esc_html__( 'Style', 'onnat-extra' ),
				'type'      => KFCM::SELECT,
				'options'   => [
					''       => esc_html__( 'Default', 'onnat-extra' ),
					'none'   => esc_html__( 'None', 'onnat-extra' ),
					'solid'  => esc_html__( 'Solid', 'onnat-extra' ),
					'double' => esc_html__( 'Double', 'onnat-extra' ),
					'dotted' => esc_html__( 'Dotted', 'onnat-extra' ),
					'dashed' => esc_html__( 'Dashed', 'onnat-extra' ),
					'groove' => esc_html__( 'Groove', 'onnat-extra' ),
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:after' => 'border-left-style:{{VALUE}};'
				]
			]);
			$this->add_responsive_control( 'indicator_width', [
				'label'      => esc_html__( 'Width', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [ 'px' => [ 'min' => 1, 'max' => 10 ]],
				'condition'  => [
					'indicator_style!' => [ '', 'none' ],
				],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:after' => 'border-left-width:{{SIZE}}{{UNIT}};'
				]
			]);
			$this->add_control( 'indicator_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:after' => 'border-left-color:{{VALUE}};'
				],
				'condition' => [
					'indicator_style!' => [ '', 'none' ],
				],
			]);
			$this->add_responsive_control( 'indicator_position', [
				'label'      => esc_html__( 'Position', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [ 'px' => [ 'min' => 10, 'max' => 250 ]],
				'condition'  => [
					'indicator_style!' => [ '', 'none' ],
				],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-item:after' => 'left:{{SIZE}}{{UNIT}}; width:{{SIZE}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
	}

	public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
        ]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'onnat-extra' ),
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-title'
			]);
			$this->add_control( 'title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-title' => 'color:{{VALUE}};'
				]
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-title'
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'title_text_stroke',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-title'
			]);
			$this->add_responsive_control( 'title_padding',[
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'title_margin',[
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
	}

	public function _register_info_style_section() {
		$this->start_controls_section( 'section_info_style', [
			'label' => esc_html__( 'Info', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
        ]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'     => 'info_typo',
				'label'    => esc_html__( 'Typography', 'onnat-extra' ),
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-info'
			]);
			$this->add_control( 'info_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-info' => 'color:{{VALUE}};'
				]
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'info_text_shadow',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-info'
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'info_text_stroke',
				'selector' => '{{WRAPPER}} .kfw-ele-widget-info-list-minl-info'
			]);
			$this->add_responsive_control( 'info_padding',[
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'info_margin',[
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-info-list-minl-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
	}

	public function _counter() {
		return 'list-counter-'. $this->get_id();
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-info-list-minimal");
		include $render;
    }
}