<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;
use \Elementor\Group_Control_Image_Size as KFGCIS;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;

class KFW_Testimonial_Large_Carousel extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-testimonial-large-carousel';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Testimonial Large Carousel', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_theme_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-testimonial-carousel kfw-testimonial-largecarousel';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'testimonial', 'review', 'carousel' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/testimonial-large-carousel';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'kfw-testimonial-large-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/js/testimonial-large-carousel' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-testimonial-large-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/css/testimonial-large-carousel' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'swiper', 'kfw-testimonial-large-carousel' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'kfw-testimonial-large-carousel' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_settings_section();

        $this->_register_quote_top_default_icon_style_section();
		$this->_register_quote_top_icon_style_section();
		$this->_register_quote_top_image_style_section();

        #$this->_register_quote_default_icon_style_section();
		#$this->_register_quote_icon_style_section();
		#$this->_register_quote_image_style_section();

		$this->_register_avatar_style_section();
		$this->_register_name_style_section();
		$this->_register_role_style_section();
		$this->_register_content_style_section();
		$this->_register_rating_style_section();

		$this->_register_nav_style_section();
		$this->_register_dot_style_section();
	}

    public function _register_items_section() {
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Testimonial Items', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_control( 'items', [
                'type'        => KFCM::REPEATER,
                'fields'      => [
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name', 'onnat-extra' ),
                        'label_block' => true,
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Name' , 'onnat-extra' ),
                    ],
                    [
                        'name'        => 'role',
                        'label'       => esc_html__( 'Role', 'onnat-extra' ),
                        'label_block' => true,
                        'type'        => KFCM::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Role' , 'onnat-extra' ),
                    ],
                    [
						'name'       => 'rating',
						'label'      => esc_html__( 'Rating', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'dynamic'    => [ 'active' => true ],
						'size_units' => [ 'px' ],
						'default'    => [
                            'unit' => 'px',
                            'size' => 4,
                        ],
						'range'      => [
							'px' => [
                                'min'  => 0,
                                'max'  => 5,
                                'step' => .5,
							],
						],
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}} .kfw-testimonial-lg-rating-inner' =>'width:calc(20 * {{SIZE}}%)',

                        ],
                    ],
                    [
                        'name'        => 'avatar',
                        'label'       => esc_html__( 'Avatar', 'onnat-extra' ),
                        'type'        => KFCM::MEDIA,
                        'media_types' => [ 'image' ],
                        'default'     => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar-large.jpg'
                        ],
                        'dynamic' => [ 'active' => true ],
                    ],
                    [
                        'name'    => 'content',
                        'label'   => esc_html__( 'Content', 'onnat-extra' ),
                        'type'    => KFCM::TEXTAREA,
                        'dynamic' => [ 'active' => true ],
                        'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                ],
                'title_field' => '{{{ name }}}',
                'default'     => [
                    [
                        'name'    => 'Robert',
                        'role'    => 'Manager',
                        'rating'  => '4',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar-large.jpg'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'James',
                        'role'    => 'Administrator',
                        'rating'  => '4.5',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar-large.jpg'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'Christopher',
                        'role'    => 'CEO',
                        'rating'  => '4',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar-large.jpg'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ],
                    [
                        'name'    => 'Michael',
                        'role'    => 'Engineer',
                        'rating'  => '5',
                        'avatar'  => [
                            'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar-large.jpg'
                        ],
                        'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ]
                ],
            ]);
            $this->add_control('hr_items', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_group_control( KFGCIS::get_type(), [
                'name'    => 'image_size',
                'default' => 'full',
            ]);
            $this->add_control('quote_icon_type',[
                'label'   => esc_html__( 'Quote Icon Type', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'options' => [
                    'blank' => [
                        'title' => esc_html__('Blank', 'onnat-extra'),
                        'icon'  => '',
                    ],
                    'default' => [
                        'title' => esc_html__('Default', 'onnat-extra'),
                        'icon'  => 'eicon-blockquote',
                    ],
                    'icon'  => [
                        'title' => esc_html__('Icon', 'onnat-extra'),
                        'icon'  => 'eicon-plus-circle-o',
                    ],
                    'image' => [
                        'title' => esc_html__('Image', 'onnat-extra'),
                        'icon'  => 'eicon-image',
                    ],
                ],
                'default' => 'default',
                'toggle'  => false,
            ]);
            $this->add_control( 'quote_icon_top_icon', [
                #'label'       => esc_html__( 'Top Quote Icon', 'onnat-extra' ),
                'label'       => esc_html__( 'Quote Icon', 'onnat-extra' ),
                'label_block' => false,
                'type'        => KFCM::ICONS,
                'skin'        => 'inline',
                'default'   => [
					'value'   => 'fas fa-quote-left',
					'library' => 'fa-solid',
				],
                'condition'   => [
                    'quote_icon_type' => 'icon'
                ],
            ]);
            $this->add_control( 'quote_icon_top_image', [
                'label'     => esc_html__( 'Quote Image', 'onnat-extra' ),
                'type'      => KFCM::MEDIA,
                'dynamic'   => [ 'active' => true ],
                'condition' => [
                    'quote_icon_type' => 'image'
                ],
            ]);
            $this->add_control( 'quote_badge_image', [
                'label'   => esc_html__( 'Badge Image', 'onnat-extra' ),
                'type'    => KFCM::MEDIA,
                'dynamic' => [ 'active' => true ],
            ]);
            $this->add_control('hr_item_settings', [
                'type' => KFCM::DIVIDER,
            ]);
			$this->add_control('item_heading',[
				'label' => esc_html__( 'ITEM SETTINGS', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
			]);
			$this->add_control('use_rating',[
                'label'        => esc_html__( 'Show Rating?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
			]);
			$this->add_control('use_role',[
                'label'        => esc_html__( 'Show Role?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
			]);
		$this->end_controls_section();
    }

    public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            /*$this->add_responsive_control('cols', [
                'label'   => esc_html__( 'Columns', 'onnat-extra' ),
                'type'    => KFCM::CHOOSE,
                'toggle'  => false,
                'options' => [
                    '1' => [
                        'title' => esc_html__('1 Column', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-icon'
                    ],
                    '2' => [
                        'title' => esc_html__('2 Columns', 'onnat-extra'),
                        'icon'  => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon'
                    ],
                ],
            ]);*/
			$this->add_responsive_control('slide_to_scroll',[
				'label'   => esc_html__( 'Slides To Scroll', 'onnat-extra' ),
				'type'    => KFCM::NUMBER,
				'min'     => 1,
				'max'     => 20,
				'step'    => 1,
				'default' => 1,
			]);
			$this->add_control( 'loop', [
				'label'        => esc_html__( 'Enable Loop?', 'onnat-extra' ),
				'type'         => KFCM::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
            ]);
			$this->add_control( 'hr_1', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_control('autoplay_settings_heading',[
                'label' => esc_html__( 'Autoplay Settings', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control('autoplay', [
                'label'        => esc_html__( 'Enable Autoplay?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
            ]);
            $this->add_control('autoplay_speed',[
                'label'      => esc_html__('Autoplay Speed (ms)', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [],
                'range'      => [
                    'min'  => 1000,
                    'max'  => 15000,
                    'step' => 100
                ],
                'default'    => [
                    'unit' => '',
                    'size' => 1000
                ],
                'condition'  => [
                    'autoplay' => 'yes'
                ],
            ]);
            $this->add_control( 'pause', [
                'label'        => esc_html__( 'Pause on Hover?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'autoplay' => 'yes'
                ],
            ]);
			$this->add_control( 'hr_2', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_control( 'nav_settings_heading',[
                'label' => esc_html__( 'Navigation Settings', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_control( 'arrows', [
                'label'        => esc_html__( 'Enable Arrows?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
            ]);
            $this->add_control( 'mobile_arrows', [
                'label'        => esc_html__( 'Remove Arrows on Mobile?', 'onnat-extra' ),
                'type'         => KFCM::SWITCHER,
                'return_value' => 'yes',
                'condition'    => [
                    'arrows' => 'yes'
                ],
            ]);
            $this->add_control( 'arrow_position', [
                'label'     => esc_html__( 'Position', 'onnat-extra' ),
                'type'      => KFCM::CHOOSE,
                'options'   => [
                    'default'       => [
                        'title' => esc_html__( 'Default', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left'
                    ],
                    'top-left'      => [
                        'title' => esc_html__( 'Top Left', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-45'
                    ],
                    'top-center'    => [
                        'title' => esc_html__( 'Top Center', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-90'
                    ],
                    'top-right'     => [
                        'title' => esc_html__( 'Top Right', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-135'
                    ],
                    'bottom-left'   => [
                        'title' => esc_html__( 'Bottom Left', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-315'
                    ],
                    'bottom-center' => [
                        'title' => esc_html__( 'Bottom Center', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-90'
                    ],
                    'bottom-right'  => [
                        'title' => esc_html__( 'Bottom Right', 'onnat-extra' ),
                        'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-45'
                    ],
                    'custom'        => [
                        'title' => esc_html__( 'Custom', 'onnat-extra' ),
                        'icon'  => 'eicon-map-pin'
                    ],
                ],
                'default'   => 'bottom-center',
                'condition' => [
                    'arrows' => 'yes'
                ],
                'toggle'    => false
            ]);
            $this->add_control( 'custom_nav_d_color', [
                'label'     => esc_html__( 'Nav Disabled Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => [
                    'arrows'         => 'yes',
                    'arrow_position' => 'custom'
                ],
                'selectors' => [
                    '.kfw-js-swiper-{{ID}}-nav-next, .kfw-js-swiper-{{ID}}-nav-prev'                                                   => 'cursor:pointer !important;',
                    '.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled'     => 'cursor: text !important;',
                    '.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled *, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled *' => 'color:{{VALUE}}; opacity:0.5;',
                ]
            ]);
            $this->add_control( 'left_arrow', [
                'label'     => esc_html__( 'Next Arrow', 'onnat-extra' ),
                'type'      => KFCM::ICONS,
                'default'   => [
                    'value'   => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'arrows'          => 'yes',
                    'arrow_position!' => 'custom',
                ],
            ]);
            $this->add_control( 'right_arrow', [
                'label'     => esc_html__( 'Prev Arrow', 'onnat-extra' ),
                'type'      => KFCM::ICONS,
                'default'   => [
                    'value'   => 'fas fa-arrow-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'arrows'          => 'yes',
                    'arrow_position!' => 'custom',
                ],
            ]);
			$this->add_control( 'hr_3', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'dots', [
				'label'        => esc_html__( 'Show Dots?', 'onnat-extra' ),
				'type'         => KFCM::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			]);
		$this->end_controls_section();
    }

	public function _register_nav_style_section() {
		$this->start_controls_section( 'section_nav_style',[
			'label'     => esc_html__( 'Navigation', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'arrows'          => 'yes',
				'arrow_position!' => 'custom'
			],
		]);
			$this->start_controls_tabs( 'tabs_nav_style', [
				'condition' => [
					'arrows'          => 'yes',
					'arrow_position!' => 'custom'
				],
			]);
				$this->start_controls_tab( 'tabs_nav_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'hr_nav_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'     => 'nav_border',
						'selector' => '{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap div'
					]);
					$this->add_control( 'hr_nav_style_3', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						]
					]);
					$this->add_control( 'hr_nav_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_arrow_size',[
						'label'      => esc_html__('Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 10,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap div' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',

							'{{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-top-left,
                            {{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-top-center,
                            {{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-top-right'          => 'top:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',

							'{{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-bottom-left,
                            {{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-bottom-center,
                            {{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap.kfw-testimonial-lg-carousel-nav-pos-bottom-right' => 'bottom:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',
						],
					]);
					$this->add_responsive_control( 'nav_arrow_icon_size', [
						'label'      => esc_html__('Icon Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 0,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-testimonial-lg-carousel-nav-wrap .kfw-elementor-icon-wrap' => 'font-size: {{SIZE}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_nav_style_5', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap div'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_h_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap div:hover' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_h_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap div:hover'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_disabled', [
					'label' => esc_html__( 'Disabled', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_d_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap .swiper-button-disabled' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_d_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-testimonial-large-carousel-nav-wrap .swiper-button-disabled'
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_dot_style_section() {
		$this->start_controls_section( 'section_dot_style',[
			'label'     => esc_html__( 'Dot', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'dots' => 'yes'
			],
		]);
			$this->start_controls_tabs( 'tabs_dot_style', [
				'condition' => [
					'dots' => 'yes'
				],
			]);
				$this->start_controls_tab( 'tabs_dot_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'dot_color_settings', [
						'label'        => esc_html__('Colors', 'onnat-extra'),
						'type'         => KFCM::POPOVER_TOGGLE,
						'return_value' => 'yes',
					]);
					$this->start_popover();
						$this->add_control( 'dot_color', [
							'label'     => esc_html__('Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'background:{{VALUE}};',
							],
						]);
						$this->add_control( 'active_dot_color', [
							'label'     => esc_html__('Active Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active, {{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active:hover' => 'background:{{VALUE}};',
							],
						]);
					$this->end_popover();
					$this->add_control( 'hr_dot_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'dot_padding',[
						'label'      => esc_html__('Padding', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_responsive_control( 'dot_margin',[
						'label'      => esc_html__('Margin', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_dot_style_2', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_control( 'dot_size_settings_heading',[
						'label' => esc_html__( 'Size Settings', 'onnat-extra' ),
						'type'  => KFCM::HEADING,
					]);
						$this->add_responsive_control( 'dot_width',[
							'label'      => esc_html__('Width', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'width:{{SIZE}}{{UNIT}};',
							],
						]);
						$this->add_responsive_control( 'dot_height',[
							'label'      => esc_html__('Height', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'height:{{SIZE}}{{UNIT}};',
							],
						]);
						$this->add_responsive_control( 'dot_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'default'    => [
								'top'      => '',
								'right'    => '',
								'bottom'   => '',
								'left'     => '',
								'unit'     => 'px',
								'isLinked' => false
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
							]
						]);
						$this->add_control( 'hr_dot_style_3', [
							'type' => KFCM::DIVIDER,
						]);
						$this->add_responsive_control( 'dot_space_between',[
							'label'      => esc_html__('Space Between', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'selectors'  => [
								'{{WRAPPER}}' => '--kfw-swiper-dots-space-between: {{SIZE}}{{UNIT}};',
							],
						]);
					$this->add_control( 'hr_dot_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_dot_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'h_dot_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet:hover' => 'background:{{VALUE}};',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_h_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet:hover'
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

    public function _register_quote_top_default_icon_style_section() {
        $condition = [
            'quote_icon_type' => 'default'
        ];
        $this->start_controls_section( 'section_top_quote_default_icon_style', [
            'label'     => esc_html__( 'Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
        ]);
            $this->add_control( 'top_quote_d_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap span' => 'color:{{VALUE}};' ],
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap span' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_d_bg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_d_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_d_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_d_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
        $this->end_controls_section();        
    }

    public function _register_quote_top_icon_style_section() {
        $condition = [
            'quote_icon_type'         => 'icon',
            'quote_icon_top_icon[value]!' => '',
        ];
        $this->start_controls_section( 'section_top_quote_icon_style', [
            'label'     => esc_html__( 'Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
        ]);
            $this->add_control( 'top_quote_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap .kfw-elementor-icon-wrap'     => 'color: {{VALUE}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap i'   => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_iconbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_icon_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_icon_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_icon_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_icon_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'top_quote_icon_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
        $this->end_controls_section();
    }

    public function _register_quote_top_image_style_section() {
        $condition = [
            'quote_icon_type'            => 'image',
            'quote_icon_top_image[url]!' => ''
        ];

        $this->start_controls_section( 'section_top_quote_img_style', [
            'label'     => esc_html__( 'Quote Image', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
        ]);
            $this->add_responsive_control( 'top_quote_img_size', [
                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap img'   => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_img_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_imgbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_img_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_img_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_img_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_img_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'top_quote_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
        $this->end_controls_section();        
    }

    public function _register_quote_default_icon_style_section() {
        $condition = [
            'quote_icon_type' => 'default'
        ];
        $this->start_controls_section( 'section_top_quote_default_icon_style', [
            'label'     => esc_html__( 'Top Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_control( 'top_quote_d_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap span' => 'color:{{VALUE}};' ],
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap span' => 'font-size: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control( 'top_quote_d_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_d_bg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_d_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_d_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_d_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
			$this->add_responsive_control( 'top_quote_d_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'top_quote_d_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();

        $this->start_controls_section( 'section_bottom_quote_default_icon_style', [
            'label'     => esc_html__( 'Bottom Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_control( 'bottom_quote_d_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap span' => 'color: {{VALUE}};' ],
            ]);
            $this->add_responsive_control( 'bottom_quote_d_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap span' => 'font-size:{{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control( 'bottom_quote_d_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'bottom_quote_d_bg',
                'types'     => ['classic', 'gradient'],
                'exclude'   => [ 'image'],
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'bottom_quote_d_border',
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'bottom_quote_d_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'bottom_quote_d_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
			$this->add_responsive_control( 'bottom_quote_d_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'bottom_quote_d_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-default-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
    }

    public function _register_quote_icon_style_section() {
        $condition = [
            'quote_icon_type'         => 'icon',
            'quote_icon_top_icon[value]!' => '',
        ];
        $this->start_controls_section( 'section_top_quote_icon_style', [
            'label'     => esc_html__( 'Top Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_control( 'top_quote_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap .kfw-elementor-icon-wrap'     => 'color: {{VALUE}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap i'   => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_iconbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_icon_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_icon_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_icon_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
			$this->add_responsive_control( 'top_quote_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'top_quote_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();

        $bottom_condition = [
            'quote_icon_type'         => 'icon',
            'quote_icon_bottom_icon[value]!' => '',
        ];
        $this->start_controls_section( 'section_bottom_quote_icon_style', [
            'label'     => esc_html__( 'Bottom Quote Icon', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $bottom_condition
		]);
            $this->add_control( 'bottom_quote_icon_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $bottom_condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap .kfw-elementor-icon-wrap'     => 'color: {{VALUE}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap .kfw-elementor-icon-wrap svg' => 'fill: {{VALUE}};',
                ],
            ]);
            $this->add_responsive_control( 'bottom_quote_icon_size', [
                'label'      => esc_html__('Icon Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap i'   => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control( 'bottom_quote_icon_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'bottom_quote_iconbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $bottom_condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'bottom_quote_icon_border',
                'condition' => $bottom_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'bottom_quote_icon_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $bottom_condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'bottom_quote_icon_box_shadow',
                'condition' => $bottom_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
			$this->add_responsive_control( 'bottom_quote_icon_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $bottom_condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'bottom_quote_icon_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $bottom_condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-quote-icon-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
		$this->end_controls_section();
    }

    public function _register_quote_image_style_section() {
        $condition = [
			'quote_icon_type'            => 'image',
			'quote_icon_top_image[url]!' => ''
		];

        $this->start_controls_section( 'section_top_quote_img_style', [
            'label'     => esc_html__( 'Top Quote Image', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $condition
		]);
            $this->add_responsive_control( 'top_quote_img_size', [
                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap img'   => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control( 'top_quote_img_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'top_quote_imgbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'top_quote_img_border',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_img_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'top_quote_img_box_shadow',
                'condition' => $condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'top_quote_img_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'top_quote_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();

        $bottom_condition = [
			'quote_icon_type'               => 'image',
			'quote_icon_bottom_image[url]!' => ''
		];

        $this->start_controls_section( 'section_bottom_quote_img_style', [
            'label'     => esc_html__( 'Bottom Quote Image', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $bottom_condition
		]);
            $this->add_responsive_control( 'bottom_quote_img_size', [
                'label'      => esc_html__('Image Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap img' => 'max-width: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->add_responsive_control( 'bottom_quote_img_bg_size',[
                'label'      => esc_html__('Background Size', 'onnat-extra' ),
                'type'       => KFCM::SLIDER,
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'bottom_quote_imgbg',
                'types'     => ['classic', 'gradient'],
                'condition' => $bottom_condition,
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'bottom_quote_img_border',
                'condition' => $bottom_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'bottom_quote_img_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'condition'  => $bottom_condition,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'bottom_quote_img_box_shadow',
                'condition' => $bottom_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-btm-quote-icon-wrap'
            ]);
            $this->add_responsive_control( 'bottom_quote_img_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'bottom_quote_img_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $bottom_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-quote-image-type.kfw-testimonial-lg-top-quote-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

	public function _register_avatar_style_section() {
		$this->start_controls_section( 'section_avatar_style', [
            'label'     => esc_html__( 'Avatar', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
		]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'      => 'avatar_bg',
                'types'     => ['classic', 'gradient'],
                'exclude'   => [ 'image'],
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-img-wrap',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'      => 'avatar_border',
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-img-wrap'
            ]);
            $this->add_responsive_control( 'avatar_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-img-wrap'     => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .kfw-testimonial-lg-img-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'      => 'avatar_box_shadow',
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-img-wrap'
            ]);
            $this->add_responsive_control( 'avatar_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-img-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'avatar_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-img-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
    }

    public function _register_name_style_section() {
		$this->start_controls_section( 'section_name_style', [
			'label' => esc_html__( 'Name', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'name_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-name',
            ]);
            $this->add_responsive_control( 'name_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'name_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'name_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-name' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'name_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-name',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'name_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-name',
            ]);
		$this->end_controls_section();
    }

    public function _register_role_style_section() {
        $role_condition = [
            'use_role!' => ''
        ];

		$this->start_controls_section( 'section_role_style', [
            'label'     => esc_html__( 'Role', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $role_condition,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'      => 'role_typo',
                'label'     => esc_html__( 'Typography', 'onnat-extra' ),
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-role',
                'condition' => $role_condition,
            ]);
            $this->add_responsive_control( 'role_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $role_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-role' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'role_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'condition'  => $role_condition,
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-role' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'role_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $role_condition,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-role' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'      => 'role_txt_shadow',
                'condition' => $role_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-role',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'      => 'role_txt_stroke',
                'condition' => $role_condition,
                'selector'  => '{{WRAPPER}} .kfw-testimonial-lg-role',
            ]);
		$this->end_controls_section();
    }

    public function _register_content_style_section() {
		$this->start_controls_section( 'section_content_style', [
			'label' => esc_html__( 'Content', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'content_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-comment',
            ]);
            $this->add_responsive_control( 'content_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'content_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_control( 'content_color', [
                'label'     => esc_html__('Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'selectors' => ['{{WRAPPER}} .kfw-testimonial-lg-comment' => 'color: {{VALUE}};' ],
            ]);
            $this->add_group_control( KFGCTS::get_type(), [
                'name'     => 'content_txt_shadow',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-comment',
            ]);
            $this->add_group_control( KFGCTST::get_type(), [
                'name'     => 'content_txt_stroke',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-comment',
            ]);

            $this->add_control('hr_content_wrap_settings', [
                'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('heading_content_wrap_settings',[
                'label' => esc_html__( 'CONTENT WRAP', 'onnat-extra' ),
                'type'  => KFCM::HEADING,
            ]);
            $this->add_group_control( KFGCBG::get_type(), [
                'name'     => 'content_wrap_bg',
                'types'    => ['classic', 'gradient'],
                'exclude'  => [ 'image'],
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-body',
            ]);
            $this->add_group_control( KFGCBR::get_type(), [
                'name'     => 'content_wrap_border',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-body'
            ]);
            $this->add_responsive_control( 'content_wrap_border_radius', [
                'label'      => esc_html__('Border Radius', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-testimonial-lg-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]);
            $this->add_group_control( KFGCBS::get_type(), [
                'name'     => 'content_wrap_box_shadow',
                'selector' => '{{WRAPPER}} .kfw-testimonial-lg-body'
            ]);
		$this->end_controls_section();
    }

    public function _register_rating_style_section() {
        $rating_condition = [
            'use_rating!' => ''
        ];

		$this->start_controls_section( 'section_rating_style', [
            'label'     => esc_html__( 'Rating', 'onnat-extra' ),
            'tab'       => KFCM::TAB_STYLE,
            'condition' => $rating_condition,
		]);
			$this->add_responsive_control( 'rating_margin', [
                'label'              => esc_html__('Margin', 'onnat-extra' ),
                'type'               => KFCM::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
				'allowed_dimensions' => [
                    'top',
                    'right',
                    'bottom',
                ],
				'placeholder'        => [
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => 'auto',
                ],
				'condition'          => $rating_condition,
				'selectors'          => [
					'{{WRAPPER}} .kfw-testimonial-lg-rating' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}}; margin-right: {{RIGHT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'rating_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $rating_condition,
				'selectors'  => [
					'{{WRAPPER}} .kfw-testimonial-lg-rating' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
            $this->add_control( 'rating_active_color', [
                'label'     => esc_html__('Active Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $rating_condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-lg-rating span:before' => 'color:{{VALUE}};',
                ],
            ]);
            $this->add_control( 'rating_deactive_color', [
                'label'     => esc_html__('Inactive Color', 'onnat-extra' ),
                'type'      => KFCM::COLOR,
                'condition' => $rating_condition,
                'selectors' => [
                    '{{WRAPPER}} .kfw-testimonial-lg-rating:before' => 'color:{{VALUE}};',
                ],
            ]);
		$this->end_controls_section();
    }

	/**
	 * Generate setting json
	 */
	protected function _generate_setting_json( array $settings ) {

		$cols = [
			'widescreen'   => 2,
			'desktop'      => 1,
			'laptop'       => 1,
			'tablet'       => 1,
			'tablet_extra' => 1,
			'mobile'       => 1,
			'mobile_extra' => 1,
		];

		$options = [
			'autoHeight'     => true,
			'loop'           => $settings['loop'] === 'yes' ? true : false,
			'slidesPerView'  => 1,
			'slidesPerGroup' => 1,
			'spaceBetween'   => 20
		];

		/**
		 * Break Points
		 */
            $breakpoints            = \Elementor\Plugin::$instance->breakpoints->get_breakpoints();
            $options['breakpoints'] = [];

            $options['breakpoints'][1440] = [
                "device"         => 'desktop',
                'slidesPerView'  => ( isset($settings["cols"]) && !empty( $settings["cols"]) ) ? (int)$settings["cols"] : $cols['desktop'],
                'slidesPerGroup' => ( isset($settings["slide_to_scroll"]) && !empty( $settings["slide_to_scroll"] ) ) ? (int)$settings["slide_to_scroll"] : 1,
                'spaceBetween'   => 20,
            ];

            foreach( $breakpoints as $breakpoint ) {
                $device = $breakpoint->get_label();
                $name   = $breakpoint->get_name();
                $value  = $breakpoint->get_value();

                $col_key    = "cols_".$name;
                $scroll_key = "slide_to_scroll_".$name;

                if( isset( $settings[ $col_key ] ) ) {
                    $options['breakpoints'][ $value ] = [
                        "device"         => $device,
                        "slidesPerView"  => ( isset( $settings[ $col_key ] ) && !empty( $settings[ $col_key ] ) ) ? (int) $settings[ $col_key ] : $cols[$name],
                        "slidesPerGroup" => ( isset( $settings[ $scroll_key ] ) && !empty( $settings[ $scroll_key ] ) ) ? (int) $settings[ $scroll_key ] : 1,
                        "spaceBetween"   => 20,
                    ];
                } else {
                    $options['breakpoints'][ $value ] = [
                        "device"         => $device,
                        "slidesPerView"  => $cols[$name],
                        "slidesPerGroup" => 1,
                        "spaceBetween"   => 20,
                    ];
                }
            }

		/**
		 * Other Settings
		 */
            if( $settings['autoplay'] === 'yes' ) {
                $options['pauseOnHover']  = $settings['pause'] === 'yes' ? true : false;
                $options['autoplay']['delay'] = isset( $settings['autoplay_speed']['size'] ) ? $settings['autoplay_speed']['size'] : 1000;
            } else {
                $options['pauseOnHover']  = false;
            }

            if( $settings['arrows'] === 'yes' ) {
                $options['navigation']['nextEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next';
                $options['navigation']['prevEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev';
                $options['arrowPosition']        = $settings['arrow_position'];
                $options['hideArrowsOnMobile']   = $settings['mobile_arrows'] === 'yes' ? true : false;
            }

            if( $settings['dots'] === 'yes' ) {
                $options['pagination']['type']      = 'bullets';
                $options['pagination']['el']        = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination';
                $options['pagination']['clickable'] = true;
            }

		return wp_json_encode( $options );
	}

	public function _message( $message, $echo = true ) {
		$return = sprintf( '
			<div class="elementor-alert elementor-alert-info" role="alert">
				<span class="elementor-alert-description">%s</span>
			</div>',
			$message
		);

		if( $echo ) {
			echo $return;
			return;
		}

		return $return;
	}

	/**
	 * Get attachment image src.
	 */
	public static function _get_image_src( $attachment_id, $image_size_key, array $settings ) {
        return KFGCIS::get_attachment_image_src( $attachment_id, $image_size_key, $settings );
	}

	public static function _get_image_html( $settings ) {
		return KFGCIS::get_attachment_image_html( $settings );
	}

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

        if( !empty( $icon ) ) {
            echo '<span class="kfw-elementor-icon-wrap">';
                KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
            echo '</span>';
		}
	}

    public function _render_img( $settings = [] ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<span class="kfw-elementor-icon-wrap">';
                echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
            echo '</span>';
        }
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-testimonial-large-carousel");
		include $render;
    }
}