<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extend_FontFlow_Onnat_Icons' ) ) {

	/**
	 * Define the Onnat Icons icon library.
     *
	 */
    class KinForce_Extend_FontFlow_Onnat_Icons {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'load'] );
        }

        public function load( $additional_tabs ) {

            $icons = [
                'angle-right',
                'comments-dots-alt',
                'comments-dots',
                'line-arrow-cross-big',
                'line-arrow-cross-default',
                'line-arrow-cross-small',
                'line-arrow-down-thick',
                'line-arrow-down-thin',
                'line-arrow-left-cross-small',
                'line-arrow-left-small',
                'line-arrow-long-down-cross',
                'line-arrow-long-left-small',
                'line-arrow-long-left-tiny',
                'line-arrow-long-right-cross',
                'line-arrow-long-right-small',
                'line-arrow-long-right-tiny',
                'line-arrow-long-right',
                'line-arrow-right-small',
                'mail',
                'map-pin',
                'quote-filled',
                'quote',
                'search',
                'shape-cone',
                'shape-cross',
                'shape-cube',
                'shape-flower',
                'shape-globe-open',
                'shape-globe',
                'shape-hexogan',
                'shape-knot',
                'shape-oval',
                'shape-sphere',
                'shape-square-tilt',
                'shape-square',
                'shape-star',
                'target',
                'cross',
                'humburger',
            ];

            $additional_tabs[ 'fontflow-onnaticons' ] = [
                'name'          => 'fontflow-onnaticons',
                'label'         => esc_html__( 'FontFlow - Onnat Icons', 'onnat-extra' ),
                'labelIcon'     => 'fas fa-chevron-right',
                'ver'           => FCIFE_CONST_VERSION,
                'prefix'        => 'fontflow-onnat-',
                'displayPrefix' => 'fontflow-onnat',
                'url'           => KFE_CONST_URL . 'libraries/fontflow/assets/css/onnaticons/fontflow-onnat.min.css',
                'enqueue'       => [
                    KFE_CONST_URL . 'libraries/fontflow/assets/css/onnaticons/fontflow-onnat.min.css'
                ],
                'icons'         => $icons
            ];

            return $additional_tabs;
        }

    }

}

if( !function_exists( 'kf_extend_fontflow_onnat_icons' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extend_fontflow_onnat_icons() {

        return KinForce_Extend_FontFlow_Onnat_Icons::get_instance();
    }
}

kf_extend_fontflow_onnat_icons();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */