<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extend_FontFlow_Themify_Icons' ) ) {

	/**
	 * Define the Themify Icons icon library.
     *
	 */
    class KinForce_Extend_FontFlow_Themify_Icons {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'load'] );
        }

        public function load( $additional_tabs ) {

            $icons = [
                'agenda',
                'alarm-clock',
                'alert',
                'align-center',
                'align-justify',
                'align-left',
                'align-right',
                'anchor',
                'android',
                'angle-double-down',
                'angle-double-left',
                'angle-double-right',
                'angle-double-up',
                'angle-down',
                'angle-left',
                'angle-right',
                'angle-up',
                'announcement',
                'apple',
                'archive',
                'arrow-circle-down',
                'arrow-circle-left',
                'arrow-circle-right',
                'arrow-circle-up',
                'arrow-down',
                'arrow-left',
                'arrow-right',
                'arrow-top-left',
                'arrow-top-right',
                'arrow-up',
                'arrow',
                'arrows-corner',
                'arrows-horizontal',
                'arrows-vertical',
                'back-left',
                'back-right',
                'bag',
                'bar-chart-alt',
                'bar-chart',
                'basketball',
                'bell',
                'blackboard',
                'bolt-alt',
                'bolt',
                'book',
                'bookmark-alt',
                'bookmark',
                'briefcase',
                'brush-alt',
                'brush',
                'calendar',
                'camera',
                'car',
                'check-box',
                'check',
                'clip',
                'clipboard',
                'close',
                'cloud-down',
                'cloud-up',
                'cloud',
                'comment-alt',
                'comment',
                'comments-smiley',
                'comments',
                'control-backward',
                'control-eject',
                'control-forward',
                'control-pause',
                'control-play',
                'control-record',
                'control-shuffle',
                'control-skip-backward',
                'control-skip-forward',
                'control-stop',
                'credit-card',
                'crown',
                'css3',
                'cup',
                'cut',
                'dashboard',
                'desktop',
                'direction-alt',
                'direction',
                'download',
                'dribbble',
                'dropbox-alt',
                'dropbox',
                'drupal',
                'email',
                'envelope',
                'eraser',
                'exchange-vertical',
                'export',
                'eye',
                'face-sad',
                'face-smile',
                'facebook',
                'file',
                'files',
                'filter',
                'flag-alt-2',
                'flag-alt',
                'flag',
                'flickr-alt',
                'flickr',
                'folder',
                'fullscreen',
                'gallery',
                'game',
                'gift',
                'github',
                'google',
                'hand-drag',
                'hand-open',
                'hand-point-down',
                'hand-point-left',
                'hand-point-right',
                'hand-point-up',
                'hand-stop',
                'harddrive',
                'harddrives',
                'headphone-alt',
                'headphone',
                'heart-broken',
                'heart',
                'help-alt',
                'help',
                'home',
                'html5',
                'hummer',
                'id-badge',
                'image',
                'import',
                'infinite',
                'info-alt',
                'info',
                'ink-pen',
                'instagram',
                'Italic',
                'joomla',
                'jsfiddle',
                'key',
                'layers-alt',
                'layers',
                'layout-accordion-list',
                'layout-accordion-merged',
                'layout-accordion-separated',
                'layout-column2-alt',
                'layout-column2',
                'layout-column3-alt',
                'layout-column3',
                'layout-column4-alt',
                'layout-column4',
                'layout-cta-btn-left',
                'layout-cta-btn-right',
                'layout-cta-center',
                'layout-cta-left',
                'layout-cta-right',
                'layout-grid2-alt',
                'layout-grid2-thumb',
                'layout-grid2',
                'layout-grid3-alt',
                'layout-grid3',
                'layout-grid4-alt',
                'layout-grid4',
                'layout-line-solid',
                'layout-list-large-image',
                'layout-list-post',
                'layout-list-thumb-alt',
                'layout-list-thumb',
                'layout-media-center-alt',
                'layout-media-center',
                'layout-media-left-alt',
                'layout-media-left',
                'layout-media-overlay-alt-2',
                'layout-media-overlay-alt',
                'layout-media-overlay',
                'layout-media-right-alt',
                'layout-media-right',
                'layout-menu-full',
                'layout-menu-separated',
                'layout-menu-v',
                'layout-menu',
                'layout-placeholder',
                'layout-sidebar-2',
                'layout-sidebar-left',
                'layout-sidebar-none',
                'layout-sidebar-right',
                'layout-slider-alt',
                'layout-slider',
                'layout-tab-min',
                'layout-tab-v',
                'layout-tab-window',
                'layout-tab',
                'layout-width-default-alt',
                'layout-width-default',
                'layout-width-full',
                'layout',
                'light-bulb',
                'line-dashed',
                'line-dotted',
                'line-double',
                'link',
                'linkedin',
                'linux',
                'list-ol',
                'list',
                'location-arrow',
                'location-pin',
                'lock',
                'loop',
                'magnet',
                'map-alt',
                'map',
                'marker-alt',
                'marker',
                'medall-alt',
                'medall',
                'menu-alt',
                'menu',
                'microphone-alt',
                'microphone',
                'microsoft-alt',
                'microsoft',
                'minus',
                'mobile',
                'money',
                'more-alt',
                'more',
                'mouse-alt',
                'mouse',
                'music-alt',
                'music',
                'na',
                'new-window',
                'notepad',
                'package',
                'paint-bucket',
                'paint-roller',
                'palette',
                'panel',
                'paragraph',
                'pencil-alt',
                'pencil-alt2',
                'pencil',
                'pie-chart',
                'pin-alt',
                'pin',
                'pin2',
                'pinterest-alt',
                'pinterest',
                'plug',
                'plus',
                'power-off',
                'printer',
                'pulse',
                'quote-left',
                'quote-right',
                'receipt',
                'reddit',
                'reload',
                'rocket',
                'rss-alt',
                'rss',
                'ruler-alt-2',
                'ruler-alt',
                'ruler-pencil',
                'ruler',
                'save-alt',
                'save',
                'search',
                'server',
                'settings',
                'share-alt',
                'share',
                'sharethis-alt',
                'sharethis',
                'shield',
                'shift-left-alt',
                'shift-left',
                'shift-right-alt',
                'shift-right',
                'shine',
                'shopping-cart-full',
                'shopping-cart',
                'shortcode',
                'signal',
                'skype',
                'slice',
                'smallcap',
                'soundcloud',
                'split-h',
                'split-v-alt',
                'split-v',
                'spray',
                'stack-overflow',
                'stamp',
                'star',
                'stats-down',
                'stats-up',
                'support',
                'tablet',
                'tag',
                'target',
                'text',
                'themify-favicon-alt',
                'themify-favicon',
                'themify-logo',
                'thought',
                'thumb-down',
                'thumb-up',
                'ticket',
                'time',
                'timer',
                'trash',
                'trello',
                'truck',
                'tumblr-alt',
                'tumblr',
                'twitter-alt',
                'twitter',
                'underline',
                'unlink',
                'unlock',
                'upload',
                'uppercase',
                'user',
                'vector',
                'video-camera',
                'video-clapper',
                'view-grid',
                'view-list-alt',
                'view-list',
                'vimeo-alt',
                'vimeo',
                'volume',
                'wallet',
                'wand',
                'wheelchair',
                'widget-alt',
                'widget',
                'widgetized',
                'window',
                'wordpress',
                'world',
                'write',
                'yahoo',
                'youtube',
                'zip',
                'zoom-in',
                'zoom-out',
            ];

            $additional_tabs[ 'fontflow-themifyicons' ] = [
                'name'          => 'fontflow-themifyicons',
                'label'         => esc_html__( 'FontFlow - ThemifyIcons', 'onnat-extra' ),
                'labelIcon'     => 'fas fa-chevron-right',
                'ver'           => FCIFE_CONST_VERSION,
                'prefix'        => 'fontflow-themifyicons-',
                'displayPrefix' => 'fontflow-themifyicons',
                'url'           => KFE_CONST_URL . 'libraries/fontflow/assets/css/themifyicons/fontflow-themifyicons.min.css',
                'enqueue'       => [ KFE_CONST_URL . 'libraries/fontflow/assets/css/themifyicons/fontflow-themifyicons.min.css' ],
                'icons'         => $icons
            ];

            return $additional_tabs;
        }

    }

}

if( !function_exists( 'kf_extend_fontflow_themify_icons' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extend_fontflow_themify_icons() {

        return KinForce_Extend_FontFlow_Themify_Icons::get_instance();
    }
}

kf_extend_fontflow_themify_icons();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */