<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Mega_Menu_Nav_Menu_Walker' ) ) {

	/**
	 * The _theme_name Theme Elementor Mega Menu integrated Navigation Menu Walker class.
     *
	 */
    class KinForce_Extra_Plugin_Mega_Menu_Nav_Menu_Walker extends Walker_Nav_Menu {

        /**
         * Starts the element output.
         */
        public function start_el( &$output, $data_object, $depth = 0, $args = null, $current_object_id = 0 ) {

            // Restores the more descriptive, specific name for use within this method.
            $menu_item = $data_object;

            if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
                $t = '';
                $n = '';
            } else {
                $t = "\t";
                $n = "\n";
            }
            $indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

            $classes   = empty( $menu_item->classes ) ? array() : (array) $menu_item->classes;
            $classes[] = 'menu-item-' . $menu_item->ID;

            /**
             * Mega Menu
             */
                $menu_item_meta          = [];
                $menu_item_meta_settings = [];
                $mega_menu_output        = '';

                if( 0 === $depth ) {
                    $meta                    = get_post_meta( $menu_item->ID, ONNAT_CONST_THEME_NAV_MENU_PREFIX, true );
                    $menu_item_meta          = is_array( $meta ) ? array_filter( $meta ) : $menu_item_meta;
                    $menu_item_meta_settings = isset( $meta['settings'] ) ? $meta['settings'] : $menu_item_meta_settings;

                    if( isset( $menu_item_meta_settings['use_megamenu'] ) && '1' === $menu_item_meta_settings['use_megamenu'] ) {
                        $megamenu_width = isset($menu_item_meta_settings['megamenu_width'])  ? $menu_item_meta_settings['megamenu_width'] : 'kinfw-megamenu-container-width';

                        $classes[] = 'menu-item-has-kinfw-mega-menu';
                        $classes[] = $megamenu_width;

                        $mega_menu_arg = [];
                        if( 'kinfw-megamenu-custom-width' === $megamenu_width ) {
                            $mega_menu_arg['megamenu_width'] = $menu_item_meta_settings['megamenu_custom_width'];
                            $mega_menu_arg['megamenu_align'] = isset( $menu_item_meta_settings['megamenu_position'] ) ? $menu_item_meta_settings['megamenu_position'] : '';
                        } else {
                            $mega_menu_arg['megamenu_align'] = $megamenu_width;
                        }

                        $mega_menu_output = $this->render_megamenu( $menu_item, $mega_menu_arg );
                    }
                }

            /**
             * Filters the arguments for a single nav menu item.
             *
             * @since 4.4.0
             *
             * @param stdClass $args      An object of wp_nav_menu() arguments.
             * @param WP_Post  $menu_item Menu item data object.
             * @param int      $depth     Depth of menu item. Used for padding.
             */
            $args = apply_filters( 'nav_menu_item_args', $args, $menu_item, $depth );

            /**
             * Filters the CSS classes applied to a menu item's list item element.
             *
             * @since 3.0.0
             * @since 4.1.0 The `$depth` parameter was added.
             *
             * @param string[] $classes   Array of the CSS classes that are applied to the menu item's `<li>` element.
             * @param WP_Post  $menu_item The current menu item object.
             * @param stdClass $args      An object of wp_nav_menu() arguments.
             * @param int      $depth     Depth of menu item. Used for padding.
             */
            $class_names = implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $menu_item, $args, $depth ) );

            /**
             * Filters the ID attribute applied to a menu item's list item element.
             *
             * @since 3.0.1
             * @since 4.1.0 The `$depth` parameter was added.
             *
             * @param string   $menu_item_id The ID attribute applied to the menu item's `<li>` element.
             * @param WP_Post  $menu_item    The current menu item.
             * @param stdClass $args         An object of wp_nav_menu() arguments.
             * @param int      $depth        Depth of menu item. Used for padding.
             */
            $id = apply_filters( 'nav_menu_item_id', 'menu-item-' . $menu_item->ID, $menu_item, $args, $depth );

            $li_atts          = array();
            $li_atts['id']    = ! empty( $id ) ? $id : '';
            $li_atts['class'] = ! empty( $class_names ) ? $class_names : '';

            /**
             * Filters the HTML attributes applied to a menu's list item element.
             *
             * @since 6.3.0
             *
             * @param array $li_atts {
             *     The HTML attributes applied to the menu item's `<li>` element, empty strings are ignored.
             *
             *     @type string $class        HTML CSS class attribute.
             *     @type string $id           HTML id attribute.
             * }
             * @param WP_Post  $menu_item The current menu item object.
             * @param stdClass $args      An object of wp_nav_menu() arguments.
             * @param int      $depth     Depth of menu item. Used for padding.
             */
            $li_atts       = apply_filters( 'nav_menu_item_attributes', $li_atts, $menu_item, $args, $depth );
            $li_attributes = $this->build_atts( $li_atts );

            $output .= $indent . '<li' . $li_attributes . '>';

            $atts           = array();
            $atts['title']  = ! empty( $menu_item->attr_title ) ? $menu_item->attr_title : '';
            $atts['target'] = ! empty( $menu_item->target ) ? $menu_item->target : '';
            if ( '_blank' === $menu_item->target && empty( $menu_item->xfn ) ) {
                $atts['rel'] = 'noopener';
            } else {
                $atts['rel'] = $menu_item->xfn;
            }

            if ( ! empty( $menu_item->url ) ) {
                if ( get_privacy_policy_url() === $menu_item->url ) {
                    $atts['rel'] = empty( $atts['rel'] ) ? 'privacy-policy' : $atts['rel'] . ' privacy-policy';
                }

                $atts['href'] = $menu_item->url;
            } else {
                $atts['href'] = '';
            }

            $atts['aria-current'] = $menu_item->current ? 'page' : '';

            /**
             * Filters the HTML attributes applied to a menu item's anchor element.
             *
             * @since 3.6.0
             * @since 4.1.0 The `$depth` parameter was added.
             *
             * @param array $atts {
             *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
             *
             *     @type string $title        Title attribute.
             *     @type string $target       Target attribute.
             *     @type string $rel          The rel attribute.
             *     @type string $href         The href attribute.
             *     @type string $aria-current The aria-current attribute.
             * }
             * @param WP_Post  $menu_item The current menu item object.
             * @param stdClass $args      An object of wp_nav_menu() arguments.
             * @param int      $depth     Depth of menu item. Used for padding.
             */
            $atts       = apply_filters( 'nav_menu_link_attributes', $atts, $menu_item, $args, $depth );
            $attributes = $this->build_atts( $atts );

            /** This filter is documented in wp-includes/post-template.php */
            $title = apply_filters( 'the_title', $menu_item->title, $menu_item->ID );

            /**
             * Filters a menu item's title.
             *
             * @since 4.4.0
             *
             * @param string   $title     The menu item's title.
             * @param WP_Post  $menu_item The current menu item object.
             * @param stdClass $args      An object of wp_nav_menu() arguments.
             * @param int      $depth     Depth of menu item. Used for padding.
             */
            $title = apply_filters( 'nav_menu_item_title', $title, $menu_item, $args, $depth );

            $item_output  = $args->before;
            $item_output .= '<a' . $attributes . '>';
            $item_output .= $args->link_before . $title . $args->link_after;
            $item_output .= '</a>';
            $item_output .= $args->after;

            /**
             * Mega Menu
             */
            $item_output .= $mega_menu_output;

            /**
             * Filters a menu item's starting output.
             *
             * The menu item's starting output only includes `$args->before`, the opening `<a>`,
             * the menu item's title, the closing `</a>`, and `$args->after`. Currently, there is
             * no filter for modifying the opening and closing `<li>` for a menu item.
             *
             * @since 3.0.0
             *
             * @param string   $item_output The menu item's starting HTML output.
             * @param WP_Post  $menu_item   Menu item data object.
             * @param int      $depth       Depth of menu item. Used for padding.
             * @param stdClass $args        An object of wp_nav_menu() arguments.
             */
            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $menu_item, $depth, $args );
        }

        public function render_megamenu( $menu_item, $args ) {

            if ( function_exists( 'kinfw_is_elementor_callable' ) ) {
                $post_id = get_post_meta( $menu_item->ID, '_kinfw_megamenu_elementor_post_id', true );

                if( empty( $post_id ) ) {
                    return;
                }

                $elementor        = \Elementor\Plugin::instance();
                $is_elementor_doc = $elementor->documents->get( $post_id )->is_built_with_elementor();

                $template = $is_elementor_doc
                    ? $elementor->frontend->get_builder_content_for_display( $post_id )
                    : get_the_content(null,false, $post_id );


                $width = ( isset( $args['megamenu_width'] ) ) ? $args['megamenu_width'] : 0;
                $align = ( isset( $args['megamenu_align'] ) ) ? $args['megamenu_align'] : '';

                return sprintf(
                    '<div class="kinfw-mega-menu-wrap %1$s" %2$s> %3$s </div>',
                    $align,
                    ( $width > 0 ) ? 'style="width:'. esc_attr( $width ) .'px"' : '',
                    $template
                );

            }

        }

    }

}
/* Omit closing PHP tag to avoid "Headers already sent" issues. */