<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Mega_Menu' ) ) {

	/**
	 * The Mega Menu setup class.
	 */
    class KinForce_Extra_Plugin_Mega_Menu {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_filter( 'kinfw-filter/theme/nav-menu/settings/tabs', [ $this, 'add_tab' ] );

            add_action( 'admin_footer-nav-menus.php', [ $this, 'modals' ] );

            add_action('admin_enqueue_scripts', [ $this, 'load_assets' ] );

            add_action('wp_ajax_kinfw-action/theme/nav-menu/mega-menu/editor/load', [ $this, 'load_editor' ] );

            add_action( 'before_delete_post', [ $this, 'delete_menu_page' ] );

            $this->load_walkers();

            do_action( 'kinfw-action/plugin/framework/mega-menu/loaded' );

        }

        public function add_tab( $tabs ) {

            $tabs[ 10 ] = [
                'title'  => esc_html_x( 'Mega Menu', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'     => 'switcher',
                        'id'       => 'use_megamenu',
                        'title'    => esc_html_x( 'Use Mega Menu', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        'default'  => false
                    ],
                    [
                        'type'       => 'callback',
                        'function'   => [ $this, 'callback_field' ],
                        'dependency' => [ 'use_megamenu', '==', 'true' ],
                    ],
                    [
                        'type'       => 'button_set',
                        'id'         => 'megamenu_width',
                        'title'      => esc_html_x( 'Container Width', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        'dependency' => [ 'use_megamenu', '==', 'true' ],
                        'options'    => [
                            'kinfw-megamenu-full-width'      => esc_html_x( 'Full', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                            'kinfw-megamenu-stretch-width'   => esc_html_x( 'Stretch', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                            'kinfw-megamenu-container-width' => esc_html_x( 'Container', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                            'kinfw-megamenu-custom-width'    => esc_html_x( 'Custom', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        ]
                    ],
                    [
                        'id'         => 'megamenu_custom_width',
                        'title'      => esc_html_x( 'Max Width', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        'type'       => 'spinner',
                        'min'        => 100,
                        'step'       => 100,
                        'max'        => 5000,
                        'unit'       => 'px',
                        'default'    => 700,
                        'attributes' => [ 'style' => 'width:100px;' ],
                        'dependency' => [ 'use_megamenu|megamenu_width', '==|==', 'true|kinfw-megamenu-custom-width' ],
                    ],
                    [
                        'type'       => 'button_set',
                        'id'         => 'megamenu_position',
                        'title'      => esc_html_x( 'Position', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        'dependency' => [ 'use_megamenu|megamenu_width', '==|==', 'true|kinfw-megamenu-custom-width' ],
                        'options'    => [
                            'kinfw-megamenu-align-left'   => esc_html_x( 'Left', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                            'kinfw-megamenu-align-center' => esc_html_x( 'Center', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                            'kinfw-megamenu-align-right'  => esc_html_x( 'Right', 'admin-nav-menu-settings-field-view', 'onnat-extra' ),
                        ]
                    ],
                ]
            ];

            return $tabs;
        }

        public function callback_field() {
            echo '<span class="kinfw-mega-menu-trigger button button-primary">';
                echo esc_html__('Open Elementor', 'onnat-extra');
            echo '</span>';
        }

        public function modals() {

            $this->megamenu_elementor_modal();
            $this->megamenu_save_and_publish_modal();

        }

        public function megamenu_elementor_modal() {

            echo '<div id="kinfw-mega-menu-modal" class="kinfw-modal-container">';
                echo '<div class="kinfw-modal">';
                    echo '<div class="kinfw-modal-head">';
                        echo '<button type="button" class="kinfw-modal-close-button">';
                            echo '<span class="eicon-close"></span>';
                        echo '</button>';
                    echo '</div>';
                    echo '<div class="kinfw-modal-content">';
                        echo '<iframe id="kinfw-megamenu-iframe" src=""></iframe>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

        }

        public function megamenu_save_and_publish_modal() {

            echo '<div id="kinfw-mega-menu-save-modal" class="kinfw-modal-container">';
                echo '<div class="kinfw-modal">';
                    echo '<div class="kinfw-modal-head">';
                        echo '<div class="kinfw-modal-title">'.esc_html__( 'Leave Mega Menu?', 'onnat-extra' ).'</div>';
                        echo '<button type="button" class="kinfw-modal-close-button media-modal-close">';
                            echo '<span class="media-modal-icon"></span>';
                        echo '</button>';
                    echo '</div>';
                    echo '<div class="kinfw-modal-content">';
                        echo '<p>';
                            esc_html_e( 'Changes that you made may not be saved.', 'onnat-extra' );
                        echo '</p>';
                    echo '</div>';
                    echo '<div class="kinfw-modal-footer">';
                        echo '<button id="kinfw-save" type="button" class="button button-primary button-large">'. esc_html__('Save', 'onnat-extra') .'</button>';
                        echo '<button id="kinfw-cancel" type="button" class="button button-secondary button-large">'. esc_html__('Cancel', 'onnat-extra') .'</button>';
                    echo '</div>';
                echo '</div>';
                echo '<div class="media-modal-backdrop"></div>';
            echo '</div>';

        }

        public function load_assets() {

            $current_screen = get_current_screen();

            if ($current_screen->base == 'nav-menus') {

                wp_enqueue_style( 'kf-extra-mega-menu-admin',
                    KFE_CONST_URL . 'libraries/framework/mega-menu/assets/css/admin' . KFE_CONST_DEBUG_SUFFIX . '.css',
                    [],
                    KFE_CONST_VERSION
                );

                wp_enqueue_script ( 'kf-extra-mega-menu-admin',
                    KFE_CONST_URL . 'libraries/framework/mega-menu/assets/js/admin' . KFE_CONST_DEBUG_SUFFIX . '.js',
                    [ 'jquery' ],
                    KFE_CONST_VERSION,
                    true
                );
            }

        }

        public function load_editor() {
            $menu_item_id = sanitize_key( $_REQUEST["_id"] );

            if( !empty( $menu_item_id ) ) {

                $post_id    = null;
                $post_title = sprintf("KINFW-MEGA-MENU-POST-%d", $menu_item_id );

                $query = new WP_Query([
                    'title'     => $post_title,
                    'post_type' => 'kinfw-mega-menu',
                ]);

                if( is_null( $query->post ) ) {
                    $post_id = wp_insert_post([
                        'post_title'  => $post_title,
                        'post_contet' => '',
                        'post_status' => 'publish',
                        'post_type'   => 'kinfw-mega-menu',
                        'meta_input'  => [
                            '_wp_page_template' => 'elementor_canvas'
                        ]
                    ]);

                } else {
                    $post_id = $query->post->ID;
                }

                if( !empty( $post_id ) ) {

                    update_post_meta( $menu_item_id, '_kinfw_megamenu_elementor_post_id', $post_id );

                    $post_edit_url = admin_url( add_query_arg( [
                        'post'   => $post_id,
                        'action' => 'elementor'
                    ], 'post.php' ) );

                    wp_send_json_success([
                        'post_url' => esc_url_raw( $post_edit_url )
                    ]);
                } else {
                    wp_send_json_error([
                        'message' => esc_html__('Invalid Access','onnat-extra')
                    ]);
                }

            }

            wp_die();

        }

        public function delete_menu_page( $menu_item_id ) {

            if( !empty( $menu_item_id ) ) {

                $post_title = sprintf("KINFW-MEGA-MENU-POST-%d", $menu_item_id );

                $query = new WP_Query([
                    'title'     => $post_title,
                    'post_type' => 'kinfw-mega-menu',
                ]);

                if( !is_null( $query->post ) ) {
                    $post_id = $query->post->ID;
                    wp_delete_post( $post_id, true );
                    delete_post_meta( $menu_item_id, '_kinfw_megamenu_elementor_post_id' );

                }

            }

        }

        public function load_walkers() {

            require_once KFE_CONST_DIR . 'libraries/framework/mega-menu/class-mega-menu-nav-menu-walker.php';
        }

    }
}

if( !function_exists( 'kf_extra_plugin_mega_menu' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_mega_menu() {

        return KinForce_Extra_Plugin_Mega_Menu::get_instance();
    }
}

kf_extra_plugin_mega_menu();
  /* Omit closing PHP tag to avoid "Headers already sent" issues. */