<?php
add_action('wp_ajax_ssb_charge_customer', 'ssb_charge_customer');
function ssb_charge_customer() {
    \Stripe\Stripe::setApiKey('sk_test_your_secret_key');

    $data = json_decode(file_get_contents('php://input'), true);
    $amount = intval($data['amount']) * 100;

    try {
        \Stripe\PaymentIntent::create([
            'amount' => $amount,
            'currency' => 'usd',
            'customer' => $data['customer_id'],
            'payment_method' => $data['payment_method'],
            'off_session' => true,
            'confirm' => true,
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Charged successfully.']);
    } catch (\Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    wp_die();
}

add_action('wp_ajax_ssb_subscribe_customer', 'ssb_subscribe_customer');
function ssb_subscribe_customer() {
    \Stripe\Stripe::setApiKey('sk_test_your_secret_key');

    $data = json_decode(file_get_contents('php://input'), true);

    try {
        \Stripe\Subscription::create([
            'customer' => $data['customer_id'],
            'items' => [[ 'price' => $data['price_id'] ]],
            'default_payment_method' => $data['payment_method'],
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Subscription created.']);
    } catch (\Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    wp_die();
}
