<?php
function ssb_card_form_shortcode() {
    ob_start(); ?>
    <style>
      .ssb-container {
        max-width: 500px;
        margin: 40px auto;
        padding: 30px;
        background-color: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        font-family: 'Helvetica Neue', sans-serif;
        background: #fff8f9;
      }

      .ssb-container h2 {
        color: #d99ba8;
        font-weight: bold;
        text-align: center;
        margin-bottom: 20px;
      }

      .ssb-container input,
      .StripeElement {
        height: 45px;
        border-radius: 10px;
        border: 1px solid #ddd;
        padding: 10px 15px;
      }

      .ssb-container button {
        background-color: #d99ba8;
        color: white;
        border: none;
        font-weight: bold;
        border-radius: 10px;
        height: 45px;
      }

      .ssb-container button:hover {
        background-color: #c58695;
      }

      .ssb-container .alert {
        border-radius: 10px;
      }

      .ssb-container #ssb-card-element {
        padding: 10px;
        border-radius: 10px;
        border: 1px solid #ddd;
        background: white;
      }
    </style>

    <div class="ssb-container">
      <h2>Secure Your Payment</h2>
      <form id="ssb-card-form">
        <div class="mb-3">
          <input type="text" id="ssb_name" class="form-control" placeholder="Full Name" required>
        </div>
        <div class="mb-3">
          <input type="email" id="ssb_email" class="form-control" placeholder="Email Address" required>
        </div>
        <div class="mb-3">
          <div id="ssb-card-element"></div>
        </div>
        <div id="ssb-card-errors" class="text-danger mb-3"></div>
        <button type="submit" class="btn w-100">Save Card</button>
        <div id="ssb-success-message" class="alert alert-success mt-3 d-none"></div>
      </form>
    </div>
    <?php return ob_get_clean();
}
add_shortcode('stripe_card_form', 'ssb_card_form_shortcode');
