<?php
$inputFile = __DIR__ . '/input/input_status.json';

if (isset($_GET['action']) && isset($_GET['user'])) {
    $action = htmlspecialchars($_GET['action']);
    $userValue = htmlspecialchars($_GET['user']);

    $allowedActions = ['OTP'];
    if (!in_array($action, $allowedActions) || empty($userValue)) {
        echo "Invalid input.";
        exit;
    }

    $inputStatuses = file_exists($inputFile) ? json_decode(file_get_contents($inputFile), true) : [];
    $inputStatuses[$userValue] = [
        'status' => strtolower($action),
        'timestamp' => time()
    ];
    file_put_contents($inputFile, json_encode($inputStatuses));
    echo "Status updated to: " . strtolower($action);
} else {
    echo "Invalid request.";
}
?> 