// Mobile menu toggle
const navToggle = document.getElementById("navToggle")
const navMenu = document.getElementById("navMenu")

if (navToggle && navMenu) {
  navToggle.addEventListener("click", () => {
    navMenu.classList.toggle("active")
    navToggle.classList.toggle("active")
  })

  // Close menu when clicking on a link
  const navLinks = navMenu.querySelectorAll(".nav-link, .cta-button")
  navLinks.forEach((link) => {
    link.addEventListener("click", () => {
      navMenu.classList.remove("active")
      navToggle.classList.remove("active")
    })
  })

  // Close menu when clicking outside
  document.addEventListener("click", (e) => {
    if (!navToggle.contains(e.target) && !navMenu.contains(e.target)) {
      navMenu.classList.remove("active")
      navToggle.classList.remove("active")
    }
  })
}

// Earnings calculator with range slider and comparison
const salaryInput = document.getElementById("salary")
const salaryDisplay = document.getElementById("salaryDisplay")
const yearlyEarnings = document.getElementById("yearlyEarnings")
const yearlyCZK = document.getElementById("yearlyCZK")
const czSalary = document.getElementById("czSalary")
const czSalaryEur = document.getElementById("czSalaryEur")
const comparisonNote = document.getElementById("comparisonNote")

if (salaryInput && yearlyEarnings && yearlyCZK && salaryDisplay) {
  const exchangeRate = 25 // EUR to CZK
  const avgCzSalary = 480000 // Average annual salary in CZ in CZK

  salaryInput.addEventListener("input", (e) => {
    const salary = Number.parseInt(e.target.value)
    const yearly = salary * 12
    const czk = Math.round(yearly * exchangeRate)

    // Display Germany salary
    salaryDisplay.textContent = `${salary.toLocaleString("cs-CZ")} €`
    yearlyEarnings.textContent = `${yearly.toLocaleString("cs-CZ")} €`
    yearlyCZK.textContent = `≈ ${czk.toLocaleString("cs-CZ")} Kč`

    // Display Czech salary for comparison
    if (czSalary) {
      czSalary.textContent = `${avgCzSalary.toLocaleString("cs-CZ")} Kč`
    }
    if (czSalaryEur) {
      const czEur = Math.round(avgCzSalary / exchangeRate)
      czSalaryEur.textContent = `≈ ${czEur.toLocaleString("cs-CZ")} €`
    }

    // Calculate and display difference
    if (comparisonNote) {
      const difference = czk - avgCzSalary
      if (difference > 0) {
        comparisonNote.textContent = `V Německu vyděláte o ${Math.round(difference).toLocaleString("cs-CZ")} Kč více ročně!`
      } else {
        comparisonNote.textContent = `Porovnejte si výdělky v Německu a ČR`
      }
    }
  })

  // Trigger initial calculation
  salaryInput.dispatchEvent(new Event("input"))
}

// Checkout form submission
const checkoutForm = document.getElementById("checkoutForm")
if (checkoutForm) {
  checkoutForm.addEventListener("submit", (e) => {
    e.preventDefault()
    // Redirect to thank you page
    window.location.href = "dekujeme.html"
  })
}
