<?php
session_start(); // For storing order_ref (optional)
// print_r($_GET);
// exit();
$storeId   = '33444';
$authKey   = 'hmjj#4gsKL@SVVkB';
$returnUrl = 'https://fayzco.com/success/';
$cancelUrl = 'https://fayzco.com/failed/';

// Fetch values from GET
$price  = $_GET['price'] ?? '';
$mobile = $_GET['mobile'] ?? '';
$email  = $_GET['email'] ?? '';
$name   = $_GET['name'] ?? '';

// Optional: extract numeric amount from price text
preg_match('/\d+(\.\d+)?/', $price, $matches);
$amount = $matches[0] ?? '100.00';

// Generate order ID and currency
$orderId  = rand(1000, 9999);
$currency = 'SAR';

// Prepare parameters
$params = [
    'ivp_method'   => 'create',
    'ivp_store'    => $storeId,
    'ivp_authkey'  => $authKey,
    'ivp_cart'     => $orderId,
    'ivp_amount'   => $amount,
    'ivp_currency' => $currency,
    'ivp_test'     => '0', // test mode
    'ivp_desc'     => 'Payment for ' . $price,
    'return_auth'  => $returnUrl,
    'return_can'   => $cancelUrl,
    'return_decl'  => $cancelUrl,
    'bill_fname'   => $name,
    'bill_sname'   => '',
    'bill_email'   => $email,
    'bill_addr1'   => 'Address not provided',
    'bill_city'    => 'Riyadh',
    'bill_country' => 'SA',
    'bill_phone'   => $mobile,
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://secure.telr.com/gateway/order.json");
curl_setopt($ch, CURLOPT_POST, true);

// ✅ Encode properly for special characters in API key
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params, '', '&', PHP_QUERY_RFC3986));

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Expect:']);
$response = curl_exec($ch);
curl_close($ch);

// Decode the response
$result = json_decode($response, true);

if (isset($result['order']['url']) && isset($result['order']['ref'])) {
    $_SESSION['telr_order_ref'] = $result['order']['ref']; // Save for checking later
    header("Location: " . $result['order']['url']);
    exit;
} else {
    echo "<h3>Failed to create payment</h3>";
    echo "<pre>";
    print_r($result);
    echo "</pre>";
}
?>
