<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'FontFlow_WP_Plugin_Elementor_Elegant_Icons' ) ) {

	/**
	 * Define the Elegant Icons icon library.
	 */
    class FontFlow_WP_Plugin_Elementor_Elegant_Icons {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {
			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;
		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'load'] );
			do_action( 'fontflow-action/plugin/elementor/icon-library/eleganticons/loaded' );
        }

        public function load( $additional_tabs ) {

            $icons = [
                'arrow_back',
                'arrow_carrot_up_alt',
                'arrow_carrot-2down_alt2',
                'arrow_carrot-2down',
                'arrow_carrot-2dwnn_alt',
                'arrow_carrot-2left_alt',
                'arrow_carrot-2left_alt2',
                'arrow_carrot-2left',
                'arrow_carrot-2right_alt',
                'arrow_carrot-2right_alt2',
                'arrow_carrot-2right',
                'arrow_carrot-2up_alt',
                'arrow_carrot-2up_alt2',
                'arrow_carrot-2up',
                'arrow_carrot-down_alt',
                'arrow_carrot-down_alt2',
                'arrow_carrot-down',
                'arrow_carrot-left_alt',
                'arrow_carrot-left_alt2',
                'arrow_carrot-left',
                'arrow_carrot-right_alt',
                'arrow_carrot-right_alt2',
                'arrow_carrot-right',
                'arrow_carrot-up_alt2',
                'arrow_carrot-up',
                'arrow_condense_alt',
                'arrow_condense',
                'arrow_down_alt',
                'arrow_down',
                'arrow_expand_alt',
                'arrow_expand_alt2',
                'arrow_expand_alt3',
                'arrow_expand',
                'arrow_left_alt',
                'arrow_left-down_alt',
                'arrow_left-down',
                'arrow_left-right_alt',
                'arrow_left-right',
                'arrow_left-up_alt',
                'arrow_left-up',
                'arrow_left',
                'arrow_move',
                'arrow_right_alt',
                'arrow_right-down_alt',
                'arrow_right-down',
                'arrow_right-up_alt',
                'arrow_right-up',
                'arrow_right',
                'arrow_triangle-down_alt',
                'arrow_triangle-down_alt2',
                'arrow_triangle-down',
                'arrow_triangle-left_alt',
                'arrow_triangle-left_alt2',
                'arrow_triangle-left',
                'arrow_triangle-right_alt',
                'arrow_triangle-right_alt2',
                'arrow_triangle-right',
                'arrow_triangle-up_alt',
                'arrow_triangle-up_alt2',
                'arrow_triangle-up',
                'arrow_up_alt',
                'arrow_up-down_alt',
                'arrow_up',
                'arrow-up-down',
                'icon_adjust-horiz',
                'icon_adjust-vert',
                'icon_archive_alt',
                'icon_archive',
                'icon_bag_alt',
                'icon_bag',
                'icon_balance',
                'icon_blocked',
                'icon_book_alt',
                'icon_book',
                'icon_box-checked',
                'icon_box-empty',
                'icon_box-selected',
                'icon_briefcase_alt',
                'icon_briefcase',
                'icon_building_alt',
                'icon_building',
                'icon_calculator_alt',
                'icon_calendar',
                'icon_calulator',
                'icon_camera_alt',
                'icon_camera',
                'icon_cart_alt',
                'icon_cart',
                'icon_chat_alt',
                'icon_chat',
                'icon_check_alt',
                'icon_check_alt2',
                'icon_check',
                'icon_circle-empty',
                'icon_circle-slelected',
                'icon_clipboard',
                'icon_clock_alt',
                'icon_clock',
                'icon_close_alt',
                'icon_close_alt2',
                'icon_close',
                'icon_cloud_alt',
                'icon_cloud-download_alt',
                'icon_cloud-download',
                'icon_cloud-upload_alt',
                'icon_cloud-upload',
                'icon_cloud',
                'icon_cog',
                'icon_cogs',
                'icon_comment_alt',
                'icon_comment',
                'icon_compass_alt',
                'icon_compass',
                'icon_cone_alt',
                'icon_cone',
                'icon_contacts_alt',
                'icon_contacts',
                'icon_creditcard',
                'icon_currency_alt',
                'icon_currency',
                'icon_cursor_alt',
                'icon_cursor',
                'icon_datareport_alt',
                'icon_datareport',
                'icon_desktop',
                'icon_dislike_alt',
                'icon_dislike',
                'icon_document_alt',
                'icon_document',
                'icon_documents_alt',
                'icon_documents',
                'icon_download',
                'icon_drawer_alt',
                'icon_drawer',
                'icon_drive_alt',
                'icon_drive',
                'icon_easel_alt',
                'icon_easel',
                'icon_error-circle_alt',
                'icon_error-circle',
                'icon_error-oct_alt',
                'icon_error-oct',
                'icon_error-triangle_alt',
                'icon_error-triangle',
                'icon_film',
                'icon_floppy_alt',
                'icon_floppy',
                'icon_flowchart_alt',
                'icon_flowchart',
                'icon_folder_download',
                'icon_folder_upload',
                'icon_folder-add_alt',
                'icon_folder-add',
                'icon_folder-alt',
                'icon_folder-open_alt',
                'icon_folder-open',
                'icon_folder',
                'icon_genius',
                'icon_gift_alt',
                'icon_gift',
                'icon_globe_alt',
                'icon_globe-2',
                'icon_globe',
                'icon_grid-2x2',
                'icon_grid-3x3',
                'icon_group',
                'icon_headphones',
                'icon_heart_alt',
                'icon_heart',
                'icon_hourglass',
                'icon_house_alt',
                'icon_house',
                'icon_id_alt',
                'icon_id-2_alt',
                'icon_id-2',
                'icon_id',
                'icon_image',
                'icon_images',
                'icon_info_alt',
                'icon_info',
                'icon_key_alt',
                'icon_key',
                'icon_laptop',
                'icon_lifesaver',
                'icon_lightbulb_alt',
                'icon_lightbulb',
                'icon_like_alt',
                'icon_like',
                'icon_link_alt',
                'icon_link',
                'icon_loading',
                'icon_lock_alt',
                'icon_lock-open_alt',
                'icon_lock-open',
                'icon_lock',
                'icon_mail_alt',
                'icon_mail',
                'icon_map_alt',
                'icon_map',
                'icon_menu-circle_alt',
                'icon_menu-circle_alt2',
                'icon_menu-square_alt',
                'icon_menu-square_alt2',
                'icon_menu',
                'icon_mic_alt',
                'icon_mic',
                'icon_minus_alt',
                'icon_minus_alt2',
                'icon_minus-06',
                'icon_minus-box',
                'icon_mobile',
                'icon_mug_alt',
                'icon_mug',
                'icon_music',
                'icon_ol',
                'icon_paperclip',
                'icon_pause_alt',
                'icon_pause_alt2',
                'icon_pause',
                'icon_pencil_alt',
                'icon_pencil-edit_alt',
                'icon_pencil-edit',
                'icon_pencil',
                'icon_pens_alt',
                'icon_pens',
                'icon_percent_alt',
                'icon_percent',
                'icon_phone',
                'icon_piechart',
                'icon_pin_alt',
                'icon_pin',
                'icon_plus_alt',
                'icon_plus_alt2',
                'icon_plus-box',
                'icon_plus',
                'icon_printer-alt',
                'icon_printer',
                'icon_profile',
                'icon_pushpin_alt',
                'icon_pushpin',
                'icon_puzzle_alt',
                'icon_puzzle',
                'icon_question_alt',
                'icon_question_alt2',
                'icon_question',
                'icon_quotations_alt',
                'icon_quotations_alt2',
                'icon_quotations',
                'icon_refresh',
                'icon_ribbon_alt',
                'icon_ribbon',
                'icon_rook',
                'icon_search_alt',
                'icon_search',
                'icon_search2',
                'icon_shield_alt',
                'icon_shield',
                'icon_star_alt',
                'icon_star-half_alt',
                'icon_star-half',
                'icon_star',
                'icon_stop_alt',
                'icon_stop_alt2',
                'icon_stop',
                'icon_table',
                'icon_tablet',
                'icon_tag_alt',
                'icon_tag',
                'icon_tags_alt',
                'icon_tags',
                'icon_target',
                'icon_tool',
                'icon_toolbox_alt',
                'icon_toolbox',
                'icon_tools',
                'icon_trash_alt',
                'icon_trash',
                'icon_ul',
                'icon_upload',
                'icon_vol-mute_alt',
                'icon_vol-mute',
                'icon_volume-high_alt',
                'icon_volume-high',
                'icon_volume-low_alt',
                'icon_volume-low',
                'icon_wallet_alt',
                'icon_wallet',
                'icon_zoom-in_alt',
                'icon_zoom-in',
                'icon_zoom-out_alt',
                'icon_zoom-out',
                'social_blogger_circle',
                'social_blogger_square',
                'social_blogger',
                'social_delicious_circle',
                'social_delicious_square',
                'social_delicious',
                'social_deviantart_circle',
                'social_deviantart_square',
                'social_deviantart',
                'social_dribbble_circle',
                'social_dribbble_square',
                'social_dribbble',
                'social_facebook_circle',
                'social_facebook_square',
                'social_facebook',
                'social_flickr_circle',
                'social_flickr_square',
                'social_flickr',
                'social_googledrive_alt2',
                'social_googledrive_square',
                'social_googledrive',
                'social_googleplus_circle',
                'social_googleplus_square',
                'social_googleplus',
                'social_instagram_circle',
                'social_instagram_square',
                'social_instagram',
                'social_linkedin_circle',
                'social_linkedin_square',
                'social_linkedin',
                'social_myspace_circle',
                'social_myspace_square',
                'social_myspace',
                'social_picassa_circle',
                'social_picassa_square',
                'social_picassa',
                'social_pinterest_circle',
                'social_pinterest_square',
                'social_pinterest',
                'social_rss_circle',
                'social_rss_square',
                'social_rss',
                'social_share_circle',
                'social_share_square',
                'social_share',
                'social_skype_circle',
                'social_skype_square',
                'social_skype',
                'social_spotify_circle',
                'social_spotify_square',
                'social_spotify',
                'social_stumbleupon_circle',
                'social_stumbleupon_square',
                'social_tumbleupon',
                'social_tumblr_circle',
                'social_tumblr_square',
                'social_tumblr',
                'social_twitter_circle',
                'social_twitter_square',
                'social_twitter',
                'social_vimeo_circle',
                'social_vimeo_square',
                'social_vimeo',
                'social_wordpress_circle',
                'social_wordpress_square',
                'social_wordpress',
                'social_youtube_circle',
                'social_youtube_square',
                'social_youtube',
            ];

            $additional_tabs[ 'fontflow-eleganticons' ] = [
                'name'          => 'fontflow-eleganticons',
                'label'         => esc_html__( 'FontFlow - ElegantIcons', 'fontflow' ),
                'labelIcon'     => 'fas fa-chevron-right',
                'ver'           => esc_attr( FCIFE_CONST_VERSION ),
                'prefix'        => 'fontflow-eleganticons-',
                'displayPrefix' => 'fontflow-eleganticons',
                'url'           => esc_url( FCIFE_CONST_URL . 'assets/css/eleganticons/fontflow-eleganticons.min.css' ),
                'enqueue'       => [ FCIFE_CONST_URL . 'assets/css/eleganticons/fontflow-eleganticons.min.css' ],
                'icons'         => $icons
            ];

            return $additional_tabs;
        }
    }

}

if( !function_exists( 'fontflow_wp_plugin_elementor_eleganticons' ) ) {

    /**
     * Returns the instance of a class.
     */
    function fontflow_wp_plugin_elementor_eleganticons() {

        return FontFlow_WP_Plugin_Elementor_Elegant_Icons::get_instance();
    }
}

fontflow_wp_plugin_elementor_eleganticons();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */