<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'FontFlow_WP_Plugin_Elementor_Line_Icons' ) ) {

	/**
	 * Define the Line Icons icon library.
	 */
    class FontFlow_WP_Plugin_Elementor_Line_Icons {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {
			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;
		}

		/**
		 * Constructor
		 */
        public function __construct() {
            add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'load'] );
			do_action( 'fontflow-action/plugin/elementor/icon-library/lineicons/loaded' );
        }

        public function load( $additional_tabs ) {

            $icons = [
                '500px',
                'accessible-icon',
                'accusoft',
                'acquisitions-incorporated',
                'ad-solid',
                'address-book-solid',
                'address-book',
                'address-card-solid',
                'address-card',
                'adjust-solid',
                'adn',
                'adobe',
                'adversal',
                'affiliatetheme',
                'air-freshener-solid',
                'airbnb',
                'algolia',
                'align-center-solid',
                'align-justify-solid',
                'align-left-solid',
                'align-right-solid',
                'alipay',
                'allergies-solid',
                'amazon-pay',
                'amazon',
                'ambulance-solid',
                'american-sign-language-interpreting-solid',
                'amilia',
                'anchor-solid',
                'android',
                'angellist',
                'angle-double-down-solid',
                'angle-double-left-solid',
                'angle-double-right-solid',
                'angle-double-up-solid',
                'angle-down-solid',
                'angle-left-solid',
                'angle-right-solid',
                'angle-up-solid',
                'angry-solid',
                'angry',
                'angrycreative',
                'angular',
                'ankh-solid',
                'app-store-ios',
                'app-store',
                'apper',
                'apple-alt-solid',
                'apple-pay',
                'apple',
                'archive-solid',
                'archway-solid',
                'arrow-alt-circle-down-solid',
                'arrow-alt-circle-down',
                'arrow-alt-circle-left-solid',
                'arrow-alt-circle-left',
                'arrow-alt-circle-right-solid',
                'arrow-alt-circle-right',
                'arrow-alt-circle-up-solid',
                'arrow-alt-circle-up',
                'arrow-circle-down-solid',
                'arrow-circle-left-solid',
                'arrow-circle-right-solid',
                'arrow-circle-up-solid',
                'arrow-down-solid',
                'arrow-left-solid',
                'arrow-right-solid',
                'arrow-up-solid',
                'arrows-alt-h-solid',
                'arrows-alt-solid',
                'arrows-alt-v-solid',
                'artstation',
                'assistive-listening-systems-solid',
                'asterisk-solid',
                'asymmetrik',
                'at-solid',
                'atlas-solid',
                'atlassian',
                'atom-solid',
                'audible',
                'audio-description-solid',
                'autoprefixer',
                'avianex',
                'aviato',
                'award-solid',
                'aws',
                'baby-carriage-solid',
                'baby-solid',
                'backspace-solid',
                'backward-solid',
                'bacon-solid',
                'balance-scale-left-solid',
                'balance-scale-right-solid',
                'balance-scale-solid',
                'ban-solid',
                'band-aid-solid',
                'bandcamp',
                'barcode-solid',
                'bars-solid',
                'baseball-ball-solid',
                'basketball-ball-solid',
                'bath-solid',
                'battery-empty-solid',
                'battery-full-solid',
                'battery-half-solid',
                'battery-quarter-solid',
                'battery-three-quarters-solid',
                'battle-net',
                'bed-solid',
                'beer-solid',
                'behance-square',
                'behance',
                'bell-slash-solid',
                'bell-slash',
                'bell-solid',
                'bell',
                'bezier-curve-solid',
                'bible-solid',
                'bicycle-solid',
                'biking-solid',
                'bimobject',
                'binoculars-solid',
                'biohazard-solid',
                'birthday-cake-solid',
                'bitbucket',
                'bitcoin',
                'bity',
                'black-tie',
                'blackberry',
                'blender-phone-solid',
                'blender-solid',
                'blind-solid',
                'blog-solid',
                'blogger-b',
                'blogger',
                'bluetooth-b',
                'bluetooth',
                'bold-solid',
                'bolt-solid',
                'bomb-solid',
                'bone-solid',
                'bong-solid',
                'book-dead-solid',
                'book-medical-solid',
                'book-open-solid',
                'book-reader-solid',
                'book-solid',
                'bookmark-solid',
                'bookmark',
                'bootstrap',
                'border-all-solid',
                'border-none-solid',
                'border-style-solid',
                'bowling-ball-solid',
                'box-open-solid',
                'box-solid',
                'boxes-solid',
                'braille-solid',
                'brain-solid',
                'bread-slice-solid',
                'briefcase-medical-solid',
                'briefcase-solid',
                'broadcast-tower-solid',
                'broom-solid',
                'brush-solid',
                'btc',
                'buffer',
                'bug-solid',
                'building-solid',
                'building',
                'bullhorn-solid',
                'bullseye-solid',
                'burn-solid',
                'buromobelexperte',
                'bus-alt-solid',
                'bus-solid',
                'business-time-solid',
                'buy-n-large',
                'buysellads',
                'calculator-solid',
                'calendar-alt-solid',
                'calendar-alt',
                'calendar-check-solid',
                'calendar-check',
                'calendar-day-solid',
                'calendar-minus-solid',
                'calendar-minus',
                'calendar-plus-solid',
                'calendar-plus',
                'calendar-solid',
                'calendar-times-solid',
                'calendar-times',
                'calendar-week-solid',
                'calendar',
                'camera-retro-solid',
                'camera-solid',
                'campground-solid',
                'canadian-maple-leaf',
                'candy-cane-solid',
                'cannabis-solid',
                'capsules-solid',
                'car-alt-solid',
                'car-battery-solid',
                'car-crash-solid',
                'car-side-solid',
                'car-solid',
                'caret-down-solid',
                'caret-left-solid',
                'caret-right-solid',
                'caret-square-down-solid',
                'caret-square-down',
                'caret-square-left-solid',
                'caret-square-left',
                'caret-square-right-solid',
                'caret-square-right',
                'caret-square-up-solid',
                'caret-square-up',
                'caret-up-solid',
                'carrot-solid',
                'cart-arrow-down-solid',
                'cart-plus-solid',
                'cash-register-solid',
                'cat-solid',
                'cc-amazon-pay',
                'cc-amex',
                'cc-apple-pay',
                'cc-diners-club',
                'cc-discover',
                'cc-jcb',
                'cc-mastercard',
                'cc-paypal',
                'cc-stripe',
                'cc-visa',
                'centercode',
                'centos',
                'certificate-solid',
                'chair-solid',
                'chalkboard-solid',
                'chalkboard-teacher-solid',
                'charging-station-solid',
                'chart-area-solid',
                'chart-bar-solid',
                'chart-bar',
                'chart-line-solid',
                'chart-pie-solid',
                'check-circle-solid',
                'check-circle',
                'check-double-solid',
                'check-solid',
                'check-square-solid',
                'check-square',
                'cheese-solid',
                'chess-bishop-solid',
                'chess-board-solid',
                'chess-king-solid',
                'chess-knight-solid',
                'chess-pawn-solid',
                'chess-queen-solid',
                'chess-rook-solid',
                'chess-solid',
                'chevron-circle-down-solid',
                'chevron-circle-left-solid',
                'chevron-circle-right-solid',
                'chevron-circle-up-solid',
                'chevron-down-solid',
                'chevron-left-solid',
                'chevron-right-solid',
                'chevron-up-solid',
                'child-solid',
                'chrome',
                'chromecast',
                'church-solid',
                'circle-notch-solid',
                'circle-solid',
                'circle',
                'city-solid',
                'clinic-medical-solid',
                'clipboard-check-solid',
                'clipboard-list-solid',
                'clipboard-solid',
                'clipboard',
                'clock-solid',
                'clock',
                'clone-solid',
                'clone',
                'closed-captioning-solid',
                'closed-captioning',
                'cloud-download-alt-solid',
                'cloud-meatball-solid',
                'cloud-moon-rain-solid',
                'cloud-moon-solid',
                'cloud-rain-solid',
                'cloud-showers-heavy-solid',
                'cloud-solid',
                'cloud-sun-rain-solid',
                'cloud-sun-solid',
                'cloud-upload-alt-solid',
                'cloudscale',
                'cloudsmith',
                'cloudversify',
                'cocktail-solid',
                'code-branch-solid',
                'code-solid',
                'codepen',
                'codiepie',
                'coffee-solid',
                'cog-solid',
                'cogs-solid',
                'coins-solid',
                'columns-solid',
                'comment-alt-solid',
                'comment-alt',
                'comment-dollar-solid',
                'comment-dots-solid',
                'comment-dots',
                'comment-medical-solid',
                'comment-slash-solid',
                'comment-solid',
                'comment',
                'comments-dollar-solid',
                'comments-solid',
                'comments',
                'compact-disc-solid',
                'compass-solid',
                'compass',
                'compress-arrows-alt-solid',
                'compress-solid',
                'concierge-bell-solid',
                'confluence',
                'connectdevelop',
                'contao',
                'cookie-bite-solid',
                'cookie-solid',
                'copy-solid',
                'copy',
                'copyright-solid',
                'copyright',
                'cotton-bureau',
                'couch-solid',
                'cpanel',
                'creative-commons-by',
                'creative-commons-nc-eu',
                'creative-commons-nc-jp',
                'creative-commons-nc',
                'creative-commons-nd',
                'creative-commons-pd-alt',
                'creative-commons-pd',
                'creative-commons-remix',
                'creative-commons-sa',
                'creative-commons-sampling-plus',
                'creative-commons-sampling',
                'creative-commons-share',
                'creative-commons-zero',
                'creative-commons',
                'credit-card-solid',
                'credit-card',
                'critical-role',
                'crop-alt-solid',
                'crop-solid',
                'cross-solid',
                'crosshairs-solid',
                'crow-solid',
                'crown-solid',
                'crutch-solid',
                'css3-alt',
                'css3',
                'cube-solid',
                'cubes-solid',
                'cut-solid',
                'cuttlefish',
                'd-and-d-beyond',
                'd-and-d',
                'dashcube',
                'database-solid',
                'deaf-solid',
                'delicious',
                'democrat-solid',
                'deploydog',
                'deskpro',
                'desktop-solid',
                'dev',
                'deviantart',
                'dharmachakra-solid',
                'dhl',
                'diagnoses-solid',
                'diaspora',
                'dice-d20-solid',
                'dice-d6-solid',
                'dice-five-solid',
                'dice-four-solid',
                'dice-one-solid',
                'dice-six-solid',
                'dice-solid',
                'dice-three-solid',
                'dice-two-solid',
                'digg',
                'digital-ocean',
                'digital-tachograph-solid',
                'directions-solid',
                'discord',
                'discourse',
                'divide-solid',
                'dizzy-solid',
                'dizzy',
                'dna-solid',
                'dochub',
                'docker',
                'dog-solid',
                'dollar-sign-solid',
                'dolly-flatbed-solid',
                'dolly-solid',
                'donate-solid',
                'door-closed-solid',
                'door-open-solid',
                'dot-circle-solid',
                'dot-circle',
                'dove-solid',
                'download-solid',
                'draft2digital',
                'drafting-compass-solid',
                'dragon-solid',
                'draw-polygon-solid',
                'dribbble-square',
                'dribbble',
                'dropbox',
                'drum-solid',
                'drum-steelpan-solid',
                'drumstick-bite-solid',
                'drupal',
                'dumbbell-solid',
                'dumpster-fire-solid',
                'dumpster-solid',
                'dungeon-solid',
                'dyalog',
                'earlybirds',
                'ebay',
                'edge',
                'edit-solid',
                'edit',
                'egg-solid',
                'eject-solid',
                'elementor',
                'ellipsis-h-solid',
                'ellipsis-v-solid',
                'ello',
                'ember',
                'empire',
                'envelope-open-solid',
                'envelope-open-text-solid',
                'envelope-open',
                'envelope-solid',
                'envelope-square-solid',
                'envelope',
                'envira',
                'equals-solid',
                'eraser-solid',
                'erlang',
                'ethereum',
                'ethernet-solid',
                'etsy',
                'euro-sign-solid',
                'evernote',
                'exchange-alt-solid',
                'exclamation-circle-solid',
                'exclamation-solid',
                'exclamation-triangle-solid',
                'expand-arrows-alt-solid',
                'expand-solid',
                'expeditedssl',
                'external-link-alt-solid',
                'external-link-square-alt-solid',
                'eye-dropper-solid',
                'eye-slash-solid',
                'eye-slash',
                'eye-solid',
                'eye',
                'facebook-f',
                'facebook-messenger',
                'facebook-square',
                'facebook',
                'fan-solid',
                'fantasy-flight-games',
                'fast-backward-solid',
                'fast-forward-solid',
                'fax-solid',
                'feather-alt-solid',
                'feather-solid',
                'fedex',
                'fedora',
                'female-solid',
                'fighter-jet-solid',
                'figma',
                'file-alt-solid',
                'file-alt',
                'file-archive-solid',
                'file-archive',
                'file-audio-solid',
                'file-audio',
                'file-code-solid',
                'file-code',
                'file-contract-solid',
                'file-csv-solid',
                'file-download-solid',
                'file-excel-solid',
                'file-excel',
                'file-export-solid',
                'file-image-solid',
                'file-image',
                'file-import-solid',
                'file-invoice-dollar-solid',
                'file-invoice-solid',
                'file-medical-alt-solid',
                'file-medical-solid',
                'file-pdf-solid',
                'file-pdf',
                'file-powerpoint-solid',
                'file-powerpoint',
                'file-prescription-solid',
                'file-signature-solid',
                'file-solid',
                'file-upload-solid',
                'file-video-solid',
                'file-video',
                'file-word-solid',
                'file-word',
                'file',
                'fill-drip-solid',
                'fill-solid',
                'film-solid',
                'filter-solid',
                'fingerprint-solid',
                'fire-alt-solid',
                'fire-extinguisher-solid',
                'fire-solid',
                'firefox',
                'first-aid-solid',
                'first-order-alt',
                'first-order',
                'firstdraft',
                'fish-solid',
                'fist-raised-solid',
                'flag-checkered-solid',
                'flag-solid',
                'flag-usa-solid',
                'flag',
                'flask-solid',
                'flickr',
                'flipboard',
                'flushed-solid',
                'flushed',
                'fly',
                'folder-minus-solid',
                'folder-open-solid',
                'folder-open',
                'folder-plus-solid',
                'folder-solid',
                'folder',
                'font-awesome-alt',
                'font-awesome-flag',
                'font-awesome',
                'font-solid',
                'fonticons-fi',
                'fonticons',
                'football-ball-solid',
                'fort-awesome-alt',
                'fort-awesome',
                'forumbee',
                'forward-solid',
                'foursquare',
                'free-code-camp',
                'freebsd',
                'frog-solid',
                'frown-open-solid',
                'frown-open',
                'frown-solid',
                'frown',
                'fulcrum',
                'funnel-dollar-solid',
                'futbol-solid',
                'futbol',
                'galactic-republic',
                'galactic-senate',
                'gamepad-solid',
                'gas-pump-solid',
                'gavel-solid',
                'gem-solid',
                'gem',
                'genderless-solid',
                'get-pocket',
                'gg-circle',
                'gg',
                'ghost-solid',
                'gift-solid',
                'gifts-solid',
                'git-alt',
                'git-square',
                'git',
                'github-alt',
                'github-square',
                'github',
                'gitkraken',
                'gitlab',
                'gitter',
                'glass-cheers-solid',
                'glass-martini-alt-solid',
                'glass-martini-solid',
                'glass-whiskey-solid',
                'glasses-solid',
                'glide-g',
                'glide',
                'globe-africa-solid',
                'globe-americas-solid',
                'globe-asia-solid',
                'globe-europe-solid',
                'globe-solid',
                'gofore',
                'golf-ball-solid',
                'goodreads-g',
                'goodreads',
                'google-drive',
                'google-play',
                'google-plus-g',
                'google-plus-square',
                'google-plus',
                'google-wallet',
                'google',
                'gopuram-solid',
                'graduation-cap-solid',
                'gratipay',
                'grav',
                'greater-than-equal-solid',
                'greater-than-solid',
                'grimace-solid',
                'grimace',
                'grin-alt-solid',
                'grin-alt',
                'grin-beam-solid',
                'grin-beam-sweat-solid',
                'grin-beam-sweat',
                'grin-beam',
                'grin-hearts-solid',
                'grin-hearts',
                'grin-solid',
                'grin-squint-solid',
                'grin-squint-tears-solid',
                'grin-squint-tears',
                'grin-squint',
                'grin-stars-solid',
                'grin-stars',
                'grin-tears-solid',
                'grin-tears',
                'grin-tongue-solid',
                'grin-tongue-squint-solid',
                'grin-tongue-squint',
                'grin-tongue-wink-solid',
                'grin-tongue-wink',
                'grin-tongue',
                'grin-wink-solid',
                'grin-wink',
                'grin',
                'grip-horizontal-solid',
                'grip-lines-solid',
                'grip-lines-vertical-solid',
                'grip-vertical-solid',
                'gripfire',
                'grunt',
                'guitar-solid',
                'gulp',
                'h-square-solid',
                'hacker-news-square',
                'hacker-news',
                'hackerrank',
                'hamburger-solid',
                'hammer-solid',
                'hamsa-solid',
                'hand-holding-heart-solid',
                'hand-holding-solid',
                'hand-holding-usd-solid',
                'hand-lizard-solid',
                'hand-lizard',
                'hand-middle-finger-solid',
                'hand-paper-solid',
                'hand-paper',
                'hand-peace-solid',
                'hand-peace',
                'hand-point-down-solid',
                'hand-point-down',
                'hand-point-left-solid',
                'hand-point-left',
                'hand-point-right-solid',
                'hand-point-right',
                'hand-point-up-solid',
                'hand-point-up',
                'hand-pointer-solid',
                'hand-pointer',
                'hand-rock-solid',
                'hand-rock',
                'hand-scissors-solid',
                'hand-scissors',
                'hand-spock-solid',
                'hand-spock',
                'hands-helping-solid',
                'hands-solid',
                'handshake-solid',
                'handshake',
                'hanukiah-solid',
                'hard-hat-solid',
                'hashtag-solid',
                'hat-cowboy-side-solid',
                'hat-cowboy-solid',
                'hat-wizard-solid',
                'haykal-solid',
                'hdd-solid',
                'hdd',
                'heading-solid',
                'headphones-alt-solid',
                'headphones-solid',
                'headset-solid',
                'heart-broken-solid',
                'heart-solid',
                'heart',
                'heartbeat-solid',
                'helicopter-solid',
                'highlighter-solid',
                'hiking-solid',
                'hippo-solid',
                'hips',
                'hire-a-helper',
                'history-solid',
                'hockey-puck-solid',
                'holly-berry-solid',
                'home-solid',
                'hooli',
                'hornbill',
                'horse-head-solid',
                'horse-solid',
                'hospital-alt-solid',
                'hospital-solid',
                'hospital-symbol-solid',
                'hospital',
                'hot-tub-solid',
                'hotdog-solid',
                'hotel-solid',
                'hotjar',
                'hourglass-end-solid',
                'hourglass-half-solid',
                'hourglass-solid',
                'hourglass-start-solid',
                'hourglass',
                'house-damage-solid',
                'houzz',
                'hryvnia-solid',
                'html5',
                'hubspot',
                'i-cursor-solid',
                'ice-cream-solid',
                'icicles-solid',
                'icons-solid',
                'id-badge-solid',
                'id-badge',
                'id-card-alt-solid',
                'id-card-solid',
                'id-card',
                'igloo-solid',
                'image-solid',
                'image',
                'images-solid',
                'images',
                'imdb',
                'inbox-solid',
                'indent-solid',
                'industry-solid',
                'infinity-solid',
                'info-circle-solid',
                'info-solid',
                'instagram',
                'intercom',
                'internet-explorer',
                'invision',
                'ioxhost',
                'italic-solid',
                'itch-io',
                'itunes-note',
                'itunes',
                'java',
                'jedi-order',
                'jedi-solid',
                'jenkins',
                'jira',
                'joget',
                'joint-solid',
                'joomla',
                'journal-whills-solid',
                'js-square',
                'js',
                'jsfiddle',
                'kaaba-solid',
                'kaggle',
                'key-solid',
                'keybase',
                'keyboard-solid',
                'keyboard',
                'keycdn',
                'khanda-solid',
                'kickstarter-k',
                'kickstarter',
                'kiss-beam-solid',
                'kiss-beam',
                'kiss-solid',
                'kiss-wink-heart-solid',
                'kiss-wink-heart',
                'kiss',
                'kiwi-bird-solid',
                'korvue',
                'landmark-solid',
                'language-solid',
                'laptop-code-solid',
                'laptop-medical-solid',
                'laptop-solid',
                'laravel',
                'lastfm-square',
                'lastfm',
                'laugh-beam-solid',
                'laugh-beam',
                'laugh-solid',
                'laugh-squint-solid',
                'laugh-squint',
                'laugh-wink-solid',
                'laugh-wink',
                'laugh',
                'layer-group-solid',
                'leaf-solid',
                'leanpub',
                'lemon-solid',
                'lemon',
                'less-than-equal-solid',
                'less-than-solid',
                'less',
                'level-down-alt-solid',
                'level-up-alt-solid',
                'life-ring-solid',
                'life-ring',
                'lightbulb-solid',
                'lightbulb',
                'line',
                'link-solid',
                'linkedin-in',
                'linkedin',
                'linode',
                'linux',
                'lira-sign-solid',
                'list-alt-solid',
                'list-alt',
                'list-ol-solid',
                'list-solid',
                'list-ul-solid',
                'location-arrow-solid',
                'lock-open-solid',
                'lock-solid',
                'long-arrow-alt-down-solid',
                'long-arrow-alt-left-solid',
                'long-arrow-alt-right-solid',
                'long-arrow-alt-up-solid',
                'low-vision-solid',
                'luggage-cart-solid',
                'lyft',
                'magento',
                'magic-solid',
                'magnet-solid',
                'mail-bulk-solid',
                'mailchimp',
                'male-solid',
                'mandalorian',
                'map-marked-alt-solid',
                'map-marked-solid',
                'map-marker-alt-solid',
                'map-marker-solid',
                'map-pin-solid',
                'map-signs-solid',
                'map-solid',
                'map',
                'markdown',
                'marker-solid',
                'mars-double-solid',
                'mars-solid',
                'mars-stroke-h-solid',
                'mars-stroke-solid',
                'mars-stroke-v-solid',
                'mask-solid',
                'mastodon',
                'maxcdn',
                'mdb',
                'medal-solid',
                'medapps',
                'medium-m',
                'medium',
                'medkit-solid',
                'medrt',
                'meetup',
                'megaport',
                'meh-blank-solid',
                'meh-blank',
                'meh-rolling-eyes-solid',
                'meh-rolling-eyes',
                'meh-solid',
                'meh',
                'memory-solid',
                'mendeley',
                'menorah-solid',
                'mercury-solid',
                'meteor-solid',
                'microchip-solid',
                'microphone-alt-slash-solid',
                'microphone-alt-solid',
                'microphone-slash-solid',
                'microphone-solid',
                'microscope-solid',
                'microsoft',
                'minus-circle-solid',
                'minus-solid',
                'minus-square-solid',
                'minus-square',
                'mitten-solid',
                'mix',
                'mixcloud',
                'mizuni',
                'mobile-alt-solid',
                'mobile-solid',
                'modx',
                'monero',
                'money-bill-alt-solid',
                'money-bill-alt',
                'money-bill-solid',
                'money-bill-wave-alt-solid',
                'money-bill-wave-solid',
                'money-check-alt-solid',
                'money-check-solid',
                'monument-solid',
                'moon-solid',
                'moon',
                'mortar-pestle-solid',
                'mosque-solid',
                'motorcycle-solid',
                'mountain-solid',
                'mouse-pointer-solid',
                'mouse-solid',
                'mug-hot-solid',
                'music-solid',
                'napster',
                'neos',
                'network-wired-solid',
                'neuter-solid',
                'newspaper-solid',
                'newspaper',
                'nimblr',
                'node-js',
                'node',
                'not-equal-solid',
                'notes-medical-solid',
                'npm',
                'ns8',
                'nutritionix',
                'object-group-solid',
                'object-group',
                'object-ungroup-solid',
                'object-ungroup',
                'odnoklassniki-square',
                'odnoklassniki',
                'oil-can-solid',
                'old-republic',
                'om-solid',
                'opencart',
                'openid',
                'opera',
                'optin-monster',
                'orcid',
                'osi',
                'otter-solid',
                'outdent-solid',
                'page4',
                'pagelines',
                'pager-solid',
                'paint-brush-solid',
                'paint-roller-solid',
                'palette-solid',
                'palfed',
                'pallet-solid',
                'paper-plane-solid',
                'paper-plane',
                'paperclip-solid',
                'parachute-box-solid',
                'paragraph-solid',
                'parking-solid',
                'passport-solid',
                'pastafarianism-solid',
                'paste-solid',
                'patreon',
                'pause-circle-solid',
                'pause-circle',
                'pause-solid',
                'paw-solid',
                'paypal',
                'peace-solid',
                'pen-alt-solid',
                'pen-fancy-solid',
                'pen-nib-solid',
                'pen-solid',
                'pen-square-solid',
                'pencil-alt-solid',
                'pencil-ruler-solid',
                'penny-arcade',
                'people-carry-solid',
                'pepper-hot-solid',
                'percent-solid',
                'percentage-solid',
                'periscope',
                'person-booth-solid',
                'phabricator',
                'phoenix-framework',
                'phoenix-squadron',
                'phone-alt-solid',
                'phone-slash-solid',
                'phone-solid',
                'phone-square-alt-solid',
                'phone-square-solid',
                'phone-volume-solid',
                'photo-video-solid',
                'php',
                'pied-piper-alt',
                'pied-piper-hat',
                'pied-piper-pp',
                'pied-piper',
                'piggy-bank-solid',
                'pills-solid',
                'pinterest-p',
                'pinterest-square',
                'pinterest',
                'pizza-slice-solid',
                'place-of-worship-solid',
                'plane-arrival-solid',
                'plane-departure-solid',
                'plane-solid',
                'play-circle-solid',
                'play-circle',
                'play-solid',
                'playstation',
                'plug-solid',
                'plus-circle-solid',
                'plus-solid',
                'plus-square-solid',
                'plus-square',
                'podcast-solid',
                'poll-h-solid',
                'poll-solid',
                'poo-solid',
                'poo-storm-solid',
                'poop-solid',
                'portrait-solid',
                'pound-sign-solid',
                'power-off-solid',
                'pray-solid',
                'praying-hands-solid',
                'prescription-bottle-alt-solid',
                'prescription-bottle-solid',
                'prescription-solid',
                'print-solid',
                'procedures-solid',
                'product-hunt',
                'project-diagram-solid',
                'pushed',
                'puzzle-piece-solid',
                'python',
                'qq',
                'qrcode-solid',
                'question-circle-solid',
                'question-circle',
                'question-solid',
                'quidditch-solid',
                'quinscape',
                'quora',
                'quote-left-solid',
                'quote-right-solid',
                'quran-solid',
                'r-project',
                'radiation-alt-solid',
                'radiation-solid',
                'rainbow-solid',
                'random-solid',
                'raspberry-pi',
                'ravelry',
                'react',
                'reacteurope',
                'readme',
                'rebel',
                'receipt-solid',
                'record-vinyl-solid',
                'recycle-solid',
                'red-river',
                'reddit-alien',
                'reddit-square',
                'reddit',
                'redhat',
                'redo-alt-solid',
                'redo-solid',
                'registered-solid',
                'registered',
                'remove-format-solid',
                'renren',
                'reply-all-solid',
                'reply-solid',
                'replyd',
                'republican-solid',
                'researchgate',
                'resolving',
                'restroom-solid',
                'retweet-solid',
                'rev',
                'ribbon-solid',
                'ring-solid',
                'road-solid',
                'robot-solid',
                'rocket-solid',
                'rocketchat',
                'rockrms',
                'route-solid',
                'rss-solid',
                'rss-square-solid',
                'ruble-sign-solid',
                'ruler-combined-solid',
                'ruler-horizontal-solid',
                'ruler-solid',
                'ruler-vertical-solid',
                'running-solid',
                'rupee-sign-solid',
                'sad-cry-solid',
                'sad-cry',
                'sad-tear-solid',
                'sad-tear',
                'safari',
                'salesforce',
                'sass',
                'satellite-dish-solid',
                'satellite-solid',
                'save-solid',
                'save',
                'schlix',
                'school-solid',
                'screwdriver-solid',
                'scribd',
                'scroll-solid',
                'sd-card-solid',
                'search-dollar-solid',
                'search-location-solid',
                'search-minus-solid',
                'search-plus-solid',
                'search-solid',
                'searchengin',
                'seedling-solid',
                'sellcast',
                'sellsy',
                'server-solid',
                'servicestack',
                'shapes-solid',
                'share-alt-solid',
                'share-alt-square-solid',
                'share-solid',
                'share-square-solid',
                'share-square',
                'shekel-sign-solid',
                'shield-alt-solid',
                'ship-solid',
                'shipping-fast-solid',
                'shirtsinbulk',
                'shoe-prints-solid',
                'shopping-bag-solid',
                'shopping-basket-solid',
                'shopping-cart-solid',
                'shopware',
                'shower-solid',
                'shuttle-van-solid',
                'sign-in-alt-solid',
                'sign-language-solid',
                'sign-out-alt-solid',
                'sign-solid',
                'signal-solid',
                'signature-solid',
                'sim-card-solid',
                'simplybuilt',
                'sistrix',
                'sitemap-solid',
                'sith',
                'skating-solid',
                'sketch',
                'skiing-nordic-solid',
                'skiing-solid',
                'skull-crossbones-solid',
                'skull-solid',
                'skyatlas',
                'skype',
                'slack-hash',
                'slack',
                'slash-solid',
                'sleigh-solid',
                'sliders-h-solid',
                'slideshare',
                'smile-beam-solid',
                'smile-beam',
                'smile-solid',
                'smile-wink-solid',
                'smile-wink',
                'smile',
                'smog-solid',
                'smoking-ban-solid',
                'smoking-solid',
                'sms-solid',
                'snapchat-ghost',
                'snapchat-square',
                'snapchat',
                'snowboarding-solid',
                'snowflake-solid',
                'snowflake',
                'snowman-solid',
                'snowplow-solid',
                'socks-solid',
                'solar-panel-solid',
                'sort-alpha-down-alt-solid',
                'sort-alpha-down-solid',
                'sort-alpha-up-alt-solid',
                'sort-alpha-up-solid',
                'sort-amount-down-alt-solid',
                'sort-amount-down-solid',
                'sort-amount-up-alt-solid',
                'sort-amount-up-solid',
                'sort-down-solid',
                'sort-numeric-down-alt-solid',
                'sort-numeric-down-solid',
                'sort-numeric-up-alt-solid',
                'sort-numeric-up-solid',
                'sort-solid',
                'sort-up-solid',
                'soundcloud',
                'sourcetree',
                'spa-solid',
                'space-shuttle-solid',
                'speakap',
                'speaker-deck',
                'spell-check-solid',
                'spider-solid',
                'spinner-solid',
                'splotch-solid',
                'spotify',
                'spray-can-solid',
                'square-full-solid',
                'square-root-alt-solid',
                'square-solid',
                'square',
                'squarespace',
                'stack-exchange',
                'stack-overflow',
                'stackpath',
                'stamp-solid',
                'star-and-crescent-solid',
                'star-half-alt-solid',
                'star-half-solid',
                'star-half',
                'star-of-david-solid',
                'star-of-life-solid',
                'star-solid',
                'star',
                'staylinked',
                'steam-square',
                'steam-symbol',
                'steam',
                'step-backward-solid',
                'step-forward-solid',
                'stethoscope-solid',
                'sticker-mule',
                'sticky-note-solid',
                'sticky-note',
                'stop-circle-solid',
                'stop-circle',
                'stop-solid',
                'stopwatch-solid',
                'store-alt-solid',
                'store-solid',
                'strava',
                'stream-solid',
                'street-view-solid',
                'strikethrough-solid',
                'stripe-s',
                'stripe',
                'stroopwafel-solid',
                'studiovinari',
                'stumbleupon-circle',
                'stumbleupon',
                'subscript-solid',
                'subway-solid',
                'suitcase-rolling-solid',
                'suitcase-solid',
                'sun-solid',
                'sun',
                'superpowers',
                'superscript-solid',
                'supple',
                'surprise-solid',
                'surprise',
                'suse',
                'swatchbook-solid',
                'swift',
                'swimmer-solid',
                'swimming-pool-solid',
                'symfony',
                'synagogue-solid',
                'sync-alt-solid',
                'sync-solid',
                'syringe-solid',
                'table-solid',
                'table-tennis-solid',
                'tablet-alt-solid',
                'tablet-solid',
                'tablets-solid',
                'tachometer-alt-solid',
                'tag-solid',
                'tags-solid',
                'tape-solid',
                'tasks-solid',
                'taxi-solid',
                'teamspeak',
                'teeth-open-solid',
                'teeth-solid',
                'telegram-plane',
                'telegram',
                'temperature-high-solid',
                'temperature-low-solid',
                'tencent-weibo',
                'tenge-solid',
                'terminal-solid',
                'text-height-solid',
                'text-width-solid',
                'th-large-solid',
                'th-list-solid',
                'th-solid',
                'the-red-yeti',
                'theater-masks-solid',
                'themeco',
                'themeisle',
                'thermometer-empty-solid',
                'thermometer-full-solid',
                'thermometer-half-solid',
                'thermometer-quarter-solid',
                'thermometer-solid',
                'thermometer-three-quarters-solid',
                'think-peaks',
                'thumbs-down-solid',
                'thumbs-down',
                'thumbs-up-solid',
                'thumbs-up',
                'thumbtack-solid',
                'ticket-alt-solid',
                'times-circle-solid',
                'times-circle',
                'times-solid',
                'tint-slash-solid',
                'tint-solid',
                'tired-solid',
                'tired',
                'toggle-off-solid',
                'toggle-on-solid',
                'toilet-paper-solid',
                'toilet-solid',
                'toolbox-solid',
                'tools-solid',
                'tooth-solid',
                'torah-solid',
                'torii-gate-solid',
                'tractor-solid',
                'trade-federation',
                'trademark-solid',
                'traffic-light-solid',
                'train-solid',
                'tram-solid',
                'transgender-alt-solid',
                'transgender-solid',
                'trash-alt-solid',
                'trash-alt',
                'trash-restore-alt-solid',
                'trash-restore-solid',
                'trash-solid',
                'tree-solid',
                'trello',
                'tripadvisor',
                'trophy-solid',
                'truck-loading-solid',
                'truck-monster-solid',
                'truck-moving-solid',
                'truck-pickup-solid',
                'truck-solid',
                'tshirt-solid',
                'tty-solid',
                'tumblr-square',
                'tumblr',
                'tv-solid',
                'twitch',
                'twitter-square',
                'twitter',
                'typo3',
                'uber',
                'ubuntu',
                'uikit',
                'umbraco',
                'umbrella-beach-solid',
                'umbrella-solid',
                'underline-solid',
                'undo-alt-solid',
                'undo-solid',
                'uniregistry',
                'universal-access-solid',
                'university-solid',
                'unlink-solid',
                'unlock-alt-solid',
                'unlock-solid',
                'untappd',
                'upload-solid',
                'ups',
                'usb',
                'user-alt-slash-solid',
                'user-alt-solid',
                'user-astronaut-solid',
                'user-check-solid',
                'user-circle-solid',
                'user-circle',
                'user-clock-solid',
                'user-cog-solid',
                'user-edit-solid',
                'user-friends-solid',
                'user-graduate-solid',
                'user-injured-solid',
                'user-lock-solid',
                'user-md-solid',
                'user-minus-solid',
                'user-ninja-solid',
                'user-nurse-solid',
                'user-plus-solid',
                'user-secret-solid',
                'user-shield-solid',
                'user-slash-solid',
                'user-solid',
                'user-tag-solid',
                'user-tie-solid',
                'user-times-solid',
                'user',
                'users-cog-solid',
                'users-solid',
                'usps',
                'ussunnah',
                'utensil-spoon-solid',
                'utensils-solid',
                'vaadin',
                'vector-square-solid',
                'venus-double-solid',
                'venus-mars-solid',
                'venus-solid',
                'viacoin',
                'viadeo-square',
                'viadeo',
                'vial-solid',
                'vials-solid',
                'viber',
                'video-slash-solid',
                'video-solid',
                'vihara-solid',
                'vimeo-square',
                'vimeo-v',
                'vimeo',
                'vine',
                'vk',
                'vnv',
                'voicemail-solid',
                'volleyball-ball-solid',
                'volume-down-solid',
                'volume-mute-solid',
                'volume-off-solid',
                'volume-up-solid',
                'vote-yea-solid',
                'vr-cardboard-solid',
                'vuejs',
                'walking-solid',
                'wallet-solid',
                'warehouse-solid',
                'water-solid',
                'wave-square-solid',
                'waze',
                'weebly',
                'weibo',
                'weight-hanging-solid',
                'weight-solid',
                'weixin',
                'whatsapp-square',
                'whatsapp',
                'wheelchair-solid',
                'whmcs',
                'wifi-solid',
                'wikipedia-w',
                'wind-solid',
                'window-close-solid',
                'window-close',
                'window-maximize-solid',
                'window-maximize',
                'window-minimize-solid',
                'window-minimize',
                'window-restore-solid',
                'window-restore',
                'windows',
                'wine-bottle-solid',
                'wine-glass-alt-solid',
                'wine-glass-solid',
                'wix',
                'wizards-of-the-coast',
                'wolf-pack-battalion',
                'won-sign-solid',
                'wordpress-simple',
                'wordpress',
                'wpbeginner',
                'wpexplorer',
                'wpforms',
                'wpressr',
                'wrench-solid',
                'x-ray-solid',
                'xbox',
                'xing-square',
                'xing',
                'y-combinator',
                'yahoo',
                'yammer',
                'yandex-international',
                'yandex',
                'yarn',
                'yelp',
                'yen-sign-solid',
                'yin-yang-solid',
                'yoast',
                'youtube-square',
                'youtube',
                'zhihu',
            ];

            $additional_tabs[ 'fontflow-lineicons' ] = [
                'name'          => 'fontflow-lineicons',
                'label'         => esc_html__( 'FontFlow - LineIcons', 'fontflow' ),
                'labelIcon'     => 'fas fa-chevron-right',
                'ver'           => esc_attr( FCIFE_CONST_VERSION ),
                'prefix'        => 'fontflow-lineicons-',
                'displayPrefix' => 'fontflow-lineicons',
                'url'           => esc_url( FCIFE_CONST_URL . 'assets/css/lineicons/fontflow-lineicons.min.css' ),
                'enqueue'       => [ FCIFE_CONST_URL . 'assets/css/lineicons/fontflow-lineicons.min.css' ],
                'icons'         => $icons
            ];

            return $additional_tabs;
        }
    }

}

if( !function_exists( 'fontflow_wp_plugin_elementor_line_icons' ) ) {

    /**
     * Returns the instance of a class.
     */
    function fontflow_wp_plugin_elementor_line_icons() {

        return FontFlow_WP_Plugin_Elementor_Line_Icons::get_instance();
    }
}

fontflow_wp_plugin_elementor_line_icons();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */