(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Image_Accordion;

        KFW_Image_Accordion = moduleHandler.extend({
            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                var $main     = this,
                    $id       = $main.getID(),
                    $wrapper  = $main.findElement('.kfw-elementor-widget-image-accordion-wrapper'),
                    $settings = $wrapper.data('settings') || {},
                    $items    = $('.kfw-elementor-image-accordion-item', $wrapper );

                if( typeof ( $settings.anim_duration ) !== 'undefined' ) {
                    $items.css({
                        'transition-duration': $settings.anim_duration + 'ms'
                    });
                }

                $('.kfw-elementor-widget-image-accordion-image', $items ).imagesLoaded().progress(function( $instance, $image ){
                    $($image.img).removeClass('kfw-image-is-loading');
                    $class = $image.isLoaded ? 'kfw-image-is-loaded' : 'kfw-image-is-broken';
                    $($image.img).addClass( $class );
                });

                if( $settings.active_item === true && ( $settings.active_item_no <= $settings.total_items ) ){
                    $items.removeClass('kfw-elementor-image-accordion-active-item');
                    $items.eq($settings.active_item_no - 1).addClass('kfw-elementor-image-accordion-active-item');

                    $main._render({
                        'main'    : $main,
                        'id'      : $id,
                        'wrapper' : $wrapper,
                        'settings': $settings,
                        'items'   : $items
                    });
                }

                $($items).on($settings.trigger, function(){
                    $(this).siblings().removeClass('kfw-elementor-image-accordion-active-item');
                    $(this).addClass('kfw-elementor-image-accordion-active-item');

                    $main._render({
                        'main'    : $main,
                        'id'      : $id,
                        'wrapper' : $wrapper,
                        'settings': $settings,
                        'items'   : $items
                    });
                });

                $main._render({
                    'main'    : $main,
                    'id'      : $id,
                    'wrapper' : $wrapper,
                    'settings': $settings,
                    'items'   : $items
                });
            },

            _render: function( $options ) {
                var $active_size = $options.settings.active_size.size,
                    $grow        = $active_size / ( ( 100 - $active_size  ) / ( $options.settings.total_items - 1 ) );

                $('.kfw-elementor-image-accordion-item:not(.kfw-elementor-image-accordion-active-item)', $options.wrapper ).css({
                    'flex-grow': 1
                });

                $('.kfw-elementor-image-accordion-active-item', $options.wrapper ).css({
                    'flex-grow': $grow
                });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-image-accordion', KFW_Image_Accordion );
    });
})( jQuery, window.elementorFrontend );