(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Image_Expand;

        KFW_Image_Expand = moduleHandler.extend({
            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                var $main        = this,
                    $id          = $main.getID(),
                    $eleName     = $main.getSettings().elementName,
                    $wrapper     = $main.findElement('.kfw-ele-widget-img-expand-wrapper'),
                    $settings    = $wrapper.data('settings') || {},
                    $items       = $('.kfw-ele-img-expand-item', $wrapper )
                    $activeClass = 'kfw-ele-img-expand-active-item';

                $('body').addClass( $eleName );

                $('.kfw-ele-widget-img-expand-image', $items ).imagesLoaded().progress(function( $instance, $image ){
                    $($image.img).removeClass('kfw-image-is-loading');
                    $class = $image.isLoaded ? 'kfw-image-is-loaded' : 'kfw-image-is-broken';
                    $($image.img).addClass( $class );
                });

                if( $settings.active_item === true && ( $settings.active_item_no <= $settings.total_items ) ){
                    $items.removeClass( $activeClass );
                    $items.eq($settings.active_item_no - 1)
                        .addClass( $activeClass )
                        .addClass('kfw-ele-img-expand-default-active-item');
                }

                $($items).on('click', function(){
                    $(this).toggleClass( $activeClass );
                });

                if( $('body').hasClass( $eleName ) ) {
                    $(document).on('click', 'body', function(e){
                        if( $(e.target).parents('.kfw-ele-widget-img-expand-wrapper').length ) {
                        } else {
                            $('.kfw-ele-img-expand-active-item').removeClass( $activeClass );
                            $('.kfw-ele-img-expand-default-active-item').addClass( $activeClass );
                        }
                    });
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-image-expand', KFW_Image_Expand );
    });
})( jQuery, window.elementorFrontend );
