(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){

        let moduleHandler             = elementorModules.frontend.handlers.Base,
            KFW_Interactive_Accordion = '';

        KFW_Interactive_Accordion = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-interactive-accordion-main'
                    },
                    classes: {
                        active: 'kfw-active-item',
                    },
                }
            },
            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main         : this.$element.find( main ),
                    $frontSettings: this.$element.find( main ).data("settings"),
                }
            },
            bindEvents: function() {
                this._execute();
            },
            _execute() {
                let $id          = this.getID(),
                    $main        = this.elements.$main,
                    $settings    = this.elements.$frontSettings,
                    $activeClass = this.getSettings( 'classes.active' );

                let $ImgSectionsWrap = $(".kfw-accordion-img-section-wrap", $main );
                let $ImgSections     = $(".kfw-elementor-accordion-image-item", $ImgSectionsWrap );

                let $ConSectionsWrap = $(".kfw-accordion-content-section-wrap", $main );
                let $ConSections     = $(".kfw-elementor-accordion-content-item", $ConSectionsWrap );

                if( $settings.active_item === true && ( $settings.active_item_no <= $settings.total_items ) ){
                    $ImgSections.removeClass( $activeClass );
                    $ImgSections.eq($settings.active_item_no - 1).addClass( $activeClass );

                    $ConSections.removeClass( $activeClass );
                    $ConSections.eq($settings.active_item_no - 1).addClass( $activeClass );
                }

                $($ConSections).on($settings.trigger, function(){
                    let $id = $(this).attr("data-id");
                    $(this).siblings().removeClass( $activeClass );
                    $(this).addClass( $activeClass );

                    $($ImgSections).siblings().removeClass( $activeClass );
                    $($ImgSections).filter( '[data-id="' + $id + '"]' ).addClass( $activeClass );
                });
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-interactive-accordion', KFW_Interactive_Accordion );
    });
})( jQuery, window.elementorFrontend );
